/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.quickstart;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.function.Supplier;
import org.eclipse.jetty.ee8.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ee8.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.ee8.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.ee8.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.ee8.webapp.Configuration;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreconfigureQuickStartWar {
    private static final Logger LOG = LoggerFactory.getLogger(PreconfigureQuickStartWar.class);
    static final boolean ORIGIN = LOG.isDebugEnabled();

    public static void main(String ... args) throws Exception {
        Resource war = null;
        Resource dir = null;
        Resource xml = null;
        try (ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();){
            switch (args.length) {
                case 0: {
                    PreconfigureQuickStartWar.error("No WAR file or directory given");
                    break;
                }
                case 1: {
                    dir = resourceFactory.newResource(args[0]);
                    break;
                }
                case 2: {
                    war = resourceFactory.newResource(args[0]);
                    if (war.isDirectory()) {
                        dir = war;
                        war = null;
                        xml = resourceFactory.newResource(args[1]);
                        break;
                    }
                    dir = resourceFactory.newResource(args[1]);
                    break;
                }
                case 3: {
                    war = resourceFactory.newResource(args[0]);
                    dir = resourceFactory.newResource(args[1]);
                    xml = resourceFactory.newResource(args[2]);
                    break;
                }
                default: {
                    PreconfigureQuickStartWar.error("Too many args");
                }
            }
            PreconfigureQuickStartWar.preconfigure(war, dir, xml);
        }
    }

    public static void preconfigure(Resource war, Resource dir, Resource xml) throws Exception {
        if (war != null) {
            if (war.isDirectory()) {
                PreconfigureQuickStartWar.error("war file is directory");
            }
            if (!dir.exists()) {
                Files.createDirectories(dir.getPath(), new FileAttribute[0]);
            }
            try (ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();){
                Resource warResource = resourceFactory.newResource(URIUtil.toJarFileUri((URI)war.getURI()));
                warResource.copyTo(dir.getPath());
            }
        }
        Server server = new Server();
        WebAppContext webapp = new WebAppContext();
        webapp.addConfiguration(new Configuration[]{new QuickStartConfiguration(), new EnvConfiguration(), new PlusConfiguration(), new AnnotationConfiguration()});
        webapp.setAttribute("org.eclipse.jetty.quickstart.mode", (Object)QuickStartConfiguration.Mode.GENERATE);
        webapp.setAttribute("org.eclipse.jetty.quickstart.origin", (Object)"");
        webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/jetty-javax-servlet-api-[^/]*\\\\.jar$|.*/javax.servlet.jsp.jstl-.*\\\\.jar$|.*/.*taglibs-standard-.*\\\\.jar$");
        if (xml != null) {
            if (xml.isDirectory() || !xml.toString().toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                PreconfigureQuickStartWar.error("Bad context.xml: " + String.valueOf(xml));
            }
            XmlConfiguration xmlConfiguration = new XmlConfiguration(xml);
            xmlConfiguration.configure((Object)webapp);
        }
        webapp.setBaseResource(dir);
        server.setHandler((Supplier)webapp);
        try {
            server.setDryRun(true);
            server.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (!server.isStopped()) {
                server.stop();
            }
        }
    }

    private static void error(String message) {
        System.err.println("ERROR: " + message);
        System.err.println("Usage: java -jar PreconfigureQuickStartWar.jar <war-directory>");
        System.err.println("       java -jar PreconfigureQuickStartWar.jar <war-directory> <context-xml-file>");
        System.err.println("       java -jar PreconfigureQuickStartWar.jar <war-file> <target-war-directory>");
        System.err.println("       java -jar PreconfigureQuickStartWar.jar <war-file> <target-war-directory> <context-xml-file>");
        System.exit(1);
    }
}

