/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.HTTP3Stream;
import org.eclipse.jetty.http3.HTTP3StreamConnection;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.GoAwayFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.Atomics;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTP3Session
extends ContainerLifeCycle
implements Session,
ParserListener {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3Session.class);
    private final AutoLock lock = new AutoLock();
    private final AtomicLong lastStreamId = new AtomicLong(0L);
    private final Map<Long, HTTP3Stream> streams = new ConcurrentHashMap<Long, HTTP3Stream>();
    private final ProtocolSession session;
    private final Session.Listener listener;
    private final AtomicInteger streamCount = new AtomicInteger();
    private final StreamTimeouts streamTimeouts;
    private long streamIdleTimeout;
    private CloseState closeState = CloseState.CLOSED;
    private GoAwayFrame goAwaySent;
    private GoAwayFrame goAwayRecv;
    private Runnable zeroStreamsAction;
    private CompletableFuture<Void> shutdown;

    public HTTP3Session(ProtocolSession session, Session.Listener listener) {
        this.session = session;
        this.listener = listener;
        this.streamTimeouts = new StreamTimeouts(session.getQuicSession().getScheduler());
    }

    public ProtocolSession getProtocolSession() {
        return this.session;
    }

    public Session.Listener getListener() {
        return this.listener;
    }

    public void onOpen() {
        this.closeState = CloseState.NOT_CLOSED;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.getProtocolSession().getQuicSession().getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.getProtocolSession().getQuicSession().getRemoteAddress();
    }

    @Override
    public Collection<Stream> getStreams() {
        return List.copyOf(this.streams.values());
    }

    public int getMaxLocalStreams() {
        return this.session.getMaxLocalStreams();
    }

    @Override
    public CompletableFuture<Void> goAway(boolean graceful) {
        return this.goAway(this.newGoAwayFrame(graceful));
    }

    /*
     * Unable to fully structure code
     */
    private CompletableFuture<Void> goAway(GoAwayFrame frame) {
        if (HTTP3Session.LOG.isDebugEnabled()) {
            HTTP3Session.LOG.debug("goAway with {} on {}", (Object)frame, (Object)this);
        }
        failStreams = false;
        sendGoAway = false;
        ignored = this.lock.lock();
        try {
            switch (this.closeState.ordinal()) {
                case 0: {
                    this.goAwaySent = frame;
                    sendGoAway = true;
                    this.closeState = CloseState.LOCALLY_CLOSED;
                    if (frame.isGraceful()) {
                        this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$goAway$0(), ()V)((HTTP3Session)this);
                        ** break;
                    }
lbl15:
                    // 3 sources

                    break;
                }
                case 1: {
                    if (frame.isGraceful()) {
                        if (HTTP3Session.LOG.isDebugEnabled()) {
                            HTTP3Session.LOG.debug("already sent {} on {}", (Object)this.goAwaySent, (Object)this);
                            ** break;
                        }
lbl21:
                        // 3 sources

                    } else if (this.goAwaySent.isGraceful() || frame.getLastId() < this.goAwaySent.getLastId()) {
                        this.goAwaySent = frame;
                        sendGoAway = true;
                        ** break;
lbl26:
                        // 1 sources

                    } else {
                        this.closeState = CloseState.CLOSED;
                        failStreams = true;
                        ** break;
                    }
lbl30:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.goAwaySent = frame;
                    sendGoAway = true;
                    if (frame.isGraceful()) {
                        this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$goAway$1(), ()V)((HTTP3Session)this);
                        ** break;
lbl37:
                        // 1 sources

                    } else if (this.goAwayRecv.isGraceful()) {
                        if (HTTP3Session.LOG.isDebugEnabled()) {
                            HTTP3Session.LOG.debug("waiting non-graceful GOAWAY on {}", (Object)this);
                            ** break;
                        }
lbl42:
                        // 3 sources

                    } else {
                        this.closeState = CloseState.CLOSING;
                        this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, terminate(), ()V)((HTTP3Session)this);
                        ** break;
                    }
lbl46:
                    // 1 sources

                    break;
                }
                case 3: 
                case 4: {
                    if (HTTP3Session.LOG.isDebugEnabled()) {
                        HTTP3Session.LOG.debug("already closed on {}", (Object)this);
                        ** break;
                    }
lbl51:
                    // 3 sources

                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (sendGoAway) {
            result = new Callback.Completable();
            result.thenRun((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, tryRunZeroStreamsAction(), ()V)((HTTP3Session)this));
            this.writeControlFrame(frame, (Callback)result);
            return result;
        }
        if (failStreams) {
            error = HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code();
            reason = "go_away";
            this.failStreams((Predicate<HTTP3Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$goAway$2(org.eclipse.jetty.http3.HTTP3Stream ), (Lorg/eclipse/jetty/http3/HTTP3Stream;)Z)(), error, reason, true, new ClosedChannelException());
            this.terminateAndDisconnect(error, reason);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected GoAwayFrame newGoAwayFrame(boolean graceful) {
        return new GoAwayFrame(this.lastStreamId.get());
    }

    public CompletableFuture<Void> shutdown() {
        Callback.Completable result;
        try (AutoLock ignored = this.lock.lock();){
            if (this.shutdown != null) {
                CompletableFuture<Void> completableFuture = this.shutdown;
                return completableFuture;
            }
            this.shutdown = result = new Callback.Completable();
        }
        this.goAway(true);
        return result;
    }

    private void updateLastStreamId(long id) {
        Atomics.updateMax((AtomicLong)this.lastStreamId, (long)id);
    }

    public long getIdleTimeout() {
        return this.getProtocolSession().getIdleTimeout();
    }

    public long getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    public void setStreamIdleTimeout(long streamIdleTimeout) {
        this.streamIdleTimeout = streamIdleTimeout;
    }

    void scheduleIdleTimeout(HTTP3Stream stream) {
        this.streamTimeouts.schedule(stream);
    }

    protected HTTP3Stream createStream(QuicStreamEndPoint endPoint, Consumer<Throwable> fail) {
        long streamId = endPoint.getStreamId();
        return this.streams.compute(streamId, (id, stream) -> {
            if (stream != null) {
                throw new IllegalStateException("duplicate stream id " + streamId);
            }
            return this.newHTTP3Stream(endPoint, fail, true);
        });
    }

    protected HTTP3Stream getOrCreateStream(QuicStreamEndPoint endPoint) {
        if (endPoint == null) {
            return null;
        }
        return this.streams.computeIfAbsent(endPoint.getStreamId(), id -> this.newHTTP3Stream(endPoint, null, false));
    }

    private HTTP3Stream newHTTP3Stream(QuicStreamEndPoint endPoint, Consumer<Throwable> fail, boolean local) {
        IllegalStateException failure = null;
        try (AutoLock ignored = this.lock.lock();){
            if (this.closeState == CloseState.NOT_CLOSED) {
                this.streamCount.incrementAndGet();
            } else {
                failure = new IllegalStateException("session_closed");
            }
        }
        if (failure == null) {
            HTTP3Stream stream = this.newHTTP3Stream(endPoint, local);
            ((HTTP3StreamConnection)endPoint.getConnection()).setStream(stream);
            long idleTimeout = this.getStreamIdleTimeout();
            if (idleTimeout > 0L) {
                stream.setIdleTimeout(idleTimeout);
            }
            if (!local) {
                this.updateLastStreamId(stream.getId());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("created {}", (Object)stream);
            }
            return stream;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("could not create stream for {} on {}", (Object)endPoint, (Object)this);
        }
        if (fail != null) {
            fail.accept(failure);
        }
        return null;
    }

    protected abstract HTTP3Stream newHTTP3Stream(QuicStreamEndPoint var1, boolean var2);

    protected HTTP3Stream getStream(long streamId) {
        return this.streams.get(streamId);
    }

    public void removeStream(HTTP3Stream stream, Throwable failure) {
        boolean removed;
        boolean bl = removed = this.streams.remove(stream.getId()) != null;
        if (removed) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("destroyed {}", (Object)stream);
            }
            this.getProtocolSession().getQuicSession().remove(stream.getEndPoint(), failure);
            if (this.streamCount.decrementAndGet() == 0) {
                this.tryRunZeroStreamsAction();
            }
        }
    }

    public abstract void writeControlFrame(Frame var1, Callback var2);

    public abstract void writeMessageFrame(long var1, Frame var3, Callback var4);

    public Map<Long, Long> onPreface() {
        Map<Long, Long> settings = this.notifyPreface();
        if (LOG.isDebugEnabled()) {
            LOG.debug("application produced settings {} on {}", settings, (Object)this);
        }
        return settings;
    }

    private Map<Long, Long> notifyPreface() {
        try {
            return this.listener.onPreface(this);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
            return null;
        }
    }

    @Override
    public void onSettings(SettingsFrame frame) {
        this.notifySettings(frame);
    }

    private void notifySettings(SettingsFrame frame) {
        try {
            this.listener.onSettings(this, frame);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    private void notifyGoAway(GoAwayFrame frame) {
        try {
            this.listener.onGoAway(this, frame);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    private boolean notifyIdleTimeout() {
        try {
            return this.listener.onIdleTimeout(this);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
            return true;
        }
    }

    @Override
    public void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
        MetaData metaData = frame.getMetaData();
        if (metaData.isRequest() || metaData.isResponse()) {
            throw new IllegalStateException("invalid metadata");
        }
        QuicStreamEndPoint endPoint = this.session.getStreamEndPoint(streamId);
        HTTP3Stream stream = this.getOrCreateStream(endPoint);
        if (LOG.isDebugEnabled()) {
            LOG.debug("received trailer {} on {}", (Object)frame, (Object)stream);
        }
        if (stream != null) {
            stream.onTrailer(frame);
        }
    }

    @Override
    public void onData(long streamId, DataFrame frame) {
        HTTP3Stream stream = this.getStream(streamId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("received {} on {}", (Object)frame, (Object)stream);
        }
        if (stream != null) {
            stream.onData(frame);
        } else {
            this.onSessionFailure(HTTP3ErrorCode.FRAME_UNEXPECTED_ERROR.code(), "invalid_frame_sequence", new IllegalStateException("invalid frame sequence"));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onGoAway(GoAwayFrame frame) {
        if (HTTP3Session.LOG.isDebugEnabled()) {
            HTTP3Session.LOG.debug("received {} on {}", (Object)frame, (Object)this);
        }
        failStreams = false;
        ignored = this.lock.lock();
        try {
            switch (this.closeState.ordinal()) {
                case 0: {
                    this.goAwayRecv = frame;
                    if (frame.isGraceful()) {
                        this.closeState = CloseState.REMOTELY_CLOSED;
                        if (HTTP3Session.LOG.isDebugEnabled()) {
                            HTTP3Session.LOG.debug("waiting non-graceful GOAWAY on {}", (Object)this);
                            ** break;
                        }
lbl14:
                        // 3 sources

                    } else {
                        this.goAwaySent = this.newGoAwayFrame(false);
                        this.closeState = CloseState.CLOSING;
                        goAwayFrame = this.goAwaySent;
                        this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onGoAway$5(org.eclipse.jetty.http3.frames.GoAwayFrame ), ()V)((HTTP3Session)this, (GoAwayFrame)goAwayFrame);
                        failStreams = true;
                        ** break;
                    }
lbl21:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.goAwayRecv = frame;
                    if (frame.isGraceful()) {
                        if (HTTP3Session.LOG.isDebugEnabled()) {
                            HTTP3Session.LOG.debug("waiting non-graceful GOAWAY on {}", (Object)this);
                            ** break;
                        }
lbl28:
                        // 3 sources

                    } else {
                        this.closeState = CloseState.CLOSING;
                        if (this.goAwaySent.isGraceful()) {
                            goAwayFrame = this.goAwaySent = this.newGoAwayFrame(false);
                            this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onGoAway$7(org.eclipse.jetty.http3.frames.GoAwayFrame ), ()V)((HTTP3Session)this, (GoAwayFrame)goAwayFrame);
                            ** break;
lbl34:
                            // 1 sources

                        } else {
                            this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onGoAway$8(), ()V)((HTTP3Session)this);
                            failStreams = true;
                            ** break;
                        }
                    }
lbl38:
                    // 1 sources

                    break;
                }
                case 2: {
                    if (frame.isGraceful()) {
                        if (HTTP3Session.LOG.isDebugEnabled()) {
                            HTTP3Session.LOG.debug("already received {} on {}", (Object)this.goAwayRecv, (Object)this);
                            ** break;
                        }
lbl44:
                        // 3 sources

                    } else {
                        this.goAwayRecv = frame;
                        this.closeState = CloseState.CLOSING;
                        if (this.goAwaySent == null || this.goAwaySent.isGraceful()) {
                            goAwayFrame = this.goAwaySent = this.newGoAwayFrame(false);
                            this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onGoAway$9(org.eclipse.jetty.http3.frames.GoAwayFrame ), ()V)((HTTP3Session)this, (GoAwayFrame)goAwayFrame);
                        } else {
                            this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, terminate(), ()V)((HTTP3Session)this);
                        }
                        failStreams = true;
                        ** break;
                    }
lbl54:
                    // 1 sources

                    break;
                }
                case 3: 
                case 4: {
                    if (HTTP3Session.LOG.isDebugEnabled()) {
                        HTTP3Session.LOG.debug("already closed on {}", (Object)this);
                        ** break;
                    }
lbl59:
                    // 3 sources

                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        this.notifyGoAway(frame);
        if (failStreams) {
            predicate = (Predicate<HTTP3Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onGoAway$10(org.eclipse.jetty.http3.frames.GoAwayFrame org.eclipse.jetty.http3.HTTP3Stream ), (Lorg/eclipse/jetty/http3/HTTP3Stream;)Z)((GoAwayFrame)frame);
            this.failStreams(predicate, HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), "go_away", true, (Throwable)new EofException());
        }
        this.tryRunZeroStreamsAction();
    }

    /*
     * Unable to fully structure code
     */
    public boolean onIdleTimeout() {
        notify = false;
        terminate = false;
        ignored = this.lock.lock();
        try {
            switch (this.closeState.ordinal()) {
                case 0: {
                    notify = true;
                    ** break;
lbl9:
                    // 1 sources

                    break;
                }
                case 3: 
                case 4: {
                    terminate = true;
                    break;
                }
                ** default:
lbl14:
                // 1 sources

                break;
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (terminate) {
            if (HTTP3Session.LOG.isDebugEnabled()) {
                HTTP3Session.LOG.debug("already closed, ignored idle timeout for {}", (Object)this);
            }
            this.terminateAndDisconnect(HTTP3ErrorCode.NO_ERROR.code(), "idle_timeout");
            return false;
        }
        confirmed = true;
        if (notify) {
            confirmed = this.notifyIdleTimeout();
        }
        if (HTTP3Session.LOG.isDebugEnabled()) {
            HTTP3Session.LOG.debug("idle timeout {} for {}", (Object)(confirmed != false ? "confirmed" : "ignored"), (Object)this);
        }
        if (!confirmed) {
            return false;
        }
        this.inwardClose(HTTP3ErrorCode.NO_ERROR.code(), "idle_timeout");
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void inwardClose(long error, String reason) {
        goAwayFrame = null;
        ignored = this.lock.lock();
        try {
            switch (this.closeState.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.goAwaySent == null || this.goAwaySent.isGraceful()) {
                        this.goAwaySent = goAwayFrame = this.newGoAwayFrame(false);
                    }
                    this.closeState = CloseState.CLOSED;
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 4: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        this.failStreams((Predicate<HTTP3Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$inwardClose$11(org.eclipse.jetty.http3.HTTP3Stream ), (Lorg/eclipse/jetty/http3/HTTP3Stream;)Z)(), error, reason, true, new IOException(reason));
        if (goAwayFrame != null) {
            this.writeControlFrame(goAwayFrame, Callback.from((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$inwardClose$12(long java.lang.String ), ()V)((HTTP3Session)this, (long)error, (String)reason)));
        } else {
            this.terminateAndDisconnect(error, reason);
        }
    }

    private void terminateAndDisconnect(long error, String reason) {
        this.terminate();
        this.outwardDisconnect(error, reason);
    }

    private void outwardDisconnect(long error, String reason) {
        this.outwardClose(error, reason);
        this.notifyDisconnect(error, reason);
    }

    private void outwardClose(long error, String reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("outward closing 0x{}/{} on {}", new Object[]{Long.toHexString(error), reason, this});
        }
        this.getProtocolSession().outwardClose(error, reason);
    }

    private void failStreams(Predicate<HTTP3Stream> predicate, long error, String reason, boolean close, Throwable failure) {
        this.streams.values().stream().filter(predicate).forEach(stream -> {
            if (close) {
                stream.reset(error, failure);
            }
            stream.onFailure(error, failure);
        });
    }

    private void terminate() {
        CompletableFuture<Void> shutdown;
        if (LOG.isDebugEnabled()) {
            LOG.debug("terminating {}", (Object)this);
        }
        this.streamTimeouts.destroy();
        try (AutoLock ignored = this.lock.lock();){
            shutdown = this.shutdown;
        }
        if (shutdown != null) {
            shutdown.complete(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void tryRunZeroStreamsAction() {
        action = null;
        ignored = this.lock.lock();
        try {
            count = this.streamCount.get();
            if (count > 0L) {
                if (HTTP3Session.LOG.isDebugEnabled()) {
                    HTTP3Session.LOG.debug("deferring closing action, {} pending streams on {}", (Object)count, (Object)this);
                }
                return;
            }
            switch (this.closeState.ordinal()) {
                case 1: {
                    if (this.goAwaySent.isGraceful()) {
                        action = this.zeroStreamsAction;
                        this.zeroStreamsAction = null;
                        ** break;
                    }
lbl15:
                    // 3 sources

                    break;
                }
                case 2: {
                    if (this.goAwaySent != null && this.goAwaySent.isGraceful()) {
                        action = this.zeroStreamsAction;
                        this.zeroStreamsAction = null;
                        ** break;
                    }
lbl21:
                    // 3 sources

                    break;
                }
                case 3: {
                    this.closeState = CloseState.CLOSED;
                    action = this.zeroStreamsAction;
                    this.zeroStreamsAction = null;
                    ** break;
lbl27:
                    // 1 sources

                    break;
                }
                case 0: 
                case 4: {
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (action != null) {
            if (HTTP3Session.LOG.isDebugEnabled()) {
                HTTP3Session.LOG.debug("executing zero streams action on {}", (Object)this);
            }
            action.run();
        }
    }

    public void onClose(long error, String reason) {
        boolean notifyFailure;
        if (LOG.isDebugEnabled()) {
            LOG.debug("session closed remotely 0x{}/{} {}", new Object[]{Long.toHexString(error), reason, this});
        }
        try (AutoLock ignored = this.lock.lock();){
            notifyFailure = this.closeState == CloseState.NOT_CLOSED;
            this.closeState = CloseState.CLOSED;
            this.zeroStreamsAction = null;
        }
        EofException failure = new EofException(reason);
        this.failStreams(stream -> true, error, reason, false, (Throwable)failure);
        if (notifyFailure) {
            this.onSessionFailure(error, reason, (Throwable)failure);
        }
        this.notifyDisconnect(error, reason);
    }

    private void notifyDisconnect(long error, String reason) {
        try {
            this.listener.onDisconnect(this, error, reason);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    @Override
    public void onStreamFailure(long streamId, long error, Throwable failure) {
        HTTP3Stream stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("stream failure 0x{}/{} for stream #{} on {}", new Object[]{Long.toHexString(error), failure.getMessage(), streamId, this});
        }
        if ((stream = this.getStream(streamId)) != null) {
            stream.onFailure(error, failure);
        }
    }

    @Override
    public void onSessionFailure(long error, String reason, Throwable failure) {
        this.notifyFailure(error, reason, failure);
        this.inwardClose(error, reason);
    }

    private void notifyFailure(long error, String reason, Throwable failure) {
        try {
            this.listener.onFailure(this, error, reason, failure);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    public boolean isClosed() {
        return this.closeState == CloseState.CLOSED;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new DumpableCollection("streams", this.getStreams())});
    }

    public String toString() {
        return String.format("%s@%x[streams=%d,%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.streamCount.get(), this.closeState});
    }

    private /* synthetic */ void lambda$inwardClose$12(long error, String reason) {
        this.terminateAndDisconnect(error, reason);
    }

    private static /* synthetic */ boolean lambda$inwardClose$11(HTTP3Stream stream) {
        return true;
    }

    private static /* synthetic */ boolean lambda$onGoAway$10(GoAwayFrame frame, HTTP3Stream stream) {
        return stream.isLocal() && stream.getId() > frame.getLastId();
    }

    private /* synthetic */ void lambda$onGoAway$9(GoAwayFrame goAwayFrame) {
        this.writeControlFrame(goAwayFrame, Callback.from(this::terminate));
    }

    private /* synthetic */ void lambda$onGoAway$8() {
        this.terminateAndDisconnect(HTTP3ErrorCode.NO_ERROR.code(), "go_away");
    }

    private /* synthetic */ void lambda$onGoAway$7(GoAwayFrame goAwayFrame) {
        this.writeControlFrame(goAwayFrame, Callback.from(() -> this.terminateAndDisconnect(HTTP3ErrorCode.NO_ERROR.code(), "go_away")));
    }

    private /* synthetic */ void lambda$onGoAway$5(GoAwayFrame goAwayFrame) {
        this.writeControlFrame(goAwayFrame, Callback.from(this::terminate));
    }

    private static /* synthetic */ boolean lambda$goAway$2(HTTP3Stream stream) {
        return true;
    }

    private /* synthetic */ void lambda$goAway$1() {
        this.goAway(false);
    }

    private /* synthetic */ void lambda$goAway$0() {
        this.goAway(false);
    }

    private static enum CloseState {
        NOT_CLOSED,
        LOCALLY_CLOSED,
        REMOTELY_CLOSED,
        CLOSING,
        CLOSED;

    }

    private class StreamTimeouts
    extends CyclicTimeouts<HTTP3Stream> {
        private StreamTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        protected Iterator<HTTP3Stream> iterator() {
            return HTTP3Session.this.streams.values().stream().filter(stream -> stream.getIdleTimeout() > 0L).iterator();
        }

        protected boolean onExpired(HTTP3Stream stream) {
            TimeoutException timeout = new TimeoutException("idle timeout " + stream.getIdleTimeout() + " ms elapsed");
            stream.onIdleTimeout(timeout, (Promise<Boolean>)Promise.from(timedOut -> {
                if (timedOut.booleanValue()) {
                    HTTP3Session.this.removeStream(stream, timeout);
                }
            }, x -> HTTP3Session.this.removeStream(stream, timeout)));
            return false;
        }
    }
}

