/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.security.openid;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.ee8.nested.Authentication;
import org.eclipse.jetty.ee8.nested.Request;
import org.eclipse.jetty.ee8.nested.Response;
import org.eclipse.jetty.ee8.security.Authenticator;
import org.eclipse.jetty.ee8.security.ServerAuthException;
import org.eclipse.jetty.ee8.security.UserAuthentication;
import org.eclipse.jetty.ee8.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.ee8.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.ee8.security.authentication.SessionAuthentication;
import org.eclipse.jetty.ee8.security.openid.OpenIdAuthConfiguration;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.security.openid.OpenIdCredentials;
import org.eclipse.jetty.security.openid.OpenIdLoginService;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdAuthenticator.class);
    public static final String CLAIMS = "org.eclipse.jetty.security.openid.claims";
    public static final String RESPONSE = "org.eclipse.jetty.security.openid.response";
    public static final String ISSUER = "org.eclipse.jetty.security.openid.issuer";
    public static final String REDIRECT_PATH = "org.eclipse.jetty.security.openid.redirect_path";
    public static final String LOGOUT_REDIRECT_PATH = "org.eclipse.jetty.security.openid.logout_redirect_path";
    public static final String ERROR_PAGE = "org.eclipse.jetty.security.openid.error_page";
    public static final String J_URI = "org.eclipse.jetty.security.openid.URI";
    public static final String J_POST = "org.eclipse.jetty.security.openid.POST";
    public static final String J_METHOD = "org.eclipse.jetty.security.openid.METHOD";
    public static final String J_SECURITY_CHECK = "/j_security_check";
    public static final String ERROR_PARAMETER = "error_description_jetty";
    private static final String CSRF_MAP = "org.eclipse.jetty.security.openid.csrf_map";
    @Deprecated
    public static final String CSRF_TOKEN = "org.eclipse.jetty.security.openid.csrf_token";
    private final SecureRandom _secureRandom = new SecureRandom();
    private OpenIdConfiguration _openIdConfiguration;
    private String _redirectPath;
    private String _logoutRedirectPath;
    private String _errorPage;
    private String _errorPath;
    private String _errorQuery;
    private boolean _alwaysSaveUri;

    public OpenIdAuthenticator() {
        this(null, J_SECURITY_CHECK, null);
    }

    public OpenIdAuthenticator(OpenIdConfiguration configuration) {
        this(configuration, J_SECURITY_CHECK, null);
    }

    public OpenIdAuthenticator(OpenIdConfiguration configuration, String errorPage) {
        this(configuration, J_SECURITY_CHECK, errorPage);
    }

    public OpenIdAuthenticator(OpenIdConfiguration configuration, String redirectPath, String errorPage) {
        this(configuration, redirectPath, errorPage, null);
    }

    public OpenIdAuthenticator(OpenIdConfiguration configuration, String redirectPath, String errorPage, String logoutRedirectPath) {
        this._openIdConfiguration = configuration;
        this.setRedirectPath(redirectPath);
        if (errorPage != null) {
            this.setErrorPage(errorPage);
        }
        if (logoutRedirectPath != null) {
            this.setLogoutRedirectPath(logoutRedirectPath);
        }
    }

    public void setConfiguration(Authenticator.AuthConfiguration authConfig) {
        String logout;
        String error;
        String redirectPath;
        if (this._openIdConfiguration == null) {
            LoginService loginService = authConfig.getLoginService();
            if (!(loginService instanceof OpenIdLoginService)) {
                throw new IllegalArgumentException("invalid LoginService " + String.valueOf(loginService));
            }
            this._openIdConfiguration = ((OpenIdLoginService)loginService).getConfiguration();
        }
        if ((redirectPath = authConfig.getInitParameter(REDIRECT_PATH)) != null) {
            this.setRedirectPath(redirectPath);
        }
        if ((error = authConfig.getInitParameter(ERROR_PAGE)) != null) {
            this.setErrorPage(error);
        }
        if ((logout = authConfig.getInitParameter(LOGOUT_REDIRECT_PATH)) != null) {
            this.setLogoutRedirectPath(logout);
        }
        super.setConfiguration((Authenticator.AuthConfiguration)new OpenIdAuthConfiguration(this._openIdConfiguration, authConfig));
    }

    public String getAuthMethod() {
        return "OPENID";
    }

    @Deprecated
    public void setAlwaysSaveUri(boolean alwaysSave) {
        this._alwaysSaveUri = alwaysSave;
    }

    @Deprecated
    public boolean isAlwaysSaveUri() {
        return this._alwaysSaveUri;
    }

    public void setRedirectPath(String redirectPath) {
        if (redirectPath == null) {
            LOG.warn("redirect path must not be null, defaulting to /j_security_check");
            redirectPath = J_SECURITY_CHECK;
        } else if (!((String)redirectPath).startsWith("/")) {
            LOG.warn("redirect path must start with /");
            redirectPath = "/" + (String)redirectPath;
        }
        this._redirectPath = redirectPath;
    }

    public void setLogoutRedirectPath(String logoutRedirectPath) {
        if (logoutRedirectPath == null) {
            LOG.warn("redirect path must not be null, defaulting to /");
            logoutRedirectPath = "/";
        } else if (!((String)logoutRedirectPath).startsWith("/")) {
            LOG.warn("redirect path must start with /");
            logoutRedirectPath = "/" + (String)logoutRedirectPath;
        }
        this._logoutRedirectPath = logoutRedirectPath;
    }

    public void setErrorPage(String path) {
        if (path == null || ((String)path).trim().length() == 0) {
            this._errorPath = null;
            this._errorPage = null;
        } else {
            if (!((String)path).startsWith("/")) {
                LOG.warn("error-page must start with /");
                path = "/" + (String)path;
            }
            this._errorPage = path;
            this._errorPath = path;
            this._errorQuery = "";
            int queryIndex = this._errorPath.indexOf(63);
            if (queryIndex > 0) {
                this._errorPath = this._errorPage.substring(0, queryIndex);
                this._errorQuery = this._errorPage.substring(queryIndex + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        UserIdentity user;
        if (LOG.isDebugEnabled()) {
            LOG.debug("login {} {} {}", new Object[]{username, credentials, request});
        }
        if ((user = super.login(username, credentials, request)) != null) {
            HttpSession session = ((HttpServletRequest)request).getSession();
            SessionAuthentication cached = new SessionAuthentication(this.getAuthMethod(), user, credentials);
            HttpSession httpSession = session;
            synchronized (httpSession) {
                session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
                session.setAttribute(CLAIMS, (Object)((OpenIdCredentials)credentials).getClaims());
                session.setAttribute(RESPONSE, (Object)((OpenIdCredentials)credentials).getResponse());
                session.setAttribute(ISSUER, (Object)this._openIdConfiguration.getIssuer());
            }
        }
        return user;
    }

    public void logout(ServletRequest request) {
        this.attemptLogoutRedirect(request);
        this.logoutWithoutRedirect(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logoutWithoutRedirect(ServletRequest request) {
        super.logout(request);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
            session.removeAttribute(CLAIMS);
            session.removeAttribute(RESPONSE);
            session.removeAttribute(ISSUER);
        }
    }

    private void attemptLogoutRedirect(ServletRequest request) {
        try {
            Request baseRequest = Objects.requireNonNull(Request.getBaseRequest((ServletRequest)request));
            Response baseResponse = baseRequest.getResponse();
            String endSessionEndpoint = this._openIdConfiguration.getEndSessionEndpoint();
            String redirectUri = null;
            if (this._logoutRedirectPath != null) {
                StringBuilder sb = new StringBuilder(128);
                URIUtil.appendSchemeHostPort((StringBuilder)sb, (String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort());
                sb.append(baseRequest.getContextPath());
                sb.append(this._logoutRedirectPath);
                redirectUri = sb.toString();
            }
            HttpSession session = baseRequest.getSession(false);
            if (endSessionEndpoint == null || session == null) {
                if (redirectUri != null) {
                    baseResponse.sendRedirect(redirectUri, true);
                }
                return;
            }
            Object openIdResponse = session.getAttribute(RESPONSE);
            if (!(openIdResponse instanceof Map)) {
                if (redirectUri != null) {
                    baseResponse.sendRedirect(redirectUri, true);
                }
                return;
            }
            String idToken = (String)((Map)openIdResponse).get("id_token");
            baseResponse.sendRedirect(endSessionEndpoint + "?id_token_hint=" + UrlEncoded.encodeString((String)idToken, (Charset)StandardCharsets.UTF_8) + (String)(redirectUri == null ? "" : "&post_logout_redirect_uri=" + UrlEncoded.encodeString((String)redirectUri, (Charset)StandardCharsets.UTF_8)), true);
        }
        catch (Throwable t) {
            LOG.warn("failed to redirect to end_session_endpoint", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareRequest(ServletRequest request) {
        String method;
        String juri;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            if (session.getAttribute("org.eclipse.jetty.security.UserIdentity") == null) {
                return;
            }
            juri = (String)session.getAttribute(J_URI);
            if (juri == null || juri.length() == 0) {
                return;
            }
            method = (String)session.getAttribute(J_METHOD);
            if (method == null || method.length() == 0) {
                return;
            }
        }
        StringBuffer buf = httpRequest.getRequestURL();
        if (httpRequest.getQueryString() != null) {
            buf.append("?").append(httpRequest.getQueryString());
        }
        if (!juri.equals(buf.toString())) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Restoring original method {} for {} with method {}", new Object[]{method, juri, httpRequest.getMethod()});
        }
        Request baseRequest = Objects.requireNonNull(Request.getBaseRequest((ServletRequest)request));
        baseRequest.setMethod(method);
    }

    private boolean hasExpiredIdToken(HttpSession session) {
        Map claims;
        if (session != null && (claims = (Map)session.getAttribute(CLAIMS)) != null) {
            return OpenIdCredentials.checkExpiry((Map)claims);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        String uri;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        Request baseRequest = Request.getBaseRequest((ServletRequest)request);
        Response baseResponse = baseRequest.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("validateRequest({},{},{})", new Object[]{req, res, mandatory});
        }
        if ((uri = request.getRequestURI()) == null) {
            uri = "/";
        }
        HttpSession session = request.getSession(false);
        if (this._openIdConfiguration.isLogoutWhenIdTokenIsExpired() && this.hasExpiredIdToken(session)) {
            this.logoutWithoutRedirect(req);
            mandatory = true;
        }
        if (!(mandatory |= this.isJSecurityCheck(uri))) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        if (this.isErrorPage(baseRequest.getPathInContext()) && !DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        try {
            if (session == null) {
                session = request.getSession(true);
            }
            if (request.isRequestedSessionIdFromURL()) {
                this.sendError(request, response, "Session ID must be a cookie to support OpenID authentication");
                return Authentication.SEND_FAILURE;
            }
            if (this.isJSecurityCheck(uri)) {
                UriRedirectInfo uriRedirectInfo;
                String authCode = request.getParameter("code");
                if (authCode == null) {
                    this.sendError(request, response, "auth failed: no code parameter");
                    return Authentication.SEND_FAILURE;
                }
                String state = request.getParameter("state");
                if (state == null) {
                    this.sendError(request, response, "auth failed: no state parameter");
                    return Authentication.SEND_FAILURE;
                }
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    uriRedirectInfo = this.removeAndClearCsrfMap(session, state);
                }
                if (uriRedirectInfo == null) {
                    this.sendError(request, response, "auth failed: invalid state parameter");
                    return Authentication.SEND_FAILURE;
                }
                OpenIdCredentials credentials = new OpenIdCredentials(authCode, this.getRedirectUri(request));
                UserIdentity user = this.login(null, credentials, (ServletRequest)request);
                if (user == null) {
                    this.sendError(request, response, null);
                    return Authentication.SEND_FAILURE;
                }
                OpenIdAuthentication openIdAuth = new OpenIdAuthentication(this.getAuthMethod(), user);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("authenticated {}->{}", (Object)openIdAuth, (Object)uriRedirectInfo.getUri());
                }
                HttpSession httpSession2 = session;
                synchronized (httpSession2) {
                    session.setAttribute(J_URI, (Object)uriRedirectInfo.getUri());
                    session.setAttribute(J_METHOD, (Object)uriRedirectInfo.getMethod());
                    session.setAttribute(J_POST, uriRedirectInfo.getFormParameters());
                }
                response.setContentLength(0);
                baseResponse.sendRedirect(uriRedirectInfo.getUri(), true);
                return openIdAuth;
            }
            Authentication authentication = (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (authentication != null) {
                if (authentication instanceof Authentication.User && this._loginService != null && !this._loginService.validate(((Authentication.User)authentication).getUserIdentity())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("auth revoked {}", (Object)authentication);
                    }
                    this.logoutWithoutRedirect(req);
                } else {
                    HttpSession state = session;
                    synchronized (state) {
                        String jUri = (String)session.getAttribute(J_URI);
                        if (jUri != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("auth retry {}->{}", (Object)authentication, (Object)jUri);
                            }
                            StringBuffer buf = request.getRequestURL();
                            if (request.getQueryString() != null) {
                                buf.append("?").append(request.getQueryString());
                            }
                            if (jUri.equals(buf.toString())) {
                                MultiMap jPost = (MultiMap)session.getAttribute(J_POST);
                                if (jPost != null) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("auth rePOST {}->{}", (Object)authentication, (Object)jUri);
                                    }
                                    baseRequest.setContentParameters(jPost);
                                }
                                session.removeAttribute(J_URI);
                                session.removeAttribute(J_METHOD);
                                session.removeAttribute(J_POST);
                            }
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("auth {}", (Object)authentication);
                    }
                    return authentication;
                }
            }
            if (DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("auth deferred {}", (Object)session.getId());
                }
                return Authentication.UNAUTHENTICATED;
            }
            String challengeUri = this.getChallengeUri(baseRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug("challenge {}->{}", (Object)session.getId(), (Object)challengeUri);
            }
            baseResponse.sendRedirect(challengeUri, true);
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        Request baseRequest = Request.getBaseRequest((ServletRequest)request);
        Response baseResponse = Objects.requireNonNull(baseRequest).getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("OpenId authentication FAILED: {}", (Object)message);
        }
        if (this._errorPage == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("auth failed 403");
            }
            if (response != null) {
                response.sendError(403);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("auth failed {}", (Object)this._errorPage);
            }
            String redirectUri = URIUtil.addPaths((String)request.getContextPath(), (String)this._errorPage);
            if (message != null) {
                String query = URIUtil.addQueries((String)("error_description_jetty=" + UrlEncoded.encodeString((String)message)), (String)this._errorQuery);
                redirectUri = URIUtil.addPathQuery((String)URIUtil.addPaths((String)request.getContextPath(), (String)this._errorPath), (String)query);
            }
            baseResponse.sendRedirect(redirectUri, true);
        }
    }

    public boolean isJSecurityCheck(String uri) {
        int jsc = uri.indexOf(this._redirectPath);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + this._redirectPath.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    public boolean isErrorPage(String pathInContext) {
        return pathInContext != null && pathInContext.equals(this._errorPath);
    }

    private String getRedirectUri(HttpServletRequest request) {
        StringBuffer redirectUri = new StringBuffer(128);
        URIUtil.appendSchemeHostPort((StringBuffer)redirectUri, (String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort());
        redirectUri.append(request.getContextPath());
        redirectUri.append(this._redirectPath);
        return redirectUri.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getChallengeUri(Request request) {
        String antiForgeryToken;
        HttpSession session;
        HttpSession httpSession = session = request.getSession();
        synchronized (httpSession) {
            Map<String, UriRedirectInfo> csrfMap = this.ensureCsrfMap(session);
            antiForgeryToken = new BigInteger(130, this._secureRandom).toString(32);
            csrfMap.put(antiForgeryToken, new UriRedirectInfo(request));
        }
        StringBuilder scopes = new StringBuilder();
        for (String s : this._openIdConfiguration.getScopes()) {
            scopes.append(" ").append(s);
        }
        return this._openIdConfiguration.getAuthEndpoint() + "?client_id=" + UrlEncoded.encodeString((String)this._openIdConfiguration.getClientId(), (Charset)StandardCharsets.UTF_8) + "&redirect_uri=" + UrlEncoded.encodeString((String)this.getRedirectUri((HttpServletRequest)request), (Charset)StandardCharsets.UTF_8) + "&scope=openid" + UrlEncoded.encodeString((String)scopes.toString(), (Charset)StandardCharsets.UTF_8) + "&state=" + antiForgeryToken + "&response_type=code";
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) {
        return req.isSecure();
    }

    private UriRedirectInfo removeAndClearCsrfMap(HttpSession session, String csrf) {
        Map csrfMap = (Map)session.getAttribute(CSRF_MAP);
        if (csrfMap == null) {
            return null;
        }
        UriRedirectInfo uriRedirectInfo = (UriRedirectInfo)csrfMap.get(csrf);
        csrfMap.clear();
        return uriRedirectInfo;
    }

    private Map<String, UriRedirectInfo> ensureCsrfMap(HttpSession session) {
        Map csrfMap = (Map)session.getAttribute(CSRF_MAP);
        if (csrfMap == null) {
            csrfMap = new MRUMap(64);
            session.setAttribute(CSRF_MAP, (Object)csrfMap);
        }
        return csrfMap;
    }

    private static class UriRedirectInfo
    implements Serializable {
        private static final long serialVersionUID = 139567755844461433L;
        private final String _uri;
        private final String _method;
        private final MultiMap<String> _formParameters;

        public UriRedirectInfo(Request request) {
            this._uri = request.getRequestURI();
            this._method = request.getMethod();
            if (MimeTypes.Type.FORM_ENCODED.is(request.getContentType()) && HttpMethod.POST.is(request.getMethod())) {
                MultiMap formParameters = new MultiMap();
                request.extractFormParameters(formParameters);
                this._formParameters = formParameters;
            } else {
                this._formParameters = null;
            }
        }

        public String getUri() {
            return this._uri;
        }

        public String getMethod() {
            return this._method;
        }

        public MultiMap<String> getFormParameters() {
            return this._formParameters;
        }
    }

    public static class OpenIdAuthentication
    extends UserAuthentication
    implements Authentication.ResponseSent {
        public OpenIdAuthentication(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }

        public String toString() {
            return "OpenId" + super.toString();
        }
    }

    private static class MRUMap
    extends LinkedHashMap<String, UriRedirectInfo> {
        private static final long serialVersionUID = 5375723072014233L;
        private final int _size;

        private MRUMap(int size) {
            this._size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, UriRedirectInfo> eldest) {
            return this.size() > this._size;
        }
    }
}

