/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server;

import java.util.EventListener;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.websocket.core.WebSocketComponents;

public class WebSocketServerComponents
extends WebSocketComponents {
    public static final String WEBSOCKET_COMPONENTS_ATTRIBUTE = WebSocketComponents.class.getName();
    public static final String WEBSOCKET_INFLATER_POOL_ATTRIBUTE = "jetty.websocket.inflater";
    public static final String WEBSOCKET_DEFLATER_POOL_ATTRIBUTE = "jetty.websocket.deflater";
    public static final String WEBSOCKET_BUFFER_POOL_ATTRIBUTE = "jetty.websocket.bufferPool";

    WebSocketServerComponents(InflaterPool inflaterPool, DeflaterPool deflaterPool, ByteBufferPool bufferPool, DecoratedObjectFactory objectFactory, Executor executor) {
        super(null, objectFactory, bufferPool, inflaterPool, deflaterPool, executor);
    }

    public static WebSocketComponents ensureWebSocketComponents(Server server, final ContextHandler contextHandler) {
        Executor executor;
        ByteBufferPool bufferPool;
        DeflaterPool deflaterPool;
        ContextHandler.ScopedContext context = contextHandler.getContext();
        WebSocketComponents components = (WebSocketComponents)context.getAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
        if (components != null) {
            return components;
        }
        InflaterPool inflaterPool = (InflaterPool)context.getAttribute(WEBSOCKET_INFLATER_POOL_ATTRIBUTE);
        if (inflaterPool == null) {
            inflaterPool = InflaterPool.ensurePool((Container)server);
        }
        if ((deflaterPool = (DeflaterPool)context.getAttribute(WEBSOCKET_DEFLATER_POOL_ATTRIBUTE)) == null) {
            deflaterPool = DeflaterPool.ensurePool((Container)server);
        }
        if ((bufferPool = (ByteBufferPool)context.getAttribute(WEBSOCKET_BUFFER_POOL_ATTRIBUTE)) == null) {
            bufferPool = server.getByteBufferPool();
        }
        if ((executor = (Executor)context.getAttribute("org.eclipse.jetty.server.Executor")) == null) {
            executor = server.getThreadPool();
        }
        DecoratedObjectFactory objectFactory = (DecoratedObjectFactory)context.getAttribute(DecoratedObjectFactory.ATTR);
        final WebSocketServerComponents serverComponents = new WebSocketServerComponents(inflaterPool, deflaterPool, bufferPool, objectFactory, executor);
        if (objectFactory != null) {
            serverComponents.unmanage(objectFactory);
        }
        if (server.contains((Object)inflaterPool)) {
            serverComponents.unmanage(inflaterPool);
        }
        if (server.contains((Object)deflaterPool)) {
            serverComponents.unmanage(deflaterPool);
        }
        if (server.contains((Object)bufferPool)) {
            serverComponents.unmanage(bufferPool);
        }
        if (executor != null) {
            serverComponents.unmanage(executor);
        }
        contextHandler.addManaged((LifeCycle)serverComponents);
        contextHandler.setAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE, (Object)serverComponents);
        contextHandler.addEventListener((EventListener)new LifeCycle.Listener(){

            public void lifeCycleStopping(LifeCycle event) {
                contextHandler.removeAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
                contextHandler.removeBean((Object)serverComponents);
                contextHandler.removeEventListener((EventListener)((Object)this));
            }

            public String toString() {
                return String.format("%sCleanupListener", WebSocketServerComponents.class.getSimpleName());
            }
        });
        return serverComponents;
    }

    public static WebSocketComponents getWebSocketComponents(ContextHandler contextHandler) {
        WebSocketComponents components = (WebSocketComponents)contextHandler.getAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
        if (components == null) {
            throw new IllegalStateException("WebSocketComponents has not been created");
        }
        return components;
    }
}

