/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.server;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicConnection;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.server.ServerProtocolSession;
import org.eclipse.jetty.quic.server.ServerQuicConnection;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.thread.Scheduler;

public class ServerQuicSession
extends QuicSession
implements CyclicTimeouts.Expirable {
    private final Connector connector;
    private long expireNanoTime = Long.MAX_VALUE;

    protected ServerQuicSession(Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, QuicheConnection quicheConnection, QuicConnection connection, SocketAddress remoteAddress, Connector connector) {
        super(executor, scheduler, bufferPool, quicheConnection, connection, remoteAddress);
        this.connector = connector;
    }

    public ServerQuicConnection getQuicConnection() {
        return (ServerQuicConnection)super.getQuicConnection();
    }

    protected ProtocolSession createProtocolSession() {
        ConnectionFactory connectionFactory = this.findConnectionFactory(this.getNegotiatedProtocol());
        if (connectionFactory instanceof ProtocolSession.Factory) {
            return ((ProtocolSession.Factory)connectionFactory).newProtocolSession((QuicSession)this, Map.of());
        }
        return new ServerProtocolSession(this);
    }

    public Connection newConnection(QuicStreamEndPoint endPoint) {
        ConnectionFactory connectionFactory = this.findConnectionFactory(this.getNegotiatedProtocol());
        return this.newConnection(connectionFactory, endPoint);
    }

    private Connection newConnection(ConnectionFactory factory, QuicStreamEndPoint endPoint) {
        return factory.newConnection(this.connector, (EndPoint)endPoint);
    }

    private ConnectionFactory findConnectionFactory(String negotiatedProtocol) {
        ConnectionFactory connectionFactory = this.connector.getConnectionFactory(negotiatedProtocol);
        if (connectionFactory == null) {
            connectionFactory = this.connector.getDefaultConnectionFactory();
        }
        if (connectionFactory == null) {
            throw new RuntimeIOException("No configured connection factory can handle protocol '" + negotiatedProtocol + "'");
        }
        return connectionFactory;
    }

    public long getExpireNanoTime() {
        return this.expireNanoTime;
    }

    public void setIdleTimeout(long idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        this.notIdle();
        this.getQuicConnection().schedule(this);
    }

    public boolean onIdleTimeout() {
        boolean result = super.onIdleTimeout();
        if (!result) {
            this.notIdle();
        }
        return result;
    }

    public Runnable process(SocketAddress remoteAddress, ByteBuffer cipherBufferIn) throws IOException {
        this.notIdle();
        return super.process(remoteAddress, cipherBufferIn);
    }

    public void flush() {
        this.notIdle();
        super.flush();
    }

    private void notIdle() {
        long idleTimeout = this.getIdleTimeout();
        if (idleTimeout > 0L) {
            this.expireNanoTime = NanoTime.now() + TimeUnit.MILLISECONDS.toNanos(idleTimeout);
        }
    }
}

