/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import jakarta.servlet.http.HttpSessionContext;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.nested.HttpChannel;
import org.eclipse.jetty.ee9.nested.Request;
import org.eclipse.jetty.ee9.nested.ScopedHandler;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionCache;
import org.eclipse.jetty.session.SessionConfig;
import org.eclipse.jetty.session.SessionIdManager;
import org.eclipse.jetty.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHandler
extends ScopedHandler
implements SessionConfig.Mutable {
    static final Logger LOG = LoggerFactory.getLogger(SessionHandler.class);
    public static final EnumSet<SessionTrackingMode> DEFAULT_SESSION_TRACKING_MODES = EnumSet.of(SessionTrackingMode.COOKIE, SessionTrackingMode.URL);
    private final CoreSessionManager _sessionManager = new CoreSessionManager();
    private final List<HttpSessionAttributeListener> _sessionAttributeListeners = new CopyOnWriteArrayList<HttpSessionAttributeListener>();
    private final List<HttpSessionListener> _sessionListeners = new CopyOnWriteArrayList<HttpSessionListener>();
    private final List<HttpSessionIdListener> _sessionIdListeners = new CopyOnWriteArrayList<HttpSessionIdListener>();
    private final SessionCookieConfig _cookieConfig = new CookieConfig();
    private ContextHandler _contextHandler;

    public SessionHandler() {
        this.setSessionTrackingModes(DEFAULT_SESSION_TRACKING_MODES);
        this.addBean((Object)this._sessionManager);
        this.addBean(this._cookieConfig);
        this.addBean(this._sessionListeners);
        this.addBean(this._sessionIdListeners);
        this.addBean(this._sessionAttributeListeners);
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    protected List<HttpSessionListener> getSessionListeners() {
        return this._sessionListeners;
    }

    protected List<HttpSessionAttributeListener> getSessionAttributeListeners() {
        return this._sessionAttributeListeners;
    }

    protected List<HttpSessionIdListener> getSessionIdListeners() {
        return this._sessionIdListeners;
    }

    public void setSessionCache(SessionCache cache) {
        this._sessionManager.setSessionCache(cache);
    }

    public SessionCache getSessionCache() {
        return this._sessionManager.getSessionCache();
    }

    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this._sessionManager.setSessionIdManager(sessionIdManager);
    }

    public SessionIdManager getSessionIdManager() {
        return this._sessionManager.getSessionIdManager();
    }

    protected void configureCookies() {
        if (this._contextHandler == null) {
            return;
        }
        String tmp = this._contextHandler.getInitParameter("org.eclipse.jetty.session.SessionCookie");
        if (tmp != null) {
            this.setSessionCookie(tmp);
        }
        if ((tmp = this._contextHandler.getInitParameter("org.eclipse.jetty.session.SessionIdPathParameterName")) != null) {
            this.setSessionIdPathParameterName(tmp);
        }
        if ((tmp = this._contextHandler.getInitParameter("org.eclipse.jetty.session.CheckingRemoteSessionIdEncoding")) != null) {
            this.setCheckingRemoteSessionIdEncoding(Boolean.parseBoolean(tmp));
        }
        if ((tmp = this._contextHandler.getInitParameter("org.eclipse.jetty.session.SessionDomain")) != null) {
            this.setSessionDomain(tmp);
        }
        if ((tmp = this._contextHandler.getInitParameter("org.eclipse.jetty.session.SessionPath")) != null) {
            this.setSessionPath(tmp);
        }
        if ((tmp = this._contextHandler.getInitParameter("org.eclipse.jetty.session.MaxAge")) != null) {
            this.setMaxCookieAge(Integer.parseInt(tmp.trim()));
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._contextHandler = ContextHandler.getCurrentContext().getContextHandler();
        super.doStart();
        this.configureCookies();
    }

    public boolean addEventListener(EventListener listener) {
        if (super.addEventListener(listener)) {
            if (listener instanceof HttpSessionAttributeListener) {
                this._sessionAttributeListeners.add((HttpSessionAttributeListener)listener);
            }
            if (listener instanceof HttpSessionListener) {
                this._sessionListeners.add((HttpSessionListener)listener);
            }
            if (listener instanceof HttpSessionIdListener) {
                this._sessionIdListeners.add((HttpSessionIdListener)listener);
            }
            return true;
        }
        return false;
    }

    public boolean removeEventListener(EventListener listener) {
        if (super.removeEventListener(listener)) {
            if (listener instanceof HttpSessionAttributeListener) {
                this._sessionAttributeListeners.remove(listener);
            }
            if (listener instanceof HttpSessionListener) {
                this._sessionListeners.remove(listener);
            }
            if (listener instanceof HttpSessionIdListener) {
                this._sessionIdListeners.remove(listener);
            }
            return true;
        }
        return false;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this._cookieConfig;
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return DEFAULT_SESSION_TRACKING_MODES;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (this._sessionManager.isUsingCookies()) {
            if (this._sessionManager.isUsingUriParameters()) {
                return Set.of(SessionTrackingMode.COOKIE, SessionTrackingMode.URL);
            }
            return Set.of(SessionTrackingMode.COOKIE);
        }
        if (this._sessionManager.isUsingUriParameters()) {
            return Set.of(SessionTrackingMode.URL);
        }
        return Collections.emptySet();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (sessionTrackingModes != null && sessionTrackingModes.size() > 1 && sessionTrackingModes.contains(SessionTrackingMode.SSL)) {
            throw new IllegalArgumentException("sessionTrackingModes.SSL is not supported");
        }
        this._sessionManager.setUsingCookies(sessionTrackingModes != null && sessionTrackingModes.contains(SessionTrackingMode.COOKIE));
        this._sessionManager.setUsingUriParameters(sessionTrackingModes != null && sessionTrackingModes.contains(SessionTrackingMode.URL));
    }

    public int getMaxCookieAge() {
        return this._sessionManager.getMaxCookieAge();
    }

    public int getMaxInactiveInterval() {
        return this._sessionManager.getMaxInactiveInterval();
    }

    public int getRefreshCookieAge() {
        return this._sessionManager.getRefreshCookieAge();
    }

    public HttpCookie.SameSite getSameSite() {
        return this._sessionManager.getSameSite();
    }

    public String getSessionComment() {
        return this._sessionManager.getSessionComment();
    }

    public String getSessionCookie() {
        return this._sessionManager.getSessionCookie();
    }

    public String getSessionDomain() {
        return this._sessionManager.getSessionDomain();
    }

    public String getSessionIdPathParameterName() {
        return this._sessionManager.getSessionIdPathParameterName();
    }

    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionManager.getSessionIdPathParameterNamePrefix();
    }

    public String getSessionPath() {
        return this._sessionManager.getSessionPath();
    }

    public boolean isCheckingRemoteSessionIdEncoding() {
        return this._sessionManager.isCheckingRemoteSessionIdEncoding();
    }

    public boolean isHttpOnly() {
        return this._sessionManager.isHttpOnly();
    }

    public boolean isSecureCookies() {
        return this._sessionManager.isSecureCookies();
    }

    public boolean isSecureRequestOnly() {
        return this._sessionManager.isSecureRequestOnly();
    }

    public boolean isUsingCookies() {
        return this._sessionManager.isUsingCookies();
    }

    public boolean isUsingUriParameters() {
        return this._sessionManager.isUsingUriParameters();
    }

    public void setCheckingRemoteSessionIdEncoding(boolean value) {
        this._sessionManager.setCheckingRemoteSessionIdEncoding(value);
    }

    public void setHttpOnly(boolean value) {
        this._sessionManager.setHttpOnly(value);
    }

    public void setMaxCookieAge(int value) {
        this._sessionManager.setMaxCookieAge(value);
    }

    public void setMaxInactiveInterval(int value) {
        this._sessionManager.setMaxInactiveInterval(value);
    }

    public void setRefreshCookieAge(int value) {
        this._sessionManager.setRefreshCookieAge(value);
    }

    public void setSameSite(HttpCookie.SameSite sameSite) {
        this._sessionManager.setSameSite(sameSite);
    }

    public void setSecureCookies(boolean value) {
        this._sessionManager.setSecureCookies(value);
    }

    public void setSecureRequestOnly(boolean value) {
        this._sessionManager.setSecureRequestOnly(value);
    }

    public void setSessionComment(String sessionComment) {
        this._sessionManager.setSessionComment(sessionComment);
    }

    public void setSessionCookie(String value) {
        this._sessionManager.setSessionCookie(value);
    }

    public void setSessionDomain(String value) {
        this._sessionManager.setSessionDomain(value);
    }

    public void setSessionIdPathParameterName(String value) {
        this._sessionManager.setSessionIdPathParameterName(value);
    }

    public void setSessionPath(String value) {
        this._sessionManager.setSessionPath(value);
    }

    public void setUsingCookies(boolean value) {
        this._sessionManager.setUsingCookies(value);
    }

    public void setUsingUriParameters(boolean value) {
        this._sessionManager.setUsingUriParameters(value);
    }

    @Override
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.getDispatcherType() == DispatcherType.REQUEST) {
            ContextHandler.CoreContextRequest coreRequest = baseRequest.getHttpChannel().getCoreRequest();
            this._sessionManager.addSessionStreamWrapper((org.eclipse.jetty.server.Request)coreRequest);
            AbstractSessionManager.RequestedSession requestedSession = this._sessionManager.resolveRequestedSessionId((org.eclipse.jetty.server.Request)coreRequest);
            coreRequest.setSessionManager((SessionManager)this._sessionManager);
            coreRequest.setRequestedSession(requestedSession);
            HttpCookie cookie = this._sessionManager.access(requestedSession.session(), coreRequest.getConnectionMetaData().isSecure());
            if (cookie != null) {
                baseRequest.getResponse().replaceCookie(cookie);
            }
        }
        this.nextScope(target, baseRequest, request, response);
    }

    @Override
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.nextHandle(target, baseRequest, request, response);
    }

    private class CoreSessionManager
    extends AbstractSessionManager {
        private CoreSessionManager() {
        }

        public Server getServer() {
            return SessionHandler.this.getServer();
        }

        protected void addSessionStreamWrapper(org.eclipse.jetty.server.Request request) {
            super.addSessionStreamWrapper(request);
        }

        public ManagedSession getManagedSession(org.eclipse.jetty.server.Request request) {
            return ((HttpChannel)org.eclipse.jetty.server.Request.get((org.eclipse.jetty.server.Request)request, ContextHandler.CoreContextRequest.class, ContextHandler.CoreContextRequest::getHttpChannel)).getCoreRequest().getManagedSession();
        }

        public Session.API newSessionAPIWrapper(ManagedSession session) {
            return new ServletSessionApi(session);
        }

        protected AbstractSessionManager.RequestedSession resolveRequestedSessionId(org.eclipse.jetty.server.Request request) {
            return super.resolveRequestedSessionId(request);
        }

        public void onSessionAttributeUpdate(Session session, String name, Object old, Object value) {
            if (old != null) {
                this.callUnboundBindingListener(session, name, old);
            }
            if (value != null) {
                this.callBoundBindingListener(session, name, value);
            }
            if (!SessionHandler.this._sessionAttributeListeners.isEmpty()) {
                HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)session.getApi(), name, old == null ? value : old);
                for (HttpSessionAttributeListener l : SessionHandler.this._sessionAttributeListeners) {
                    if (old == null) {
                        l.attributeAdded(event);
                        continue;
                    }
                    if (value == null) {
                        l.attributeRemoved(event);
                        continue;
                    }
                    l.attributeReplaced(event);
                }
            }
        }

        public void onSessionCreated(Session session) {
            if (session == null) {
                return;
            }
            super.onSessionCreated(session);
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session.getApi());
            for (HttpSessionListener l : SessionHandler.this._sessionListeners) {
                l.sessionCreated(event);
            }
        }

        public void onSessionDestroyed(Session session) {
            if (session == null) {
                return;
            }
            super.onSessionDestroyed(session);
            Runnable r = () -> {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session.getApi());
                for (int i = SessionHandler.this._sessionListeners.size() - 1; i >= 0; --i) {
                    SessionHandler.this._sessionListeners.get(i).sessionDestroyed(event);
                }
            };
            SessionHandler.this._contextHandler.getCoreContextHandler().getContext().run(r);
        }

        public void onSessionIdChanged(Session session, String oldId) {
            super.onSessionIdChanged(session, oldId);
            if (!SessionHandler.this._sessionIdListeners.isEmpty()) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session.getApi());
                for (HttpSessionIdListener l : SessionHandler.this._sessionIdListeners) {
                    l.sessionIdChanged(event, oldId);
                }
            }
        }

        protected void callUnboundBindingListener(Session session, String name, Object value) {
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)session.getApi(), name));
            }
        }

        protected void callBoundBindingListener(Session session, String name, Object value) {
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)session.getApi(), name));
            }
        }

        public void onSessionActivation(Session session) {
            for (String name : session.getAttributeNameSet()) {
                Object value = session.getAttribute(name);
                if (!(value instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session.getApi());
                listener.sessionDidActivate(event);
            }
        }

        public void onSessionPassivation(Session session) {
            for (String name : session.getAttributeNameSet()) {
                Object value = session.getAttribute(name);
                if (!(value instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session.getApi());
                listener.sessionWillPassivate(event);
            }
        }
    }

    public final class CookieConfig
    implements SessionCookieConfig {
        public String getComment() {
            return SessionHandler.this._sessionManager.getSessionComment();
        }

        public String getDomain() {
            return SessionHandler.this._sessionManager.getSessionDomain();
        }

        public int getMaxAge() {
            return SessionHandler.this._sessionManager.getMaxCookieAge();
        }

        public String getName() {
            return SessionHandler.this._sessionManager.getSessionCookie();
        }

        public String getPath() {
            return SessionHandler.this._sessionManager.getSessionPath();
        }

        public boolean isHttpOnly() {
            return SessionHandler.this._sessionManager.isHttpOnly();
        }

        public boolean isSecure() {
            return SessionHandler.this._sessionManager.isSecureCookies();
        }

        private void checkAvailable() {
            if (SessionHandler.this._contextHandler != null && SessionHandler.this._contextHandler.isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
        }

        public void setComment(String comment) {
            this.checkAvailable();
            SessionHandler.this._sessionManager.setSessionComment(comment);
        }

        public void setDomain(String domain) {
            this.checkAvailable();
            SessionHandler.this._sessionManager.setSessionDomain(domain);
        }

        public void setHttpOnly(boolean httpOnly) {
            this.checkAvailable();
            SessionHandler.this._sessionManager.setHttpOnly(httpOnly);
        }

        public void setMaxAge(int maxAge) {
            this.checkAvailable();
            SessionHandler.this._sessionManager.setMaxCookieAge(maxAge);
        }

        public void setName(String name) {
            this.checkAvailable();
            SessionHandler.this._sessionManager.setSessionCookie(name);
        }

        public void setPath(String path) {
            this.checkAvailable();
            SessionHandler.this._sessionManager.setSessionPath(path);
        }

        public void setSecure(boolean secure) {
            this.checkAvailable();
            SessionHandler.this._sessionManager.setSecureCookies(secure);
        }
    }

    public class ServletSessionApi
    implements HttpSession,
    Session.API {
        private final ManagedSession _session;

        public static Function<Boolean, Session> getOrCreateSession(ServletRequest servletRequest) {
            return createSession -> {
                HttpServletRequest request;
                HttpSession session;
                if (servletRequest instanceof HttpServletRequest && (session = (request = (HttpServletRequest)servletRequest).getSession(createSession.booleanValue())) instanceof ServletSessionApi) {
                    ServletSessionApi sessionApi = (ServletSessionApi)session;
                    return sessionApi.getSession();
                }
                return null;
            };
        }

        private ServletSessionApi(ManagedSession session) {
            this._session = session;
        }

        public ManagedSession getSession() {
            return this._session;
        }

        public long getCreationTime() {
            return this._session.getCreationTime();
        }

        public String getId() {
            return this._session.getId();
        }

        public long getLastAccessedTime() {
            return this._session.getLastAccessedTime();
        }

        public ServletContext getServletContext() {
            return SessionHandler.this._contextHandler.getServletContext();
        }

        public void setMaxInactiveInterval(int interval) {
            this._session.setMaxInactiveInterval(interval);
        }

        public int getMaxInactiveInterval() {
            return this._session.getMaxInactiveInterval();
        }

        public Object getAttribute(String name) {
            return this._session.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this._session.getAttributeNameSet());
        }

        public void setAttribute(String name, Object value) {
            this._session.setAttribute(name, value);
        }

        public void removeAttribute(String name) {
            this._session.removeAttribute(name);
        }

        public void invalidate() {
            this._session.invalidate();
        }

        public boolean isNew() {
            return this._session.isNew();
        }

        public HttpSessionContext getSessionContext() {
            return null;
        }

        public Object getValue(String name) {
            return this.getAttribute(name);
        }

        public String[] getValueNames() {
            return this._session.getAttributeNameSet().toArray(new String[0]);
        }

        public void putValue(String name, Object value) {
            this.setAttribute(name, value);
        }

        public void removeValue(String name) {
            this.removeAttribute(name);
        }
    }
}

