/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server.internal;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.generator.ServerGenerator;
import org.eclipse.jetty.fcgi.parser.ServerParser;
import org.eclipse.jetty.fcgi.server.internal.HttpStreamOverFCGI;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerFCGIConnection
extends AbstractConnection
implements ConnectionMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(ServerFCGIConnection.class);
    private final HttpChannel.Factory httpChannelFactory = new HttpChannel.DefaultFactory();
    private final Attributes attributes = new Attributes.Lazy();
    private final Connector connector;
    private final ByteBufferPool networkByteBufferPool;
    private final boolean sendStatus200;
    private final Flusher flusher;
    private final HttpConfiguration configuration;
    private final ServerParser parser;
    private final String id;
    private boolean useInputDirectByteBuffers;
    private boolean useOutputDirectByteBuffers;
    private RetainableByteBuffer networkBuffer;
    private HttpStreamOverFCGI stream;

    public ServerFCGIConnection(Connector connector, EndPoint endPoint, HttpConfiguration configuration, boolean sendStatus200) {
        super(endPoint, connector.getExecutor());
        this.connector = connector;
        this.networkByteBufferPool = connector.getByteBufferPool();
        this.flusher = new Flusher(endPoint);
        this.configuration = configuration;
        this.sendStatus200 = sendStatus200;
        this.parser = new ServerParser((ServerParser.Listener)new ServerListener());
        this.id = StringUtil.randomAlphaNumeric((int)16);
    }

    public long getBeginNanoTime() {
        return this.parser.getBeginNanoTime();
    }

    Flusher getFlusher() {
        return this.flusher;
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public String getId() {
        return this.id;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.configuration;
    }

    public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_1_1;
    }

    public String getProtocol() {
        return "fcgi/1.0";
    }

    public Connection getConnection() {
        return this;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean isSecure() {
        return false;
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.getEndPoint().getRemoteSocketAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.getEndPoint().getLocalSocketAddress();
    }

    public Object removeAttribute(String name) {
        return this.attributes.removeAttribute(name);
    }

    public Object setAttribute(String name, Object attribute) {
        return this.attributes.setAttribute(name, attribute);
    }

    public Object getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        return this.attributes.getAttributeNameSet();
    }

    public void clearAttributes() {
        this.attributes.clearAttributes();
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onFillable() {
        this.acquireInputBuffer();
        try {
            int read;
            block7: {
                do {
                    read = this.fillInputBuffer();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read {} bytes from {} {}", new Object[]{read, this.getEndPoint(), this});
                    }
                    if (read <= 0) break block7;
                } while (!this.parse(this.networkBuffer.getByteBuffer()));
                return;
            }
            if (read == 0) {
                this.releaseInputBuffer();
                this.fillInterested();
            } else {
                this.releaseInputBuffer();
                this.shutdown();
            }
        }
        catch (Exception x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to fill endpoint", (Throwable)x);
            }
            this.networkBuffer.clear();
            this.releaseInputBuffer();
        }
    }

    void parseAndFill() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parseAndFill {}", (Object)this);
        }
        while (this.stream != null) {
            if (this.parse(this.networkBuffer.getByteBuffer())) {
                return;
            }
            if (this.stream == null) {
                return;
            }
            if (this.fillInputBuffer() > 0) continue;
            break;
        }
    }

    private void acquireInputBuffer() {
        if (this.networkBuffer == null) {
            this.networkBuffer = this.networkByteBufferPool.acquire(this.configuration.getResponseHeaderSize(), this.isUseInputDirectByteBuffers());
        }
    }

    private void releaseInputBuffer() {
        if (this.networkBuffer == null) {
            return;
        }
        boolean released = this.networkBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("releaseInputBuffer {} {}", (Object)released, (Object)this);
        }
        if (released) {
            this.networkBuffer = null;
        }
    }

    private int fillInputBuffer() {
        try {
            return this.getEndPoint().fill(this.networkBuffer.getByteBuffer());
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not fill from {}", (Object)this, (Object)x);
            }
            return -1;
        }
    }

    protected boolean onReadTimeout(TimeoutException timeout) {
        if (this.stream != null) {
            return this.stream.onIdleTimeout(timeout);
        }
        return true;
    }

    private boolean parse(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            boolean result = this.parser.parse(buffer);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private void shutdown() {
        this.flusher.shutdown();
    }

    void onCompleted(Throwable failure) {
        this.releaseInputBuffer();
        if (failure == null) {
            this.fillInterested();
        } else {
            this.getFlusher().shutdown();
        }
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        HttpStreamOverFCGI stream = this.stream;
        if (stream == null) {
            return true;
        }
        Runnable task = stream.getHttpChannel().onIdleTimeout(timeoutException);
        if (task != null) {
            this.getExecutor().execute(task);
        }
        return false;
    }

    private class ServerListener
    implements ServerParser.Listener {
        private ServerListener() {
        }

        public void onStart(int request, FCGI.Role role, int flags) {
            if (ServerFCGIConnection.this.stream != null) {
                throw new UnsupportedOperationException("FastCGI Multiplexing");
            }
            HttpChannel channel = ServerFCGIConnection.this.httpChannelFactory.newHttpChannel((ConnectionMetaData)ServerFCGIConnection.this);
            ServerGenerator generator = new ServerGenerator(ServerFCGIConnection.this.connector.getByteBufferPool(), ServerFCGIConnection.this.isUseOutputDirectByteBuffers(), ServerFCGIConnection.this.sendStatus200);
            ServerFCGIConnection.this.stream = new HttpStreamOverFCGI(ServerFCGIConnection.this, generator, channel, request);
            channel.setHttpStream((HttpStream)ServerFCGIConnection.this.stream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} start on {}", (Object)request, (Object)channel);
            }
        }

        public void onHeader(int request, HttpField field) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} header {} on {}", new Object[]{request, field, ServerFCGIConnection.this.stream});
            }
            if (ServerFCGIConnection.this.stream != null) {
                ServerFCGIConnection.this.stream.onHeader(field);
            }
        }

        public boolean onHeaders(int request) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} headers on {}", (Object)request, (Object)ServerFCGIConnection.this.stream);
            }
            if (ServerFCGIConnection.this.stream != null) {
                ServerFCGIConnection.this.stream.onHeaders();
                return true;
            }
            return false;
        }

        public boolean onContent(int request, FCGI.StreamType streamType, ByteBuffer buffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} {} content {} on {}", new Object[]{request, streamType, buffer, ServerFCGIConnection.this.stream});
            }
            if (ServerFCGIConnection.this.stream != null) {
                Content.Chunk chunk = Content.Chunk.asChunk((ByteBuffer)buffer, (boolean)false, (Retainable)ServerFCGIConnection.this.networkBuffer);
                ServerFCGIConnection.this.stream.onContent(chunk);
                return true;
            }
            return false;
        }

        public void onEnd(int request) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} end on {}", (Object)request, (Object)ServerFCGIConnection.this.stream);
            }
            if (ServerFCGIConnection.this.stream != null) {
                ServerFCGIConnection.this.stream.onComplete();
                ServerFCGIConnection.this.stream = null;
            }
        }

        public void onFailure(int request, Throwable failure) {
            Runnable runnable;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} failure on {}: {}", new Object[]{request, ServerFCGIConnection.this.stream, failure});
            }
            if (ServerFCGIConnection.this.stream != null && (runnable = ServerFCGIConnection.this.stream.getHttpChannel().onFailure((Throwable)new BadMessageException(null, failure))) != null) {
                ServerFCGIConnection.this.getExecutor().execute(runnable);
            }
            ServerFCGIConnection.this.stream = null;
        }
    }
}

