/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import java.util.Stack;
import java.util.function.Supplier;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class OperandStack {
    private Stack<TypeBinding> stack;
    private ClassFile classFile;

    public OperandStack() {
    }

    OperandStack(OperandStack operandStack) {
        this.stack = (Stack)operandStack.stack.clone();
        this.classFile = operandStack.classFile;
    }

    public OperandStack(ClassFile classFile) {
        this.stack = new Stack();
        this.classFile = classFile;
    }

    public int size() {
        return this.stack.size();
    }

    public void clear() {
        this.stack.clear();
    }

    protected OperandStack copy() {
        return new OperandStack(this);
    }

    public TypeBinding pop() {
        return this.stack.pop();
    }

    public void push(TypeBinding typeBinding) {
        if (typeBinding == null) {
            throw new AssertionError((Object)"Attempt to push null on operand stack!");
        }
        this.stack.push(typeBinding);
    }

    private TypeBinding getPopularBinding(char[] typeName) {
        ClassScope scope = this.classFile.referenceBinding.scope;
        assert (scope != null);
        Supplier<ReferenceBinding> finder = scope.getCommonReferenceBinding(typeName);
        return finder != null ? (TypeBinding)finder.get() : TypeBinding.NULL;
    }

    public void push(char[] typeName) {
        this.push(this.getPopularBinding(typeName));
    }

    public TypeBinding peek() {
        return this.stack.peek();
    }

    public void xaload() {
        this.stack.pop();
        TypeBinding type = this.stack.pop();
        this.stack.push(((ArrayBinding)type).elementsType());
    }

    public static class NullStack
    extends OperandStack {
        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        protected NullStack copy() {
            return new NullStack();
        }

        @Override
        public TypeBinding pop() {
            return TypeBinding.VOID;
        }

        @Override
        public void push(TypeBinding typeBinding) {
        }

        @Override
        public TypeBinding peek() {
            return TypeBinding.VOID;
        }

        @Override
        public void push(char[] typeName) {
        }

        @Override
        public void xaload() {
        }
    }
}

