/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.eclipse.jetty.session.SessionData;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.Indexed;

@Indexed
public class InfinispanSessionData
extends SessionData {
    protected byte[] _serializedAttributes;

    public InfinispanSessionData(String id, String cpath, String vhost, long created, long accessed, long lastAccessed, long maxInactiveMs) {
        super(id, cpath, vhost, created, accessed, lastAccessed, maxInactiveMs);
    }

    public InfinispanSessionData(String id, String cpath, String vhost, long created, long accessed, long lastAccessed, long maxInactiveMs, Map<String, Object> attributes) {
        super(id, cpath, vhost, created, accessed, lastAccessed, maxInactiveMs, attributes);
    }

    @GenericField(searchable=Searchable.YES)
    public long getExpiry() {
        return super.getExpiry();
    }

    public byte[] getSerializedAttributes() {
        return this._serializedAttributes;
    }

    public void setSerializedAttributes(byte[] serializedAttributes) {
        this._serializedAttributes = serializedAttributes;
    }

    public void deserializeAttributes() throws ClassNotFoundException, IOException {
        if (this._serializedAttributes == null) {
            return;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this._serializedAttributes);
             ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream((InputStream)bais);){
            SessionData.deserializeAttributes((SessionData)this, (ObjectInputStream)ois);
            this._serializedAttributes = null;
        }
    }

    public void serializeAttributes() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            SessionData.serializeAttributes((SessionData)this, (ObjectOutputStream)oos);
            this._serializedAttributes = baos.toByteArray();
        }
    }
}

