/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.javax.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.eclipse.jetty.ee8.websocket.javax.common.JavaxWebSocketRemoteEndpoint;
import org.eclipse.jetty.ee8.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.ee8.websocket.javax.common.SendHandlerCallback;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.messages.MessageOutputStream;
import org.eclipse.jetty.websocket.core.messages.MessageWriter;
import org.eclipse.jetty.websocket.core.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaxWebSocketAsyncRemote
extends JavaxWebSocketRemoteEndpoint
implements RemoteEndpoint.Async {
    static final Logger LOG = LoggerFactory.getLogger(JavaxWebSocketAsyncRemote.class);

    protected JavaxWebSocketAsyncRemote(JavaxWebSocketSession session, CoreSession coreSession) {
        super(session, coreSession);
    }

    public long getSendTimeout() {
        return this.getWriteTimeout();
    }

    public void setSendTimeout(long timeoutmillis) {
        this.setWriteTimeout(timeoutmillis);
    }

    public Future<Void> sendBinary(ByteBuffer data) {
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({})", (Object)BufferUtil.toDetailString((ByteBuffer)data));
        }
        FutureCallback future = new FutureCallback();
        this.sendFrame(new Frame(2).setPayload(data), (Callback)future, this.batch);
        return future;
    }

    public void sendBinary(ByteBuffer data, SendHandler handler) {
        this.assertMessageNotNull(data);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({},{})", (Object)BufferUtil.toDetailString((ByteBuffer)data), (Object)handler);
        }
        this.sendFrame(new Frame(2).setPayload(data), new SendHandlerCallback(handler), this.batch);
    }

    public Future<Void> sendObject(Object data) {
        FutureCallback future = new FutureCallback();
        try {
            this.sendObject(data, (Callback)future);
        }
        catch (Throwable t) {
            future.failed(t);
        }
        return future;
    }

    public void sendObject(Object data, SendHandler handler) {
        Encoder encoder;
        this.assertMessageNotNull(data);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendObject({},{})", data, (Object)handler);
        }
        if ((encoder = this.session.getEncoders().getInstanceFor(data.getClass())) == null) {
            throw new IllegalArgumentException("No encoder for type: " + String.valueOf(data.getClass()));
        }
        if (encoder instanceof Encoder.Text) {
            Encoder.Text etxt = (Encoder.Text)encoder;
            try {
                String msg = etxt.encode(data);
                this.sendText(msg, handler);
                return;
            }
            catch (EncodeException e) {
                handler.onResult(new SendResult((Throwable)e));
            }
        } else if (encoder instanceof Encoder.TextStream) {
            Encoder.TextStream etxt = (Encoder.TextStream)encoder;
            SendHandlerCallback callback = new SendHandlerCallback(handler);
            try (MessageWriter writer = this.newMessageWriter();){
                writer.setCallback((Callback)callback);
                etxt.encode(data, (Writer)writer);
                return;
            }
            catch (IOException | EncodeException e) {
                handler.onResult(new SendResult(e));
            }
        } else if (encoder instanceof Encoder.Binary) {
            Encoder.Binary ebin = (Encoder.Binary)encoder;
            try {
                ByteBuffer buf = ebin.encode(data);
                this.sendBinary(buf, handler);
                return;
            }
            catch (EncodeException e) {
                handler.onResult(new SendResult((Throwable)e));
            }
        } else if (encoder instanceof Encoder.BinaryStream) {
            Encoder.BinaryStream ebin = (Encoder.BinaryStream)encoder;
            SendHandlerCallback callback = new SendHandlerCallback(handler);
            try (MessageOutputStream out = this.newMessageOutputStream();){
                out.setCallback((Callback)callback);
                ebin.encode(data, (OutputStream)out);
                return;
            }
            catch (IOException | EncodeException e) {
                handler.onResult(new SendResult(e));
            }
        }
        throw new IllegalArgumentException("Unknown encoder type: " + String.valueOf(encoder));
    }

    public Future<Void> sendText(String text) {
        this.assertMessageNotNull(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({})", (Object)TextUtils.hint((String)text));
        }
        FutureCallback future = new FutureCallback();
        this.sendFrame(new Frame(1).setPayload(text), (Callback)future, this.batch);
        return future;
    }

    public void sendText(String text, SendHandler handler) {
        this.assertMessageNotNull(text);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({},{})", (Object)TextUtils.hint((String)text), (Object)handler);
        }
        this.sendFrame(new Frame(1).setPayload(text), new SendHandlerCallback(handler), this.batch);
    }
}

