/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.jna;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.quiche.QuicheBinding;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.jna.JnaQuicheConnection;
import org.eclipse.jetty.quic.quiche.jna.LibQuiche;

public class JnaQuicheBinding
implements QuicheBinding {
    private Throwable failure;

    public Throwable initialize() {
        try {
            LibQuiche.initialize();
            this.failure = null;
        }
        catch (ExceptionInInitializerError e) {
            Throwable cause = e.getCause();
            this.failure = cause != null ? cause : e;
        }
        catch (Throwable x) {
            this.failure = x;
        }
        return this.failure;
    }

    public int priority() {
        return 200;
    }

    public byte[] fromPacket(ByteBuffer packet) {
        return JnaQuicheConnection.fromPacket(packet);
    }

    public QuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer, int connectionIdLength) throws IOException {
        return JnaQuicheConnection.connect(quicheConfig, local, peer, connectionIdLength);
    }

    public boolean negotiate(QuicheConnection.TokenMinter tokenMinter, ByteBuffer packetRead, ByteBuffer packetToSend) throws IOException {
        return JnaQuicheConnection.negotiate(tokenMinter, packetRead, packetToSend);
    }

    public QuicheConnection tryAccept(QuicheConfig quicheConfig, QuicheConnection.TokenValidator tokenValidator, ByteBuffer packetRead, SocketAddress local, SocketAddress peer) throws IOException {
        return JnaQuicheConnection.tryAccept(quicheConfig, tokenValidator, packetRead, local, peer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{p=" + this.priority() + " f=" + String.valueOf(this.failure) + "}";
    }
}

