/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.jna;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.jna.LibQuiche;
import org.eclipse.jetty.quic.quiche.jna.SizedStructure;
import org.eclipse.jetty.quic.quiche.jna.bool;
import org.eclipse.jetty.quic.quiche.jna.bool_pointer;
import org.eclipse.jetty.quic.quiche.jna.char_pointer;
import org.eclipse.jetty.quic.quiche.jna.size_t;
import org.eclipse.jetty.quic.quiche.jna.size_t_pointer;
import org.eclipse.jetty.quic.quiche.jna.sockaddr;
import org.eclipse.jetty.quic.quiche.jna.sockaddr_storage;
import org.eclipse.jetty.quic.quiche.jna.ssize_t;
import org.eclipse.jetty.quic.quiche.jna.uint32_t;
import org.eclipse.jetty.quic.quiche.jna.uint32_t_pointer;
import org.eclipse.jetty.quic.quiche.jna.uint64_t;
import org.eclipse.jetty.quic.quiche.jna.uint64_t_pointer;
import org.eclipse.jetty.quic.quiche.jna.uint8_t_pointer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnaQuicheConnection
extends QuicheConnection {
    private static final Logger LOG = LoggerFactory.getLogger(JnaQuicheConnection.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final AutoLock lock = new AutoLock();
    private LibQuiche.quiche_conn quicheConn;
    private LibQuiche.quiche_config quicheConfig;

    private JnaQuicheConnection(LibQuiche.quiche_conn quicheConn, LibQuiche.quiche_config quicheConfig) {
        this.quicheConn = quicheConn;
        this.quicheConfig = quicheConfig;
    }

    public static byte[] fromPacket(ByteBuffer packet) {
        uint8_t_pointer type = new uint8_t_pointer();
        uint32_t_pointer version = new uint32_t_pointer();
        byte[] scid = new byte[20];
        size_t_pointer scidLen = new size_t_pointer(scid.length);
        byte[] dcid = new byte[20];
        size_t_pointer dcidLen = new size_t_pointer(dcid.length);
        byte[] token = new byte[48];
        size_t_pointer tokenLen = new size_t_pointer(token.length);
        LOG.debug("getting header info (fromPacket)...");
        int rc = LibQuiche.INSTANCE.quiche_header_info(packet, new size_t(packet.remaining()), new size_t(20L), version, type, scid, scidLen, dcid, dcidLen, token, tokenLen);
        if (rc < 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("quiche cannot read header info from packet {}", (Object)BufferUtil.toDetailString((ByteBuffer)packet));
            }
            return null;
        }
        return JnaQuicheConnection.resizeIfNeeded(dcid, (int)dcidLen.getValue());
    }

    private static byte[] resizeIfNeeded(byte[] buffer, int length) {
        byte[] sizedBuffer;
        if (length == buffer.length) {
            sizedBuffer = buffer;
        } else {
            sizedBuffer = new byte[length];
            System.arraycopy(buffer, 0, sizedBuffer, 0, sizedBuffer.length);
        }
        return sizedBuffer;
    }

    public static JnaQuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer) throws IOException {
        return JnaQuicheConnection.connect(quicheConfig, local, peer, 20);
    }

    public static JnaQuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer, int connectionIdLength) throws IOException {
        if (connectionIdLength > 20) {
            throw new IOException("Connection ID length is too large: " + connectionIdLength + " > 20");
        }
        byte[] scid = new byte[connectionIdLength];
        SECURE_RANDOM.nextBytes(scid);
        LibQuiche.quiche_config libQuicheConfig = JnaQuicheConnection.buildConfig(quicheConfig);
        SizedStructure<sockaddr> localSockaddr = sockaddr.convert(local);
        SizedStructure<sockaddr> peerSockaddr = sockaddr.convert(peer);
        LibQuiche.quiche_conn quicheConn = LibQuiche.INSTANCE.quiche_connect(peer.getHostString(), scid, new size_t(scid.length), localSockaddr.getStructure(), localSockaddr.getSize(), peerSockaddr.getStructure(), peerSockaddr.getSize(), libQuicheConfig);
        return new JnaQuicheConnection(quicheConn, libQuicheConfig);
    }

    private static LibQuiche.quiche_config buildConfig(QuicheConfig config) throws IOException {
        Long activeConnectionIdLimit;
        Long maxStreamWindow;
        Long maxConnectionWindow;
        Boolean disableActiveMigration;
        Long initialMaxStreamsUni;
        Long initialMaxStreamsBidi;
        Long initialMaxStreamDataUni;
        Long initialMaxStreamDataBidiRemote;
        Long initialMaxStreamDataBidiLocal;
        Long initialMaxData;
        Long maxIdleTimeout;
        QuicheConfig.CongestionControl cc;
        int rc;
        int rc2;
        int rc3;
        String trustedCertsPemPath;
        LibQuiche.quiche_config quicheConfig = LibQuiche.INSTANCE.quiche_config_new(new uint32_t(config.getVersion()));
        if (quicheConfig == null) {
            throw new IOException("Failed to create quiche config");
        }
        Boolean verifyPeer = config.getVerifyPeer();
        if (verifyPeer != null) {
            LibQuiche.INSTANCE.quiche_config_verify_peer(quicheConfig, new bool(verifyPeer));
        }
        if ((trustedCertsPemPath = config.getTrustedCertsPemPath()) != null && (rc3 = LibQuiche.INSTANCE.quiche_config_load_verify_locations_from_file(quicheConfig, trustedCertsPemPath)) != 0) {
            throw new IOException("Error loading trusted certificates file " + trustedCertsPemPath + " : " + Quiche.quiche_error.errToString((long)rc3));
        }
        String certChainPemPath = config.getCertChainPemPath();
        if (certChainPemPath != null && (rc2 = LibQuiche.INSTANCE.quiche_config_load_cert_chain_from_pem_file(quicheConfig, certChainPemPath)) < 0) {
            throw new IOException("Error loading certificate chain file " + certChainPemPath + " : " + Quiche.quiche_error.errToString((long)rc2));
        }
        String privKeyPemPath = config.getPrivKeyPemPath();
        if (privKeyPemPath != null && (rc = LibQuiche.INSTANCE.quiche_config_load_priv_key_from_pem_file(quicheConfig, privKeyPemPath)) < 0) {
            throw new IOException("Error loading private key file " + privKeyPemPath + " : " + Quiche.quiche_error.errToString((long)rc));
        }
        String[] applicationProtos = config.getApplicationProtos();
        if (applicationProtos != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String proto : applicationProtos) {
                byte[] bytes = proto.getBytes(LibQuiche.CHARSET);
                baos.write(bytes.length);
                baos.write(bytes);
            }
            byte[] bytes = baos.toByteArray();
            LibQuiche.INSTANCE.quiche_config_set_application_protos(quicheConfig, bytes, new size_t(bytes.length));
        }
        if ((cc = config.getCongestionControl()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_cc_algorithm(quicheConfig, cc.getValue());
        }
        if ((maxIdleTimeout = config.getMaxIdleTimeout()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_max_idle_timeout(quicheConfig, new uint64_t(maxIdleTimeout));
        }
        if ((initialMaxData = config.getInitialMaxData()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_initial_max_data(quicheConfig, new uint64_t(initialMaxData));
        }
        if ((initialMaxStreamDataBidiLocal = config.getInitialMaxStreamDataBidiLocal()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_initial_max_stream_data_bidi_local(quicheConfig, new uint64_t(initialMaxStreamDataBidiLocal));
        }
        if ((initialMaxStreamDataBidiRemote = config.getInitialMaxStreamDataBidiRemote()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_initial_max_stream_data_bidi_remote(quicheConfig, new uint64_t(initialMaxStreamDataBidiRemote));
        }
        if ((initialMaxStreamDataUni = config.getInitialMaxStreamDataUni()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_initial_max_stream_data_uni(quicheConfig, new uint64_t(initialMaxStreamDataUni));
        }
        if ((initialMaxStreamsBidi = config.getInitialMaxStreamsBidi()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_initial_max_streams_bidi(quicheConfig, new uint64_t(initialMaxStreamsBidi));
        }
        if ((initialMaxStreamsUni = config.getInitialMaxStreamsUni()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_initial_max_streams_uni(quicheConfig, new uint64_t(initialMaxStreamsUni));
        }
        if ((disableActiveMigration = config.getDisableActiveMigration()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_disable_active_migration(quicheConfig, new bool(disableActiveMigration));
        }
        if ((maxConnectionWindow = config.getMaxConnectionWindow()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_max_connection_window(quicheConfig, new uint64_t(maxConnectionWindow));
        }
        if ((maxStreamWindow = config.getMaxStreamWindow()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_max_stream_window(quicheConfig, new uint64_t(maxStreamWindow));
        }
        if ((activeConnectionIdLimit = config.getActiveConnectionIdLimit()) != null) {
            LibQuiche.INSTANCE.quiche_config_set_active_connection_id_limit(quicheConfig, new uint64_t(activeConnectionIdLimit));
        }
        return quicheConfig;
    }

    public static String packetTypeAsString(ByteBuffer packet) {
        byte type = JnaQuicheConnection.packetType(packet);
        return LibQuiche.packet_type.typeToString(type);
    }

    public static byte packetType(ByteBuffer packet) {
        uint8_t_pointer type = new uint8_t_pointer();
        uint32_t_pointer version = new uint32_t_pointer();
        byte[] scid = new byte[20];
        size_t_pointer scid_len = new size_t_pointer(scid.length);
        byte[] dcid = new byte[20];
        size_t_pointer dcid_len = new size_t_pointer(dcid.length);
        byte[] token = new byte[48];
        size_t_pointer token_len = new size_t_pointer(token.length);
        LOG.debug("getting header info (packetType)...");
        int rc = LibQuiche.INSTANCE.quiche_header_info(packet, new size_t(packet.remaining()), new size_t(20L), version, type, scid, scid_len, dcid, dcid_len, token, token_len);
        if (rc < 0) {
            return (byte)rc;
        }
        return type.getValue();
    }

    public static boolean negotiate(QuicheConnection.TokenMinter tokenMinter, ByteBuffer packetRead, ByteBuffer packetToSend) throws IOException {
        uint8_t_pointer type = new uint8_t_pointer();
        uint32_t_pointer version = new uint32_t_pointer();
        byte[] scid = new byte[20];
        size_t_pointer scid_len = new size_t_pointer(scid.length);
        byte[] dcid = new byte[20];
        size_t_pointer dcid_len = new size_t_pointer(dcid.length);
        byte[] token = new byte[48];
        size_t_pointer token_len = new size_t_pointer(token.length);
        LOG.debug("getting header info (negotiate)...");
        int rc = LibQuiche.INSTANCE.quiche_header_info(packetRead, new size_t(packetRead.remaining()), new size_t(20L), version, type, scid, scid_len, dcid, dcid_len, token, token_len);
        if (rc < 0) {
            throw new IOException("failed to parse header: " + Quiche.quiche_error.errToString((long)rc));
        }
        packetRead.position(packetRead.limit());
        LOG.debug("version: {}", (Object)version);
        LOG.debug("type: {}", (Object)type);
        LOG.debug("scid len: {}", (Object)scid_len);
        LOG.debug("dcid len: {}", (Object)dcid_len);
        LOG.debug("token len: {}", (Object)token_len);
        if (LibQuiche.INSTANCE.quiche_version_is_supported(version.getPointee()).isFalse()) {
            LOG.debug("version negotiation");
            ssize_t generated = LibQuiche.INSTANCE.quiche_negotiate_version(scid, scid_len.getPointee(), dcid, dcid_len.getPointee(), packetToSend, new size_t(packetToSend.remaining()));
            packetToSend.position(packetToSend.position() + generated.intValue());
            if (generated.intValue() < 0) {
                throw new IOException("failed to create vneg packet : " + Quiche.quiche_error.errToString((long)generated.intValue()));
            }
            return true;
        }
        if (token_len.getValue() == 0L) {
            LOG.debug("stateless retry");
            token = tokenMinter.mint(dcid, (int)dcid_len.getValue());
            byte[] newCid = new byte[20];
            SECURE_RANDOM.nextBytes(newCid);
            ssize_t generated = LibQuiche.INSTANCE.quiche_retry(scid, scid_len.getPointee(), dcid, dcid_len.getPointee(), newCid, new size_t(newCid.length), token, new size_t(token.length), version.getPointee(), packetToSend, new size_t(packetToSend.remaining()));
            packetToSend.position(packetToSend.position() + generated.intValue());
            if (generated.intValue() < 0) {
                throw new IOException("failed to create retry packet: " + Quiche.quiche_error.errToString((long)generated.intValue()));
            }
            return true;
        }
        return false;
    }

    public static JnaQuicheConnection tryAccept(QuicheConfig quicheConfig, QuicheConnection.TokenValidator tokenValidator, ByteBuffer packetRead, SocketAddress local, SocketAddress peer) throws IOException {
        uint8_t_pointer type = new uint8_t_pointer();
        uint32_t_pointer version = new uint32_t_pointer();
        byte[] scid = new byte[20];
        size_t_pointer scid_len = new size_t_pointer(scid.length);
        byte[] dcid = new byte[20];
        size_t_pointer dcid_len = new size_t_pointer(dcid.length);
        byte[] token = new byte[48];
        size_t_pointer token_len = new size_t_pointer(token.length);
        LOG.debug("getting header info (tryAccept)...");
        int rc = LibQuiche.INSTANCE.quiche_header_info(packetRead, new size_t(packetRead.remaining()), new size_t(20L), version, type, scid, scid_len, dcid, dcid_len, token, token_len);
        if (rc < 0) {
            throw new IOException("failed to parse header: " + Quiche.quiche_error.errToString((long)rc));
        }
        LOG.debug("version: {}", (Object)version);
        LOG.debug("type: {}", (Object)type);
        LOG.debug("scid len: {}", (Object)scid_len);
        LOG.debug("dcid len: {}", (Object)dcid_len);
        LOG.debug("token len: {}", (Object)token_len);
        if (LibQuiche.INSTANCE.quiche_version_is_supported(version.getPointee()).isFalse()) {
            LOG.debug("need version negotiation");
            return null;
        }
        if (token_len.getValue() == 0L) {
            LOG.debug("need stateless retry");
            return null;
        }
        LOG.debug("token validation...");
        byte[] odcid = tokenValidator.validate(token, (int)token_len.getValue());
        if (odcid == null) {
            throw new QuicheConnection.TokenValidationException("invalid address validation token");
        }
        LOG.debug("validated token");
        LOG.debug("connection creation...");
        LibQuiche.quiche_config libQuicheConfig = JnaQuicheConnection.buildConfig(quicheConfig);
        SizedStructure<sockaddr> localSockaddr = sockaddr.convert(local);
        SizedStructure<sockaddr> peerSockaddr = sockaddr.convert(peer);
        LibQuiche.quiche_conn quicheConn = LibQuiche.INSTANCE.quiche_accept(dcid, dcid_len.getPointee(), odcid, new size_t(odcid.length), localSockaddr.getStructure(), localSockaddr.getSize(), peerSockaddr.getStructure(), peerSockaddr.getSize(), libQuicheConfig);
        if (quicheConn == null) {
            LibQuiche.INSTANCE.quiche_config_free(libQuicheConfig);
            throw new IOException("failed to create connection");
        }
        LOG.debug("connection created");
        JnaQuicheConnection quicheConnection = new JnaQuicheConnection(quicheConn, libQuicheConfig);
        LOG.debug("accepted, immediately receiving the same packet - remaining in buffer: {}", (Object)packetRead.remaining());
        while (packetRead.hasRemaining()) {
            quicheConnection.feedCipherBytes(packetRead, local, peer);
        }
        return quicheConnection;
    }

    public void enableQlog(String filename, String title, String desc) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            if (LibQuiche.INSTANCE.quiche_conn_set_qlog_path(this.quicheConn, filename, title, desc).isFalse()) {
                throw new IOException("unable to set qlog path to " + filename);
            }
        }
    }

    public byte[] getPeerCertificate() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            char_pointer out = new char_pointer();
            size_t_pointer out_len = new size_t_pointer();
            LibQuiche.INSTANCE.quiche_conn_peer_cert(this.quicheConn, out, out_len);
            int len = out_len.getPointee().intValue();
            if (len <= 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = out.getValueAsBytes(len);
            return byArray;
        }
    }

    protected List<Long> iterableStreamIds(boolean write) {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            LibQuiche.quiche_stream_iter quiche_stream_iter2 = write ? LibQuiche.INSTANCE.quiche_conn_writable(this.quicheConn) : LibQuiche.INSTANCE.quiche_conn_readable(this.quicheConn);
            ArrayList<Long> result = new ArrayList<Long>();
            uint64_t_pointer streamId = new uint64_t_pointer();
            while (LibQuiche.INSTANCE.quiche_stream_iter_next(quiche_stream_iter2, streamId).isTrue()) {
                result.add(streamId.getValue());
            }
            LibQuiche.INSTANCE.quiche_stream_iter_free(quiche_stream_iter2);
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
    }

    public int feedCipherBytes(ByteBuffer buffer, SocketAddress local, SocketAddress peer) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IOException("Cannot receive when not connected");
            }
            LibQuiche.quiche_recv_info info = new LibQuiche.quiche_recv_info();
            SizedStructure<sockaddr> localSockaddr = sockaddr.convert(local);
            info.to = localSockaddr.getStructure().byReference();
            info.to_len = localSockaddr.getSize();
            SizedStructure<sockaddr> peerSockaddr = sockaddr.convert(peer);
            info.from = peerSockaddr.getStructure().byReference();
            info.from_len = peerSockaddr.getSize();
            int received = LibQuiche.INSTANCE.quiche_conn_recv(this.quicheConn, buffer, new size_t(buffer.remaining()), info).intValue();
            if (received < 0) {
                throw new IOException("failed to receive packet; quiche_err=" + Quiche.quiche_error.errToString((long)received) + " quic_err=" + Quiche.quic_error.errToString((long)this.getLocalCloseInfo().error()));
            }
            buffer.position(buffer.position() + received);
            int n = received;
            return n;
        }
    }

    public int drainCipherBytes(ByteBuffer buffer) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IOException("Cannot send when not connected");
            }
            LibQuiche.quiche_send_info quiche_send_info2 = new LibQuiche.quiche_send_info();
            quiche_send_info2.from = new sockaddr_storage();
            quiche_send_info2.from_len = new size_t(quiche_send_info2.to.size());
            quiche_send_info2.to = new sockaddr_storage();
            quiche_send_info2.to_len = new size_t(quiche_send_info2.to.size());
            int written = LibQuiche.INSTANCE.quiche_conn_send(this.quicheConn, buffer, new size_t(buffer.remaining()), quiche_send_info2).intValue();
            if ((long)written == -1L) {
                int n = 0;
                return n;
            }
            if ((long)written < 0L) {
                throw new IOException("failed to send packet; quiche_err=" + Quiche.quiche_error.errToString((long)written));
            }
            int prevPosition = buffer.position();
            buffer.position(prevPosition + written);
            int n = written;
            return n;
        }
    }

    public boolean isConnectionClosed() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = LibQuiche.INSTANCE.quiche_conn_is_closed(this.quicheConn).isTrue();
            return bl;
        }
    }

    public boolean isConnectionEstablished() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = LibQuiche.INSTANCE.quiche_conn_is_established(this.quicheConn).isTrue();
            return bl;
        }
    }

    public boolean isConnectionInEarlyData() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = LibQuiche.INSTANCE.quiche_conn_is_in_early_data(this.quicheConn).isTrue();
            return bl;
        }
    }

    public long nextTimeout() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            long l = LibQuiche.INSTANCE.quiche_conn_timeout_as_millis(this.quicheConn).longValue();
            return l;
        }
    }

    public void onTimeout() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            LibQuiche.INSTANCE.quiche_conn_on_timeout(this.quicheConn);
        }
    }

    public String getNegotiatedProtocol() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            char_pointer out = new char_pointer();
            size_t_pointer outLen = new size_t_pointer();
            LibQuiche.INSTANCE.quiche_conn_application_proto(this.quicheConn, out, outLen);
            String string = out.getValueAsString((int)outLen.getValue(), LibQuiche.CHARSET);
            return string;
        }
    }

    public boolean close(long error, String reason) {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connection was released");
                }
                boolean bl = false;
                return bl;
            }
            int length = reason == null ? 0 : reason.getBytes(LibQuiche.CHARSET).length;
            int rc = LibQuiche.INSTANCE.quiche_conn_close(this.quicheConn, new bool(true), new uint64_t(error), reason, new size_t(length));
            if (rc == 0) {
                boolean bl = true;
                return bl;
            }
            if ((long)rc == -1L) {
                boolean bl = false;
                return bl;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not close connection: {}", (Object)Quiche.quiche_error.errToString((long)rc));
            }
            boolean bl = false;
            return bl;
        }
    }

    public void dispose() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn != null) {
                LibQuiche.INSTANCE.quiche_conn_free(this.quicheConn);
            }
            if (this.quicheConfig != null) {
                LibQuiche.INSTANCE.quiche_config_free(this.quicheConfig);
            }
            this.quicheConn = null;
            this.quicheConfig = null;
        }
    }

    public boolean isDraining() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = LibQuiche.INSTANCE.quiche_conn_is_draining(this.quicheConn).isTrue();
            return bl;
        }
    }

    public int maxLocalStreams() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            LibQuiche.quiche_transport_params params = new LibQuiche.quiche_transport_params();
            LibQuiche.INSTANCE.quiche_conn_peer_transport_params(this.quicheConn, params);
            int n = params.peer_initial_max_streams_bidi.intValue();
            return n;
        }
    }

    public long windowCapacity() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            LibQuiche.quiche_path_stats stats = new LibQuiche.quiche_path_stats();
            LibQuiche.INSTANCE.quiche_conn_path_stats(this.quicheConn, new size_t(0L), stats);
            long l = stats.cwnd.longValue();
            return l;
        }
    }

    public long windowCapacity(long streamId) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            long value = LibQuiche.INSTANCE.quiche_conn_stream_capacity(this.quicheConn, new uint64_t(streamId)).longValue();
            if (value < 0L && LOG.isDebugEnabled()) {
                LOG.debug("could not read window capacity for stream {} quiche_err={}", (Object)streamId, (Object)Quiche.quiche_error.errToString((long)value));
            }
            long l = value;
            return l;
        }
    }

    public void shutdownStream(long streamId, boolean writeSide, long error) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            int direction = writeSide ? 1 : 0;
            int rc = LibQuiche.INSTANCE.quiche_conn_stream_shutdown(this.quicheConn, new uint64_t(streamId), direction, new uint64_t(error));
            if (rc == 0 || (long)rc == -1L) {
                return;
            }
            throw new IOException("failed to shutdown stream " + streamId + ": " + Quiche.quiche_error.errToString((long)rc));
        }
    }

    public int feedClearBytesForStream(long streamId, ByteBuffer buffer, boolean last) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            uint64_t_pointer outErrorCode = new uint64_t_pointer();
            int written = LibQuiche.INSTANCE.quiche_conn_stream_send(this.quicheConn, new uint64_t(streamId), JnaQuicheConnection.jnaBuffer(buffer), new size_t(buffer.remaining()), new bool(last), outErrorCode).intValue();
            if ((long)written == -1L) {
                int rc = LibQuiche.INSTANCE.quiche_conn_stream_writable(this.quicheConn, new uint64_t(streamId), new size_t(buffer.remaining()));
                if (rc < 0) {
                    throw new IOException("failed to write to stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)rc));
                }
                int n = 0;
                return n;
            }
            if ((long)written < 0L) {
                throw new IOException("failed to write to stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)written));
            }
            buffer.position(buffer.position() + written);
            int n = written;
            return n;
        }
    }

    private static ByteBuffer jnaBuffer(ByteBuffer buffer) {
        if (buffer.isDirect() || buffer.hasArray()) {
            return buffer;
        }
        ByteBuffer jnaBuffer = ByteBuffer.allocate(buffer.remaining());
        int oldPosition = buffer.position();
        jnaBuffer.put(buffer);
        jnaBuffer.flip();
        buffer.position(oldPosition);
        return jnaBuffer;
    }

    public int drainClearBytesForStream(long streamId, ByteBuffer buffer) throws IOException {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IOException("connection was released");
            }
            bool_pointer fin = new bool_pointer();
            uint64_t_pointer outErrorCode = new uint64_t_pointer();
            int read = LibQuiche.INSTANCE.quiche_conn_stream_recv(this.quicheConn, new uint64_t(streamId), buffer, new size_t(buffer.remaining()), fin, outErrorCode).intValue();
            if ((long)read == -1L) {
                int n = this.isStreamFinished(streamId) ? -1 : 0;
                return n;
            }
            if ((long)read == -16L) {
                throw new EOFException("failed to read from stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)read));
            }
            if ((long)read < 0L) {
                throw new IOException("failed to read from stream " + streamId + "; quiche_err=" + Quiche.quiche_error.errToString((long)read));
            }
            buffer.position(buffer.position() + read);
            int n = read;
            return n;
        }
    }

    public boolean isStreamFinished(long streamId) {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            boolean bl = LibQuiche.INSTANCE.quiche_conn_stream_finished(this.quicheConn, new uint64_t(streamId)).isTrue();
            return bl;
        }
    }

    public QuicheConnection.CloseInfo getRemoteCloseInfo() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            bool_pointer app = new bool_pointer();
            uint64_t_pointer error = new uint64_t_pointer();
            char_pointer reason = new char_pointer();
            size_t_pointer reasonLength = new size_t_pointer();
            if (LibQuiche.INSTANCE.quiche_conn_peer_error(this.quicheConn, app, error, reason, reasonLength).isTrue()) {
                QuicheConnection.CloseInfo closeInfo = new QuicheConnection.CloseInfo(error.getValue(), reason.getValueAsString((int)reasonLength.getValue(), LibQuiche.CHARSET));
                return closeInfo;
            }
            QuicheConnection.CloseInfo closeInfo = null;
            return closeInfo;
        }
    }

    public QuicheConnection.CloseInfo getLocalCloseInfo() {
        try (AutoLock ignore = this.lock.lock();){
            if (this.quicheConn == null) {
                throw new IllegalStateException("connection was released");
            }
            bool_pointer app = new bool_pointer();
            uint64_t_pointer error = new uint64_t_pointer();
            char_pointer reason = new char_pointer();
            size_t_pointer reasonLength = new size_t_pointer();
            if (LibQuiche.INSTANCE.quiche_conn_local_error(this.quicheConn, app, error, reason, reasonLength).isTrue()) {
                QuicheConnection.CloseInfo closeInfo = new QuicheConnection.CloseInfo(error.getValue(), reason.getValueAsString((int)reasonLength.getValue(), LibQuiche.CHARSET));
                return closeInfo;
            }
            QuicheConnection.CloseInfo closeInfo = null;
            return closeInfo;
        }
    }
}

