/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.generator;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flusher {
    private static final Logger LOG = LoggerFactory.getLogger(Flusher.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Entry> queue = new ArrayDeque<Entry>();
    private final IteratingCallback flushCallback = new FlushCallback();
    private final EndPoint endPoint;

    public Flusher(EndPoint endPoint) {
        this.endPoint = endPoint;
    }

    public void flush(ByteBufferPool.Accumulator accumulator, Callback callback) {
        this.offer(new Entry(accumulator, callback));
        this.flushCallback.iterate();
    }

    private void offer(Entry entry) {
        try (AutoLock ignored = this.lock.lock();){
            this.queue.offer(entry);
        }
    }

    private Entry poll() {
        try (AutoLock ignored = this.lock.lock();){
            Entry entry = this.queue.poll();
            return entry;
        }
    }

    public void shutdown() {
        this.flush(null, Callback.from(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutting down {}", (Object)this.endPoint);
            }
            this.endPoint.shutdownOutput();
        }));
    }

    private class FlushCallback
    extends IteratingCallback {
        private Entry active;

        private FlushCallback() {
        }

        protected IteratingCallback.Action process() throws Exception {
            Entry entry = Flusher.this.poll();
            if (entry == null) {
                return IteratingCallback.Action.IDLE;
            }
            this.active = entry;
            List buffers = entry.accumulator.getByteBuffers();
            Flusher.this.endPoint.write((Callback)this, (ByteBuffer[])buffers.toArray(ByteBuffer[]::new));
            return IteratingCallback.Action.SCHEDULED;
        }

        protected void onCompleteSuccess() {
            throw new IllegalStateException();
        }

        protected void onSuccess() {
            if (this.active != null) {
                this.active.succeeded();
            }
            this.active = null;
        }

        public void onCompleteFailure(Throwable x) {
            Entry entry;
            if (this.active != null) {
                this.active.failed(x);
            }
            this.active = null;
            while ((entry = Flusher.this.poll()) != null) {
                entry.failed(x);
            }
        }
    }

    private record Entry(ByteBufferPool.Accumulator accumulator, Callback callback) implements Callback
    {
        public void succeeded() {
            if (this.accumulator != null) {
                this.accumulator.release();
            }
            this.callback.succeeded();
        }

        public void failed(Throwable x) {
            if (this.accumulator != null) {
                this.accumulator.release();
            }
            this.callback.failed(x);
        }
    }
}

