/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.memcached.session;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.List;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import org.eclipse.jetty.session.SessionContext;
import org.eclipse.jetty.session.SessionData;
import org.eclipse.jetty.session.SessionDataMap;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

@ManagedObject
public class MemcachedSessionDataMap
extends AbstractLifeCycle
implements SessionDataMap {
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "11211";
    protected MemcachedClient _client;
    protected int _expirySec = 0;
    protected boolean _heartbeats = true;
    protected XMemcachedClientBuilder _builder;
    protected SessionContext _context;

    public MemcachedSessionDataMap(String host, String port) {
        if (host == null || port == null) {
            throw new IllegalArgumentException("Host: " + host + " port: " + port);
        }
        this._builder = new XMemcachedClientBuilder(host + ":" + port);
    }

    public MemcachedSessionDataMap(List<InetSocketAddress> addresses) {
        this._builder = new XMemcachedClientBuilder(addresses);
    }

    public MemcachedSessionDataMap(List<InetSocketAddress> addresses, int[] weights) {
        this._builder = new XMemcachedClientBuilder(addresses, weights);
    }

    public XMemcachedClientBuilder getBuilder() {
        return this._builder;
    }

    public void setExpirySec(int sec) {
        this._expirySec = sec;
    }

    @ManagedAttribute(value="memcached expiry time in sec", readonly=true)
    public int getExpirySec() {
        return this._expirySec;
    }

    @ManagedAttribute(value="enable memcached heartbeats", readonly=true)
    public boolean isHeartbeats() {
        return this._heartbeats;
    }

    public void setHeartbeats(boolean heartbeats) {
        this._heartbeats = heartbeats;
    }

    public void initialize(SessionContext context) {
        if (this.isStarted()) {
            throw new IllegalStateException("Context set after MemcachedSessionDataMap started");
        }
        try {
            this._context = context;
            this._builder.setTranscoder((Transcoder)new SessionDataTranscoder());
            this._client = this._builder.build();
            this._client.setEnableHeartBeat(this.isHeartbeats());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public SessionData load(String id) throws Exception {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started");
        }
        FuturePromise result = new FuturePromise();
        Runnable r = () -> {
            try {
                result.succeeded((Object)((SessionData)this._client.get(id)));
            }
            catch (Exception e) {
                result.failed((Throwable)e);
            }
        };
        this._context.run(r);
        return (SessionData)result.getOrThrow();
    }

    public void store(String id, SessionData data) throws Exception {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started");
        }
        FuturePromise result = new FuturePromise();
        Runnable r = () -> {
            try {
                this._client.set(id, this._expirySec, (Object)data);
                result.succeeded(null);
            }
            catch (Exception e) {
                result.failed((Throwable)e);
            }
        };
        this._context.run(r);
        result.getOrThrow();
    }

    public boolean delete(String id) throws Exception {
        this._client.delete(id);
        return true;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._client != null) {
            this._client.shutdown();
            this._client = null;
        }
    }

    public static class SessionDataTranscoder
    extends SerializingTranscoder {
        protected Object deserialize(byte[] in) {
            Object rv = null;
            if (in != null) {
                try (ByteArrayInputStream bis = new ByteArrayInputStream(in);
                     ClassLoadingObjectInputStream is = new ClassLoadingObjectInputStream((InputStream)bis);){
                    rv = is.readObject();
                }
                catch (IOException e) {
                    log.error("Caught IOException decoding " + in.length + " bytes of data", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error("Caught CNFE decoding " + in.length + " bytes of data", (Throwable)e);
                }
            }
            return rv;
        }
    }
}

