/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Fields
implements Iterable<Field> {
    public static final Fields EMPTY = new Fields(Collections.emptyMap());
    private final Map<String, Field> fields;

    public Fields() {
        this(false);
    }

    public Fields(boolean caseSensitive) {
        this(caseSensitive ? new LinkedHashMap() : new TreeMap(String::compareToIgnoreCase));
    }

    public Fields(Map<String, Field> fields) {
        this.fields = fields;
    }

    public Fields asImmutable() {
        return new Fields(Collections.unmodifiableMap(this.fields));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Fields) {
            Fields that = (Fields)obj;
            if (this.getSize() != that.getSize()) {
                return false;
            }
            if (!this.fields.getClass().equals(that.fields.getClass())) {
                return false;
            }
            for (Map.Entry<String, Field> entry : this.fields.entrySet()) {
                String name = entry.getKey();
                Field value = entry.getValue();
                if (value.equals(that.get(name))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public Set<String> getNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Field field : this.fields.values()) {
            result.add(field.getName());
        }
        return result;
    }

    public Stream<Field> stream() {
        return this.fields.values().stream();
    }

    public Field get(String name) {
        return this.fields.get(name);
    }

    public String getValue(String name) {
        Field field = this.get(name);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public List<String> getValues(String name) {
        Field field = this.get(name);
        if (field == null) {
            return null;
        }
        return field.getValues();
    }

    public List<String> getValuesOrEmpty(String name) {
        Field field = this.get(name);
        if (field == null) {
            return Collections.emptyList();
        }
        return field.getValues();
    }

    public void put(String name, String value) {
        Field field = new Field(name, value);
        this.fields.put(name, field);
    }

    public void put(Field field) {
        if (field != null) {
            String s = field.getName();
            this.fields.put(s, field);
        }
    }

    public void add(String name, String value) {
        String key = name;
        this.fields.compute(key, (k, f) -> {
            if (f == null) {
                return new Field(name, value);
            }
            return new Field(f.getName(), f.getValues(), value);
        });
    }

    public void add(Field field) {
        String s;
        String key = s = field.getName();
        this.fields.compute(key, (k, f) -> {
            if (f == null) {
                return field;
            }
            return new Field(f.getName(), f.getValues(), field.getValues());
        });
    }

    public void addAll(Fields fields) {
        for (Field field : fields) {
            this.add(field);
        }
    }

    public Field remove(String name) {
        return this.fields.remove(name);
    }

    public void clear() {
        this.fields.clear();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int getSize() {
        return this.fields.size();
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.values().iterator();
    }

    public Map<String, String[]> toStringArrayMap() {
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        this.fields.forEach((? super K k, ? super V f) -> result.put(f.getName(), f.getValues().toArray(new String[0])));
        return result;
    }

    public String toString() {
        return this.fields.values().stream().map(Field::toString).collect(Collectors.joining(",", "[", "]"));
    }

    public static Fields combine(Fields a, Fields b) {
        if (b == null || b.isEmpty()) {
            return a == null ? EMPTY : a;
        }
        if (a == null || a.isEmpty()) {
            return b;
        }
        Fields fields = new Fields();
        fields.addAll(a);
        fields.addAll(b);
        return fields;
    }

    public static class Field {
        private final String name;
        private final List<String> values;

        public Field(String name, String value) {
            this(name, List.of(value), new String[0]);
        }

        private Field(String name, List<String> values, String ... moreValues) {
            this(name, values, List.of(moreValues));
        }

        private Field(String name, List<String> values, List<String> moreValues) {
            this.name = name;
            ArrayList<String> list = new ArrayList<String>(values.size() + moreValues.size());
            list.addAll(values);
            list.addAll(moreValues);
            this.values = List.copyOf(list);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Field that = (Field)obj;
            return this.name.equals(that.name) && this.values.equals(that.values);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.values);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.values.get(0);
        }

        public Integer getValueAsInt() {
            String value = this.getValue();
            return value == null ? null : Integer.valueOf(Integer.parseInt(value));
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean hasMultipleValues() {
            return this.values.size() > 1;
        }

        public String toString() {
            return String.format("%s=%s", this.name, this.values);
        }
    }
}

