/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.common.QuicConnection;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.server.QuicServerConnector;
import org.eclipse.jetty.quic.server.ServerQuicSession;
import org.eclipse.jetty.quic.server.internal.SimpleTokenMinter;
import org.eclipse.jetty.quic.server.internal.SimpleTokenValidator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerQuicConnection
extends QuicConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ServerQuicConnection.class);
    private final QuicServerConnector connector;
    private final SessionTimeouts sessionTimeouts;

    public ServerQuicConnection(QuicServerConnector connector, EndPoint endPoint) {
        super(connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), endPoint);
        this.connector = connector;
        this.sessionTimeouts = new SessionTimeouts(connector.getScheduler());
    }

    public QuicServerConnector getQuicServerConnector() {
        return this.connector;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    protected QuicSession createSession(SocketAddress remoteAddress, ByteBuffer cipherBuffer) throws IOException {
        ByteBufferPool bufferPool = this.getByteBufferPool();
        QuicheConnection quicheConnection = QuicheConnection.tryAccept((QuicheConfig)this.connector.newQuicheConfig(), (QuicheConnection.TokenValidator)new SimpleTokenValidator((InetSocketAddress)remoteAddress), (ByteBuffer)cipherBuffer, (SocketAddress)this.getEndPoint().getLocalAddress(), (SocketAddress)remoteAddress);
        if (quicheConnection == null) {
            RetainableByteBuffer negotiationBuffer = bufferPool.acquire(this.getOutputBufferSize(), true);
            ByteBuffer byteBuffer = negotiationBuffer.getByteBuffer();
            int pos = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
            if (!QuicheConnection.negotiate((QuicheConnection.TokenMinter)new SimpleTokenMinter((InetSocketAddress)remoteAddress), (ByteBuffer)cipherBuffer, (ByteBuffer)byteBuffer)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("QUIC connection negotiation failed, dropping packet");
                }
                negotiationBuffer.release();
                return null;
            }
            BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)pos);
            this.write(Callback.from(() -> ((RetainableByteBuffer)negotiationBuffer).release()), remoteAddress, new ByteBuffer[]{byteBuffer});
            if (LOG.isDebugEnabled()) {
                LOG.debug("QUIC connection negotiation packet sent");
            }
            return null;
        }
        ServerQuicSession session = this.newQuicSession(remoteAddress, quicheConnection);
        session.flush();
        return session;
    }

    protected ServerQuicSession newQuicSession(SocketAddress remoteAddress, QuicheConnection quicheConnection) {
        return new ServerQuicSession(this.getExecutor(), this.getScheduler(), this.getByteBufferPool(), quicheConnection, this, remoteAddress, (Connector)this.getQuicServerConnector());
    }

    public void schedule(ServerQuicSession session) {
        this.sessionTimeouts.schedule(session);
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        return false;
    }

    public void outwardClose(QuicSession session, Throwable failure) {
        super.outwardClose(session, failure);
    }

    private class SessionTimeouts
    extends CyclicTimeouts<ServerQuicSession> {
        private SessionTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        protected Iterator<ServerQuicSession> iterator() {
            return ServerQuicConnection.this.getQuicSessions().stream().map(ServerQuicSession.class::cast).iterator();
        }

        protected boolean onExpired(ServerQuicSession session) {
            session.onIdleTimeout();
            return false;
        }
    }
}

