/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.transport;

import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpConnectionOverFCGI;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="The FastCGI/1.0 client transport")
public class HttpClientTransportOverFCGI
extends AbstractConnectorHttpClientTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransportOverFCGI.class);
    private final String scriptRoot;

    public HttpClientTransportOverFCGI(String scriptRoot) {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2), scriptRoot);
    }

    public HttpClientTransportOverFCGI(int selectors, String scriptRoot) {
        this(new ClientConnector(), scriptRoot);
        this.getClientConnector().setSelectors(selectors);
    }

    public HttpClientTransportOverFCGI(ClientConnector connector, String scriptRoot) {
        super(connector);
        this.scriptRoot = scriptRoot;
        this.setConnectionPoolFactory(destination -> {
            HttpClient httpClient = this.getHttpClient();
            int maxConnections = httpClient.getMaxConnectionsPerDestination();
            return new DuplexConnectionPool(destination, maxConnections);
        });
    }

    @ManagedAttribute(value="The scripts root directory", readonly=true)
    public String getScriptRoot() {
        return this.scriptRoot;
    }

    public Origin newOrigin(Request request) {
        return this.getHttpClient().createOrigin(request, new Origin.Protocol(List.of("fastcgi/1.1"), false));
    }

    public Destination newDestination(Origin origin) {
        SocketAddress address = origin.getAddress().getSocketAddress();
        return new HttpDestination(this.getHttpClient(), origin, this.getClientConnector().isIntrinsicallySecure(address));
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        Promise promise = (Promise)context.get("org.eclipse.jetty.client.connection.promise");
        Connection connection = this.newConnection(endPoint, (Destination)destination, (Promise<org.eclipse.jetty.client.Connection>)promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", (Object)connection);
        }
        return this.customize(connection, context);
    }

    protected Connection newConnection(EndPoint endPoint, Destination destination, Promise<org.eclipse.jetty.client.Connection> promise) {
        return new HttpConnectionOverFCGI(endPoint, destination, promise);
    }

    public void customize(Request request, HttpFields.Mutable fastCGIHeaders) {
        fastCGIHeaders.put("DOCUMENT_ROOT", this.getScriptRoot());
    }
}

