/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class Generator {
    public static final int MAX_CONTENT_LENGTH = 65535;
    private final ByteBufferPool bufferPool;
    private final boolean useDirectByteBuffers;

    public Generator(ByteBufferPool bufferPool, boolean useDirectByteBuffers) {
        this.bufferPool = bufferPool;
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public boolean isUseDirectByteBuffers() {
        return this.useDirectByteBuffers;
    }

    protected void generateContent(ByteBufferPool.Accumulator accumulator, int id, ByteBuffer content, boolean lastContent, FCGI.FrameType frameType) {
        int contentLength;
        id &= 0xFFFF;
        int n = contentLength = content == null ? 0 : content.remaining();
        while (contentLength > 0 || lastContent) {
            RetainableByteBuffer buffer = this.getByteBufferPool().acquire(8, this.isUseDirectByteBuffers());
            accumulator.append(buffer);
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            byteBuffer.put((byte)1);
            byteBuffer.put((byte)frameType.code);
            byteBuffer.putShort((short)id);
            int length = Math.min(65535, contentLength);
            byteBuffer.putShort((short)length);
            byteBuffer.putShort((short)0);
            BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
            if (contentLength == 0) break;
            int limit = content.limit();
            content.limit(content.position() + length);
            ByteBuffer slice = content.slice();
            accumulator.append(RetainableByteBuffer.wrap((ByteBuffer)slice));
            content.position(content.limit());
            content.limit(limit);
            contentLength -= length;
        }
    }
}

