/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLParameters;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.RawArgs;
import org.eclipse.jetty.start.StartEnvironment;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.TextFile;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.Utils;
import org.eclipse.jetty.start.config.ConfigSource;
import org.eclipse.jetty.start.config.ConfigSources;
import org.eclipse.jetty.start.config.DirConfigSource;
import org.eclipse.jetty.start.shaded.util.JavaVersion;
import org.eclipse.jetty.start.shaded.util.ManifestUtils;

public class StartArgs {
    public static final String VERSION;
    public static final Set<String> ALL_PARTS;
    public static final Set<String> ARG_PARTS;
    public static final String ARG_ALLOW_INSECURE_HTTP_DOWNLOADS = "--allow-insecure-http-downloads";
    private static final String JETTY_VERSION_KEY = "jetty.version";
    private static final String JETTY_TAG_NAME_KEY = "jetty.tag.version";
    private static final String JETTY_BUILDNUM_KEY = "jetty.build";
    private static final String MAIN_CLASS = "org.eclipse.jetty.xml.XmlConfiguration";
    private static final String MODULE_MAIN_CLASS = "org.eclipse.jetty.xml/org.eclipse.jetty.xml.XmlConfiguration";
    private final BaseHome baseHome;
    private final Set<String> modules = new HashSet<String>();
    private final Set<String> skipFileValidationModules = new HashSet<String>();
    Map<String, Set<String>> sources = new HashMap<String, Set<String>>();
    private final List<FileArg> files = new ArrayList<FileArg>();
    private final Map<String, String> jvmArgSources = new LinkedHashMap<String, String>();
    private final Map<String, String> systemPropertySource = new HashMap<String, String>();
    private static final Map<String, StartEnvironment> environments;
    private final List<String> startModules = new ArrayList<String>();
    private final Set<String> _jmodAdds = new LinkedHashSet<String>();
    private final Map<String, Set<String>> _jmodPatch = new LinkedHashMap<String, Set<String>>();
    private final Map<String, Set<String>> _jmodOpens = new LinkedHashMap<String, Set<String>>();
    private final Map<String, Set<String>> _jmodExports = new LinkedHashMap<String, Set<String>>();
    private final Map<String, Set<String>> _jmodReads = new LinkedHashMap<String, Set<String>>();
    private String moduleGraphFilename;
    private Modules allModules;
    private boolean run = true;
    private boolean createFiles = false;
    private boolean licenseCheckRequired = false;
    private boolean testingMode = false;
    private boolean help = false;
    private boolean stopCommand = false;
    private List<String> listModules = null;
    private List<String> showModules = null;
    private boolean listClasspath = false;
    private boolean listConfig = false;
    private boolean version = false;
    private boolean dryRun = false;
    private boolean multiLine = false;
    private final Set<String> dryRunParts = new HashSet<String>();
    private boolean jpms = false;
    private boolean createStartD = false;
    private boolean createStartIni = false;
    private boolean updateIni = false;
    private String mavenBaseUri;
    private boolean exec = false;
    private String execProperties;
    private boolean allowInsecureHttpDownloads = false;
    private boolean approveAllLicenses = false;
    private final StartEnvironment jettyEnvironment;

    public StartArgs(BaseHome baseHome) {
        this.baseHome = baseHome;
        this.jettyEnvironment = new StartEnvironment("Jetty", baseHome);
    }

    public void expandEnvironments(List<Module> activeModules) throws IOException {
        this.expandSystemProperties();
        this.jettyEnvironment.resolveLibs();
        this.expandModules(activeModules);
        this.jettyEnvironment.resolve();
        this.resolveJPMS(activeModules);
        for (StartEnvironment environment : environments.values()) {
            environment.resolveLibs();
            environment.resolve();
        }
    }

    public StartEnvironment getJettyEnvironment() {
        return this.jettyEnvironment;
    }

    public Collection<StartEnvironment> getEnvironments() {
        return environments.values();
    }

    public StartEnvironment getEnvironment(String envName) {
        return environments.computeIfAbsent(envName, k -> new StartEnvironment((String)k, this.baseHome));
    }

    private void addFile(Module module, String uriLocation) {
        if (module != null && module.isSkipFilesValidation()) {
            StartLog.debug("Not validating module %s [files] for %s", module, uriLocation);
            return;
        }
        StartEnvironment environment = this.getEnvironment(module);
        FileArg arg = new FileArg(module, environment.getProperties().expand(uriLocation));
        if (!this.files.contains(arg)) {
            this.files.add(arg);
        }
    }

    private StartEnvironment getEnvironment(Module module) {
        String envName = module == null ? null : module.getEnvironment();
        StartEnvironment environment = envName == null ? this.getJettyEnvironment() : this.getEnvironment(envName);
        return environment;
    }

    public void dumpJavaEnvironment(PrintStream out) {
        out.println();
        out.println("JVM Version & Properties:");
        out.println("-------------------------");
        this.dumpSystemProperty(out, "java.home");
        this.dumpSystemProperty(out, "java.vm.vendor");
        this.dumpSystemProperty(out, "java.vm.version");
        this.dumpSystemProperty(out, "java.vm.name");
        this.dumpSystemProperty(out, "java.vm.info");
        this.dumpSystemProperty(out, "java.runtime.name");
        this.dumpSystemProperty(out, "java.runtime.version");
        this.dumpSystemProperty(out, "java.io.tmpdir");
        this.dumpSystemProperty(out, "user.dir");
        this.dumpSystemProperty(out, "user.language");
        this.dumpSystemProperty(out, "user.country");
        out.println();
        out.println("Jetty Version & Properties:");
        out.println("---------------------------");
        StartEnvironment jettyEnvironment = this.getJettyEnvironment();
        jettyEnvironment.dumpProperty(out, JETTY_VERSION_KEY);
        jettyEnvironment.dumpProperty(out, JETTY_TAG_NAME_KEY);
        jettyEnvironment.dumpProperty(out, JETTY_BUILDNUM_KEY);
        jettyEnvironment.dumpProperty(out, "jetty.home");
        jettyEnvironment.dumpProperty(out, "jetty.base");
        out.println();
        out.println("Config Search Order:");
        out.println("--------------------");
        for (ConfigSource config : this.baseHome.getConfigSources()) {
            DirConfigSource dirsource;
            out.printf(" %s", config.getId());
            if (config instanceof DirConfigSource && (dirsource = (DirConfigSource)config).isPropertyBased()) {
                out.printf(" -> %s", dirsource.getDir());
            }
            out.println();
        }
    }

    public void dumpJvmArgs(PrintStream out) {
        if (this.jvmArgSources.isEmpty()) {
            return;
        }
        out.println();
        out.println("Forked JVM Arguments:");
        out.println("---------------------");
        this.jvmArgSources.forEach((key, sourceRef) -> {
            Object source;
            String value = System.getProperty(key);
            Object object = source = StartLog.isDebugEnabled() ? "(" + sourceRef + ")" : "";
            if (value != null) {
                out.printf(" %s = %s %s%n", key, value, source);
            } else {
                out.printf(" %s %s%n", key, source);
            }
        });
    }

    public void dumpSystemProperties(PrintStream out) {
        out.println();
        out.println("System Properties:");
        out.println("------------------");
        if (this.systemPropertySource.keySet().isEmpty()) {
            out.println(" (no system properties specified)");
            return;
        }
        ArrayList<String> sortedKeys = new ArrayList<String>(this.systemPropertySource.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            this.dumpSystemProperty(out, key);
        }
    }

    private void dumpSystemProperty(PrintStream out, String key) {
        String value = System.getProperty(key);
        String source = "";
        if (this.systemPropertySource.get(key) != null) {
            source = String.format(" (%s)", this.systemPropertySource.get(key));
        }
        out.printf(" %s = %s%s%n", key, value, source);
    }

    private void ensureSystemPropertySet(String key) {
        if (this.systemPropertySource.containsKey(key)) {
            return;
        }
        StartEnvironment jettyEnvironment = this.getJettyEnvironment();
        if (jettyEnvironment.getProperties().containsKey(key)) {
            Props.Prop prop = jettyEnvironment.getProperties().getProp(key);
            if (prop == null) {
                return;
            }
            String val = jettyEnvironment.getProperties().expand(prop.value);
            this.systemPropertySource.put(key, "property:" + prop.source);
            System.setProperty(key, val);
        }
    }

    public void expandSystemProperties() {
        StartLog.debug("Expanding System Properties", new Object[0]);
        for (String key : this.systemPropertySource.keySet()) {
            String expanded;
            String value = this.getJettyEnvironment().getProperties().getString(key);
            if (value == null || value.equals(expanded = this.getJettyEnvironment().getProperties().expand(value))) continue;
            System.setProperty(key, expanded);
        }
    }

    public void expandModules(List<Module> activeModules) throws IOException {
        StartLog.debug("Expanding Modules", new Object[0]);
        for (Module module : activeModules) {
            StartEnvironment environment = this.getEnvironment(module);
            for (String rawlibref : module.getLibs()) {
                StartLog.debug("rawlibref = %s", rawlibref);
                String libref = environment.getProperties().expand(rawlibref);
                StartLog.debug("expanded = %s", libref);
                for (Path libpath : this.baseHome.getPaths(libref)) {
                    environment.getClasspath().addComponent(libpath);
                }
            }
            for (String jvmArg : module.getJvmArgs()) {
                this.exec = true;
                this.jvmArgSources.put(jvmArg, String.format("module[%s|jvm]", module.getName()));
            }
            for (String xmlRef : module.getXmls()) {
                xmlRef = environment.getProperties().expand(xmlRef);
                Path xmlfile = this.baseHome.getPath(xmlRef);
                environment.addUniqueXmlFile(xmlRef, xmlfile);
            }
            for (String file : module.getFiles()) {
                StartLog.debug("Adding module specified file: %s", file);
                this.addFile(module, file);
            }
        }
    }

    public List<String> getStartModules() {
        return this.startModules;
    }

    public Modules getAllModules() {
        return this.allModules;
    }

    public Set<String> getSelectedModules() {
        return this.modules;
    }

    public List<FileArg> getFiles() {
        return this.files;
    }

    public Map<String, String> getJvmArgSources() {
        return this.jvmArgSources;
    }

    public CommandLineBuilder getMainArgs(Set<String> parts) throws IOException {
        Props properties;
        if (parts.isEmpty()) {
            parts = ALL_PARTS;
        }
        CommandLineBuilder cmd = new CommandLineBuilder(this.multiLine);
        this.ensureSystemPropertySet("STOP.PORT");
        this.ensureSystemPropertySet("STOP.KEY");
        this.ensureSystemPropertySet("STOP.WAIT");
        if (parts.contains("java")) {
            cmd.addArg(CommandLineBuilder.findJavaBin());
        }
        if (parts.contains("opts")) {
            cmd.addOption("-D", "java.io.tmpdir", System.getProperty("java.io.tmpdir"));
            cmd.addOption("-D", "jetty.home", this.baseHome.getHome());
            cmd.addOption("-D", "jetty.base", this.baseHome.getBase());
            properties = this.jettyEnvironment.getProperties();
            for (String x : this.getJvmArgSources().keySet()) {
                if (x.startsWith("-D")) {
                    String[] assign = x.substring(2).split("=", 2);
                    String key = assign[0];
                    String value = assign.length == 1 ? "" : assign[1];
                    Props.Prop p = this.processSystemProperty(key, value, null);
                    cmd.addOption("-D", p.key, properties.expand(p.value));
                    continue;
                }
                cmd.addArg(properties.expand(x));
            }
            for (String propKey : this.systemPropertySource.keySet()) {
                String value = System.getProperty(propKey);
                cmd.addOption("-D", propKey, value);
            }
        }
        if (parts.contains("path")) {
            Classpath classpath = this.jettyEnvironment.getClasspath();
            StartLog.debug("classpath=%s - isJPMS=%b", classpath, this.isJPMS());
            if (this.isJPMS()) {
                List dirs;
                Map<Boolean, List<Path>> dirsAndFiles = StreamSupport.stream(classpath.spliterator(), false).collect(Collectors.groupingBy(x$0 -> Files.isDirectory(x$0, new LinkOption[0])));
                List paths = (List)dirsAndFiles.get(false);
                HashSet files = new HashSet(paths == null ? Collections.emptyList() : paths);
                this.getEnvironments().stream().filter(environment -> !environment.getName().equals(this.jettyEnvironment.getName())).forEach(environment -> {
                    Map<Boolean, List<Path>> dirsAndFilesModules = StreamSupport.stream(environment.getClasspath().spliterator(), false).collect(Collectors.groupingBy(x$0 -> Files.isDirectory(x$0, new LinkOption[0])));
                    dirsAndFiles.putAll(dirsAndFilesModules);
                    if (dirsAndFilesModules.containsKey(false)) {
                        files.addAll(dirsAndFilesModules.get(false));
                    } else {
                        System.out.println("null dirsAndFilesModules");
                    }
                });
                if (!files.isEmpty()) {
                    cmd.addOption("--module-path");
                    String modules = files.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(FS.pathSeparator()));
                    cmd.addArg(modules);
                }
                if ((dirs = (List)dirsAndFiles.get(true)) != null && !dirs.isEmpty()) {
                    cmd.addOption("--class-path");
                    String directories = dirs.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(FS.pathSeparator()));
                    cmd.addArg(directories);
                }
                this.generateJpmsArgs(cmd);
                StartLog.debug("JPMS resulting cmd=%s", cmd.toCommandLine());
            } else if (!classpath.isEmpty()) {
                cmd.addOption("--class-path");
                cmd.addArg(classpath.toString());
            }
        }
        if (parts.contains("main")) {
            if (this.isJPMS()) {
                cmd.addOption("--module");
            }
            cmd.addArg(this.getMainClassname());
        }
        if (parts.contains("args")) {
            properties = this.jettyEnvironment.getProperties();
            if (this.dryRun && this.execProperties == null) {
                for (Props.Prop p : properties) {
                    if (p.key.startsWith("java.version.")) continue;
                    cmd.addArg(p.key, properties.expand(p.value));
                }
            } else if (properties.size() > 0) {
                Iterator<Path> propPath;
                if (this.execProperties == null) {
                    propPath = Files.createTempFile("start_", ".properties", new FileAttribute[0]);
                    propPath.toFile().deleteOnExit();
                } else {
                    propPath = Paths.get(this.execProperties, new String[0]);
                }
                try (OutputStream out = Files.newOutputStream((Path)((Object)propPath), new OpenOption[0]);){
                    properties.store(out, "start.jar properties");
                }
                cmd.addArg(propPath.toAbsolutePath().toString());
            }
            for (Path xml : this.jettyEnvironment.getXmlFiles()) {
                cmd.addArg(xml.toAbsolutePath().toString());
            }
            for (Path propertyFile : this.jettyEnvironment.getPropertyFiles()) {
                cmd.addArg(propertyFile.toAbsolutePath().toString());
            }
        }
        if (parts.contains("envs")) {
            for (StartEnvironment environment2 : this.getEnvironments()) {
                if (environment2 == this.jettyEnvironment) continue;
                cmd.addArg("--env");
                cmd.addArg(environment2.getName());
                environment2.getClasspath().getElements().stream().map(Path::toAbsolutePath).map(Path::toString).forEach(s -> {
                    cmd.addArg("-cp");
                    cmd.addArg((String)s);
                });
                for (Props.Prop property : environment2.getProperties()) {
                    cmd.addArg(property.key, property.value);
                }
                for (Path xmlFile : environment2.getXmlFiles()) {
                    cmd.addArg(xmlFile.toAbsolutePath().toString());
                }
            }
        }
        return cmd;
    }

    private void resolveJPMS(List<Module> activeModules) throws IOException {
        for (Module module : activeModules) {
            for (String line : module.getJPMS()) {
                line = this.getJettyEnvironment().getProperties().expand(line);
                String directive = "add-modules:";
                if (line.startsWith("add-modules:")) {
                    String[] names = line.substring(directive.length()).split(",");
                    Arrays.stream(names).map(String::trim).collect(Collectors.toCollection(() -> this._jmodAdds));
                    continue;
                }
                directive = "patch-module:";
                if (line.startsWith("patch-module:")) {
                    this.parseJPMSKeyValue(module, line, directive, true, this._jmodPatch);
                    continue;
                }
                directive = "add-opens:";
                if (line.startsWith("add-opens:")) {
                    this.parseJPMSKeyValue(module, line, directive, false, this._jmodOpens);
                    continue;
                }
                directive = "add-exports:";
                if (line.startsWith("add-exports:")) {
                    this.parseJPMSKeyValue(module, line, directive, false, this._jmodExports);
                    continue;
                }
                directive = "add-reads:";
                if (line.startsWith("add-reads:")) {
                    this.parseJPMSKeyValue(module, line, directive, false, this._jmodReads);
                    continue;
                }
                throw new IllegalArgumentException("Invalid [jpms] directive " + directive + " in module " + module.getName() + ": " + line);
            }
        }
        this._jmodAdds.add("ALL-MODULE-PATH");
        StartLog.debug("Expanded JPMS directives:%n  add-modules: %s%n  patch-modules: %s%n  add-opens: %s%n  add-exports: %s%n  add-reads: %s", this._jmodAdds, this._jmodPatch, this._jmodOpens, this._jmodExports, this._jmodReads);
    }

    private void parseJPMSKeyValue(Module module, String line, String directive, boolean valueIsFile, Map<String, Set<String>> output) throws IOException {
        String valueString = line.substring(directive.length());
        int equals = valueString.indexOf(61);
        if (equals <= 0) {
            throw new IllegalArgumentException("Invalid [jpms] directive " + directive + " in module " + module.getName() + ": " + line);
        }
        String delimiter = valueIsFile ? FS.pathSeparator() : ",";
        String key = valueString.substring(0, equals).trim();
        String[] values = valueString.substring(equals + 1).split(delimiter);
        Set result = output.computeIfAbsent(key, k -> new LinkedHashSet());
        for (String value : values) {
            value = value.trim();
            if (valueIsFile) {
                List<Path> paths = this.baseHome.getPaths(value);
                paths.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toCollection(() -> result));
                continue;
            }
            result.add(value);
        }
    }

    private void generateJpmsArgs(CommandLineBuilder cmd) {
        if (!this._jmodAdds.isEmpty()) {
            cmd.addOption("--add-modules");
            cmd.addArg(String.join((CharSequence)",", this._jmodAdds));
        }
        for (Map.Entry<String, Set<String>> entry : this._jmodPatch.entrySet()) {
            cmd.addOption("--patch-module");
            cmd.addArg(entry.getKey(), String.join((CharSequence)File.pathSeparator, (Iterable<? extends CharSequence>)entry.getValue()));
        }
        for (Map.Entry<String, Set<String>> entry : this._jmodOpens.entrySet()) {
            cmd.addOption("--add-opens");
            cmd.addArg(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        for (Map.Entry<String, Set<String>> entry : this._jmodExports.entrySet()) {
            cmd.addOption("--add-exports");
            cmd.addArg(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        for (Map.Entry<String, Set<String>> entry : this._jmodReads.entrySet()) {
            cmd.addOption("--add-reads");
            cmd.addArg(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
    }

    public String getMainClassname() {
        String mainClass = System.getProperty("jetty.server", this.isJPMS() ? MODULE_MAIN_CLASS : MAIN_CLASS);
        Props.Prop mainClassProp = this.getJettyEnvironment().getProperties().getProp("main.class", true);
        if (mainClassProp != null) {
            return mainClassProp.value;
        }
        return mainClass;
    }

    public String getMavenLocalRepoDir() {
        String localRepo = this.getJettyEnvironment().getProperties().getString("maven.local.repo");
        if (Utils.isBlank(localRepo)) {
            localRepo = System.getenv("JETTY_MAVEN_LOCAL_REPO");
        }
        if (Utils.isBlank(localRepo)) {
            localRepo = System.getenv("MAVEN_LOCAL_REPO");
        }
        return localRepo;
    }

    public Path findMavenLocalRepoDir() {
        Path home;
        Path localMavenRepository;
        String localRepo = this.getMavenLocalRepoDir();
        if (Utils.isBlank(localRepo) && Files.exists(localMavenRepository = (home = Paths.get(System.getProperty("user.home"), new String[0])).resolve(".m2/repository"), new LinkOption[0])) {
            localRepo = localMavenRepository.toString();
        }
        if (Utils.isBlank(localRepo)) {
            return null;
        }
        Path localRepoDir = Paths.get(localRepo, new String[0]);
        if (Files.exists(localRepoDir = localRepoDir.normalize().toAbsolutePath(), new LinkOption[0]) && Files.isDirectory(localRepoDir, new LinkOption[0])) {
            return localRepoDir;
        }
        StartLog.warn("Not a valid maven local repository directory: %s", localRepoDir);
        return null;
    }

    public String getModuleGraphFilename() {
        return this.moduleGraphFilename;
    }

    public Set<String> getSkipFileValidationModules() {
        return this.skipFileValidationModules;
    }

    public Set<String> getSources(String module) {
        return this.sources.get(module);
    }

    public boolean hasJvmArgs() {
        return !this.jvmArgSources.isEmpty();
    }

    public boolean hasSystemProperties() {
        for (String key : this.systemPropertySource.keySet()) {
            if ("jetty.home".equals(key) || "jetty.base".equals(key) || "main.class".equals(key)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemPropertySource;
    }

    public boolean isAllowInsecureHttpDownloads() {
        return this.allowInsecureHttpDownloads;
    }

    public boolean isApproveAllLicenses() {
        return this.approveAllLicenses;
    }

    public boolean isCreateFiles() {
        return this.createFiles;
    }

    public boolean isJPMS() {
        return this.jpms;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public Set<String> getDryRunParts() {
        return this.dryRunParts;
    }

    public boolean isExec() {
        return this.exec;
    }

    public boolean isLicenseCheckRequired() {
        return this.licenseCheckRequired;
    }

    public boolean isNormalMainClass() {
        return MAIN_CLASS.equals(this.getMainClassname());
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isListClasspath() {
        return this.listClasspath;
    }

    public boolean isListConfig() {
        return this.listConfig;
    }

    public List<String> getListModules() {
        return this.listModules;
    }

    public List<String> getShowModules() {
        return this.showModules;
    }

    public boolean isRun() {
        return this.run;
    }

    public boolean isStopCommand() {
        return this.stopCommand;
    }

    public boolean isTestingModeEnabled() {
        return this.testingMode;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean isCreateStartD() {
        return this.createStartD;
    }

    public boolean isCreateStartIni() {
        return this.createStartIni;
    }

    public boolean isUpdateIni() {
        return this.updateIni;
    }

    public String getMavenBaseUri() {
        return this.mavenBaseUri;
    }

    public void parse(ConfigSources sources) {
        ListIterator<ConfigSource> iter = sources.reverseListIterator();
        while (iter.hasPrevious()) {
            StartEnvironment environment = this.getJettyEnvironment();
            ConfigSource source = iter.previous();
            for (RawArgs.Entry arg : source.getArgs()) {
                environment = this.parse(environment, arg.getLine(), arg.getOrigin());
            }
        }
    }

    public StartEnvironment parse(StartEnvironment environment, String arg, String source) {
        StartLog.debug("parse(\"%s\", \"%s\")", arg, source);
        if (arg == null) {
            return environment;
        }
        if ((arg = arg.trim()).length() == 0) {
            return environment;
        }
        if (arg.startsWith("#")) {
            return environment;
        }
        if ("--help".equals(arg) || "-?".equals(arg)) {
            this.help = true;
            this.run = false;
            return environment;
        }
        if ("--debug".equals(arg) || arg.startsWith("--start-log-file")) {
            return environment;
        }
        if ("--testing-mode".equals(arg)) {
            System.setProperty("org.eclipse.jetty.start.testing", "true");
            this.testingMode = true;
            return environment;
        }
        if (arg.startsWith("--commands=")) {
            Path commands = this.baseHome.getPath(Props.getValue(arg));
            if (!Files.exists(commands, new LinkOption[0]) || !Files.isReadable(commands)) {
                throw new UsageException(-5, "--commands file must be readable: %s", commands);
            }
            try {
                TextFile file = new TextFile(commands);
                StartLog.info("reading commands from %s", this.baseHome.toShortForm(commands));
                String s = source + "|" + this.baseHome.toShortForm(commands);
                StartEnvironment originalEnvironment = environment;
                for (String line : file) {
                    environment = this.parse(environment, line, s);
                }
                environment = originalEnvironment;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return environment;
        }
        if (arg.startsWith("--include-jetty-dir=") || arg.startsWith("--add-config-dir=")) {
            return environment;
        }
        if ("--stop".equals(arg)) {
            this.stopCommand = true;
            this.run = false;
            return environment;
        }
        if (arg.startsWith("--download=") || arg.startsWith("--files=")) {
            this.addFile(null, Props.getValue(arg));
            this.run = false;
            this.createFiles = true;
            return environment;
        }
        if (arg.equals("--create-files")) {
            this.run = false;
            this.createFiles = true;
            this.licenseCheckRequired = true;
            return environment;
        }
        if (arg.equals("--update-ini") || arg.equals("--update-inis")) {
            this.run = false;
            this.updateIni = true;
            return environment;
        }
        if ("--list-classpath".equals(arg) || "--version".equals(arg) || "-v".equals(arg) || "--info".equals(arg)) {
            this.listClasspath = true;
            this.run = false;
            return environment;
        }
        if ("--list-config".equals(arg)) {
            this.listConfig = true;
            this.run = false;
            return environment;
        }
        if ("--jpms".equals(arg)) {
            this.jpms = true;
            this.exec = true;
            return environment;
        }
        if ("--dry-run".equals(arg) || "--exec-print".equals(arg)) {
            this.dryRun = true;
            this.run = false;
            return environment;
        }
        if (arg.startsWith("--dry-run=")) {
            int colon = arg.indexOf(61);
            for (String part : arg.substring(colon + 1).split(",")) {
                if ("multiline".equalsIgnoreCase(part)) {
                    this.multiLine = true;
                    continue;
                }
                if (!ALL_PARTS.contains(part)) {
                    throw new UsageException(-5, "Unrecognized --dry-run=\"%s\" in %s", part, source);
                }
                this.dryRunParts.add(part);
            }
            this.dryRun = true;
            this.run = false;
            return environment;
        }
        if ("--exec".equals(arg)) {
            this.exec = true;
            return environment;
        }
        if (arg.startsWith("--exec-properties=")) {
            this.execProperties = Props.getValue(arg);
            if (!this.execProperties.endsWith(".properties")) {
                throw new UsageException(-5, "--exec-properties filename must have .properties suffix: %s", this.execProperties);
            }
            return environment;
        }
        if (ARG_ALLOW_INSECURE_HTTP_DOWNLOADS.equals(arg)) {
            this.allowInsecureHttpDownloads = true;
            return environment;
        }
        if ("--approve-all-licenses".equals(arg)) {
            this.approveAllLicenses = true;
            return environment;
        }
        if ("--list-all-modules".equals(arg)) {
            this.listModules = Collections.singletonList("*");
            this.run = false;
            return environment;
        }
        if ("--list-module".equals(arg) || "--list-modules".equals(arg)) {
            this.listModules = Collections.singletonList("-internal");
            this.run = false;
            return environment;
        }
        if (arg.startsWith("--list-module=") || arg.startsWith("--list-modules=")) {
            this.listModules = Props.getValues(arg);
            this.run = false;
            return environment;
        }
        if ("--show-module".equals(arg) || "--show-modules".equals(arg)) {
            this.showModules = Collections.emptyList();
            this.run = false;
            return environment;
        }
        if (arg.startsWith("--show-module=") || arg.startsWith("--show-modules=")) {
            this.showModules = Props.getValues(arg);
            this.run = false;
            return environment;
        }
        if ("--create-start-ini".equals(arg)) {
            this.createStartIni = true;
            this.run = false;
            this.createFiles = true;
            this.licenseCheckRequired = true;
            return environment;
        }
        if ("--create-startd".equals(arg) || "--create-start-d".equals(arg)) {
            this.createStartD = true;
            this.run = false;
            this.createFiles = true;
            this.licenseCheckRequired = true;
            return environment;
        }
        if (arg.startsWith("--add-module=") || arg.startsWith("--add-modules=") || arg.startsWith("--add-to-start=") || arg.startsWith("--add-to-startd=")) {
            if (arg.startsWith("--add-to-start=") || arg.startsWith("--add-to-startd=")) {
                String value = Props.getValue(arg);
                StartLog.warn("Option %s is deprecated! Instead use: --add-modules=%s", arg.split("=")[0], value);
            }
            this.startModules.addAll(Props.getValues(arg));
            this.run = false;
            this.createFiles = true;
            this.licenseCheckRequired = true;
            return environment;
        }
        if (arg.startsWith("--module=") || arg.startsWith("--modules=")) {
            List<String> moduleNames = Props.getValues(arg);
            this.selectModules(source, moduleNames);
            Module module = this.getAllModules().get(moduleNames.get(moduleNames.size() - 1));
            String envName = module == null ? null : module.getEnvironment();
            return envName == null ? this.jettyEnvironment : this.getEnvironment(envName);
        }
        if (arg.startsWith("--skip-file-validation=") || arg.startsWith("--skip-create-files=")) {
            List<String> moduleNames = Props.getValues(arg);
            this.skipFileValidationModules.addAll(moduleNames);
            return environment;
        }
        if (arg.startsWith("--write-module-graph=")) {
            this.moduleGraphFilename = Props.getValue(arg);
            this.run = false;
            return environment;
        }
        if (environment == null) {
            environment = this.getJettyEnvironment();
        }
        if (arg.startsWith("--lib=") || arg.startsWith("--libs=")) {
            String cp = Props.getValue(arg);
            StringTokenizer t = new StringTokenizer(cp, FS.pathSeparator());
            while (t.hasMoreTokens()) {
                environment.addLibRef(t.nextToken());
            }
            return environment;
        }
        if (arg.startsWith("-D")) {
            String[] assign = arg.substring(2).split("=", 2);
            String key = assign[0];
            String value = assign.length == 1 ? "" : assign[1];
            Props.Prop p = this.processSystemProperty(key, value, source);
            this.systemPropertySource.put(p.key, p.source);
            this.setProperty(environment, p.key, p.value, p.source);
            System.setProperty(p.key, p.value);
            return environment;
        }
        if (arg.startsWith("-")) {
            StartLog.debug("Unrecognized Arg (possible JVM Arg): %s (from %s)", arg, source);
            this.jvmArgSources.put(arg, source);
            return environment;
        }
        int equals = arg.indexOf(61);
        if (equals >= 0) {
            String key = arg.substring(0, equals);
            String value = arg.substring(equals + 1);
            this.processAndSetProperty(environment, key, value, source);
            return environment;
        }
        if (FS.isXml(arg)) {
            environment.addXmlRef(arg);
            return environment;
        }
        if (FS.isPropertyFile(arg)) {
            environment.addPropertyFileRef(arg);
            return environment;
        }
        throw new UsageException(-5, "Unrecognized argument: \"%s\" in %s", arg, source);
    }

    protected Props.Prop processSystemProperty(String key, String value, String source) {
        if (key.endsWith("+")) {
            String orig = System.getProperty(key = key.substring(0, key.length() - 1));
            if (orig == null || orig.isEmpty()) {
                if (((String)value).startsWith(",")) {
                    value = ((String)value).substring(1);
                }
            } else {
                value = orig + (String)value;
                if (source != null && this.systemPropertySource.containsKey(key)) {
                    source = this.systemPropertySource.get(key) + "," + (String)source;
                }
            }
        } else if (key.endsWith("?")) {
            String preset = System.getProperty(key = key.substring(0, key.length() - 1));
            if (preset != null) {
                value = preset;
                source = this.systemPropertySource.get(key);
            } else if (source != null) {
                source = (String)source + "?=";
            }
        }
        return new Props.Prop(key, (String)value, (String)source);
    }

    private void processAndSetProperty(StartEnvironment environment, String key, String value, String source) {
        if (key.endsWith("+")) {
            key = key.substring(0, key.length() - 1);
            Props.Prop orig = environment.getProperties().getProp(key);
            if (orig == null) {
                if (((String)value).startsWith(",")) {
                    value = ((String)value).substring(1);
                }
            } else {
                value = orig.value + (String)value;
                source = orig.source + "," + (String)source;
            }
        } else if (key.endsWith("?")) {
            key = key.substring(0, key.length() - 1);
            Props.Prop preset = environment.getProperties().getProp(key);
            if (preset != null) {
                return;
            }
            if (source != null) {
                source = (String)source + "?=";
            }
        }
        this.setProperty(environment, key, (String)value, (String)source);
    }

    private void selectModules(String source, List<String> moduleNames) {
        for (String moduleName : moduleNames) {
            this.modules.add(moduleName);
            Set set = this.sources.computeIfAbsent(moduleName, k -> new HashSet());
            set.add(source);
        }
    }

    public void setAllModules(Modules allModules) {
        this.allModules = allModules;
    }

    public void setProperty(StartEnvironment environment, String key, String value, String source) {
        if (environment == null) {
            environment = this.getJettyEnvironment();
        }
        Props properties = environment.getProperties();
        if (key.equals("jetty.home")) {
            properties.setProperty("jetty.home", System.getProperty("jetty.home"), source);
            return;
        }
        if (key.equals("jetty.base")) {
            properties.setProperty("jetty.base", System.getProperty("jetty.base"), source);
            return;
        }
        properties.setProperty(key, value, source);
        if (key.equals("java.version")) {
            try {
                JavaVersion ver = JavaVersion.parse(value);
                properties.setProperty("java.version.platform", Integer.toString(ver.getPlatform()), source);
                properties.setProperty("java.version.major", Integer.toString(ver.getMajor()), "Deprecated");
                properties.setProperty("java.version.minor", Integer.toString(ver.getMinor()), "Deprecated");
                properties.setProperty("java.version.micro", Integer.toString(ver.getMicro()), "Deprecated");
                properties.setProperty("runtime.feature.alpn", Boolean.toString(this.isMethodAvailable(SSLParameters.class, "getApplicationProtocols", null)), source);
            }
            catch (Throwable x) {
                UsageException ue = new UsageException(-5, x.getMessage() == null ? x.toString() : x.getMessage());
                ue.initCause(x);
                throw ue;
            }
        }
        if (key.equals("maven.repo.uri")) {
            this.mavenBaseUri = value;
        }
    }

    private boolean isMethodAvailable(Class<?> clazz, String methodName, Class<?>[] params) {
        try {
            clazz.getMethod(methodName, params);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void setRun(boolean run) {
        this.run = run;
    }

    public String toString() {
        return String.format("%s[enabledModules=%s, xml=%s, properties=%s, jvmArgs=%s]", this.getClass().getSimpleName(), this.modules, this.getJettyEnvironment().getXmlFiles(), this.getJettyEnvironment().getProperties(), this.jvmArgSources.keySet());
    }

    static {
        ALL_PARTS = Set.of("java", "opts", "path", "main", "args", "envs");
        ARG_PARTS = Set.of("args", "envs");
        String ver = System.getProperty(JETTY_VERSION_KEY);
        String tag = System.getProperty(JETTY_TAG_NAME_KEY);
        if (Utils.isBlank(ver)) {
            ver = ManifestUtils.getManifest(StartArgs.class).map(Manifest::getMainAttributes).filter(attributes -> "Eclipse Jetty Project".equals(attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR))).map(attributes -> attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION)).orElse(null);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Props jettyVerProps = Props.load(classLoader, "jetty-version.properties");
        Props buildProps = Props.load(classLoader, "org/eclipse/jetty/start/build.properties");
        String sha = buildProps.getString("buildNumber", System.getProperty(JETTY_BUILDNUM_KEY));
        if (Utils.isNotBlank(sha)) {
            System.setProperty(JETTY_BUILDNUM_KEY, sha);
        }
        if (Utils.isBlank(ver)) {
            ver = jettyVerProps.getString("version", buildProps.getString("version", "0.0"));
        }
        if (Utils.isBlank(tag)) {
            tag = jettyVerProps.getString("tag", buildProps.getString("tag", "jetty-" + ver));
        }
        VERSION = ver;
        System.setProperty(JETTY_VERSION_KEY, VERSION);
        System.setProperty(JETTY_TAG_NAME_KEY, tag);
        environments = new TreeMap<String, StartEnvironment>(String.CASE_INSENSITIVE_ORDER);
    }
}

