/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.StreamType;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.quic.util.VarLenInt;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionFlusher
extends IteratingCallback {
    private static final Logger LOG = LoggerFactory.getLogger(InstructionFlusher.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Instruction> queue = new ArrayDeque<Instruction>();
    private final ByteBufferPool bufferPool;
    private final RetainableByteBuffer.DynamicCapacity accumulator;
    private final StreamEndPoint endPoint;
    private final long streamType;
    private boolean initialized;
    private Throwable terminated;

    public InstructionFlusher(ByteBufferPool bufferPool, StreamEndPoint endPoint, StreamType streamType) {
        this.bufferPool = bufferPool;
        this.accumulator = new RetainableByteBuffer.DynamicCapacity(bufferPool, true, -1L, 0, 0);
        this.endPoint = endPoint;
        this.streamType = streamType.type();
    }

    public boolean offer(List<Instruction> instructions) {
        Throwable closed;
        try (AutoLock ignored = this.lock.lock();){
            closed = this.terminated;
            if (closed == null) {
                this.queue.addAll(instructions);
            }
        }
        return closed == null;
    }

    protected IteratingCallback.Action process() {
        ArrayList<Instruction> instructions;
        try (AutoLock ignored = this.lock.lock();){
            if (this.queue.isEmpty()) {
                IteratingCallback.Action action = IteratingCallback.Action.IDLE;
                return action;
            }
            instructions = new ArrayList<Instruction>(this.queue);
            this.queue.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} on {}", instructions, (Object)this);
        }
        if (!this.initialized) {
            this.initialized = true;
            RetainableByteBuffer.Mutable buffer = this.bufferPool.acquire(VarLenInt.length((long)this.streamType), true);
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)this.streamType);
            byteBuffer.flip();
            this.accumulator.add((RetainableByteBuffer)buffer);
        }
        instructions.forEach(i -> i.encode(this.bufferPool, (RetainableByteBuffer.Mutable)this.accumulator));
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing buffers ({} bytes) on {}", (Object)this.accumulator.size(), (Object)this);
        }
        this.accumulator.writeTo((Content.Sink)this.endPoint, false, (Callback)this);
        return IteratingCallback.Action.SCHEDULED;
    }

    protected void onSuccess() {
        this.accumulator.clear();
    }

    protected void onCompleteSuccess() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("succeeded to write buffers on {}", (Object)this);
        }
        this.accumulator.release();
    }

    protected void onFailure(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed to write buffers on {}", (Object)this, (Object)failure);
        }
        try (AutoLock ignored = this.lock.lock();){
            this.terminated = failure;
            this.queue.clear();
        }
        ConnectionCloseFrame frame = new ConnectionCloseFrame(HTTP3ErrorCode.INTERNAL_ERROR.code(), "instruction_stream_failure");
        this.endPoint.getProtocolSession().disconnect(frame, failure, Promise.Invocable.noop());
    }

    protected void onCompleteFailure(Throwable cause) {
        this.accumulator.release();
    }

    public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.NON_BLOCKING;
    }

    public String toString() {
        return String.format("%s#%s", super.toString(), this.endPoint.getStream().getId());
    }
}

