/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.coreapp;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.server.Deployable;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreAppContext
extends ContextHandler
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(CoreAppContext.class);
    private static final String ORIGINAL_BASE_RESOURCE_ATTRIBUTE = "jetty.deploy.core.originalBaseResource";
    private static final String EXTRA_CLASS_PATH_ATTRIBUTE = "jetty.deploy.core.extraClassPath";
    private static final String JETTY_WEB_XML = "jetty-web.xml";
    private boolean initialized = false;
    private List<Resource> extraClassPath;
    private ClassLoader previousClassLoader;
    private Boolean deferredDirAllowed;

    public CoreAppContext() {
        this(null);
    }

    public CoreAppContext(String contextPath) {
        if (contextPath != null) {
            this.setContextPath(contextPath);
        }
    }

    @ManagedAttribute(value="extra classpath for context classloader", readonly=true)
    public List<Resource> getExtraClassPath() {
        return this.extraClassPath == null ? Collections.emptyList() : this.extraClassPath;
    }

    protected void initializeDefault(String keyName, Object value) {
        switch (keyName) {
            case "jetty.deploy.core.extraClassPath": {
                if (!(value instanceof String)) break;
                String str = (String)value;
                this.setExtraClassPath(str);
                break;
            }
            case "jetty.deploy.baseResource.dirAllowed": {
                if (value instanceof String) {
                    String str = (String)value;
                    this.setDirAllowed(Boolean.parseBoolean(str));
                    break;
                }
                if (!(value instanceof Boolean)) break;
                Boolean bool = (Boolean)value;
                this.setDirAllowed(bool);
                break;
            }
            case "jetty.deploy.paths.main": {
                Path mainPath = (Path)value;
                if (!Files.isDirectory(mainPath, new LinkOption[0]) && !FileID.isArchive((Path)mainPath)) break;
                ResourceFactory resourceFactory = ResourceFactory.of((Container)this);
                Resource baseResource = resourceFactory.newResource((Path)value);
                this.setBaseResource(baseResource);
                break;
            }
            case "jetty.deploy.paths.other": {
                Collection deployablePaths = (Collection)value;
                Path mainDir = null;
                for (Path path : deployablePaths) {
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    if (mainDir == null) {
                        mainDir = path;
                        continue;
                    }
                    throw new IllegalArgumentException("More than one directory is not supported: " + deployablePaths.stream().map(Path::toString).collect(Collectors.joining(", ", "[", "]")));
                }
                if (mainDir == null) break;
                ResourceFactory resourceFactory = ResourceFactory.of((Container)this);
                Resource resourceDir = resourceFactory.newResource(mainDir);
                this.setBaseResource(resourceDir);
            }
        }
    }

    private void setDirAllowed(Boolean bool) {
        ResourceHandler resourceHandler = (ResourceHandler)this.getBean(ResourceHandler.class);
        if (resourceHandler != null) {
            resourceHandler.setDirAllowed(bool.booleanValue());
        } else {
            this.deferredDirAllowed = bool;
        }
    }

    protected void initializeDefaultsComplete() {
        try {
            this.initWebApp();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to init " + TypeUtil.toShortName(((Object)((Object)this)).getClass()), e);
        }
    }

    public void setExtraClassPath(String extraClasspath) {
        this.setExtraClassPath(this.getResourceFactory().split(extraClasspath));
    }

    public void setExtraClassPath(String ... extraClasspath) {
        this.setExtraClassPath(Stream.of(extraClasspath).map(entry -> this.getResourceFactory().newResource(entry)).toList());
    }

    public void setExtraClassPath(List<Resource> extraClasspath) {
        this.extraClassPath = extraClasspath;
    }

    public ResourceFactory getResourceFactory() {
        return ResourceFactory.of((Container)this);
    }

    public void setBaseResource(Resource baseResource) {
        if (baseResource == null || Resources.isDirectory((Resource)baseResource)) {
            super.setBaseResource(baseResource);
            return;
        }
        if (Resources.isReadableFile((Resource)baseResource)) {
            URI uri = baseResource.getURI();
            if (FileID.isArchive((URI)uri)) {
                Resource jarResource = this.getResourceFactory().newJarFileResource(uri);
                super.setBaseResource(jarResource);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignored base resource: {}", (Object)baseResource);
            }
            return;
        }
        super.setBaseResource(baseResource);
    }

    protected Resource unpack(Resource dir) throws IOException {
        Path tempDir = this.getTempDirectory().toPath();
        dir.copyTo(tempDir);
        return ResourceFactory.of((Container)this).newResource(tempDir);
    }

    private ClassLoader newClassLoader(Resource baseResource, ClassLoader parentClassLoader) throws IOException {
        List<URL> urls;
        Attributes.Mapped attributes = new Attributes.Mapped();
        attributes.setAttribute("jetty.deploy.tempDir", (Object)this.getTempDirectory());
        if (baseResource == null) {
            return null;
        }
        Objects.requireNonNull(attributes);
        if (!Resources.isDirectory((Resource)baseResource)) {
            if (FileID.isArchive((URI)baseResource.getURI())) {
                attributes.setAttribute(ORIGINAL_BASE_RESOURCE_ATTRIBUTE, (Object)baseResource.getURI());
                URI archiveURI = URIUtil.toJarFileUri((URI)baseResource.getURI());
                Resource mountedArchive = this.getResourceFactory().newResource(archiveURI);
                baseResource = this.unpack(mountedArchive);
                attributes.setAttribute("jetty.deploy.baseResource", (Object)baseResource);
            } else {
                throw new IllegalArgumentException("Unrecognized non-directory base resource type: " + String.valueOf(baseResource));
            }
        }
        if ((urls = this.findClassLoaderURLs(baseResource)).isEmpty()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Core webapp classloader: {}", urls);
        }
        return new URLClassLoader((URL[])urls.toArray(URL[]::new), parentClassLoader);
    }

    private List<URL> findClassLoaderURLs(Resource baseResource) throws IOException {
        List<Resource> extraEntries;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (Resources.isDirectory((Resource)baseResource)) {
            Resource classesDir;
            Resource libDir = baseResource.resolve("lib");
            if (Resources.isDirectory((Resource)libDir)) {
                for (Resource entry : libDir.list()) {
                    URI uri = entry.getURI();
                    if (!FileID.isJavaArchive((URI)uri)) continue;
                    urls.add(uri.toURL());
                }
            }
            if (Resources.isDirectory((Resource)(classesDir = baseResource.resolve("classes")))) {
                urls.add(classesDir.getURI().toURL());
            }
        }
        if ((extraEntries = this.getExtraClassPath()) != null && !extraEntries.isEmpty()) {
            for (Resource entry : extraEntries) {
                urls.add(entry.getURI().toURL());
            }
        }
        return urls;
    }

    protected void initWebApp() throws IOException {
        ClassLoader classLoader;
        Environment environment;
        if (this.initialized) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Already initialized, not initializing again");
            }
            return;
        }
        this.initialized = true;
        Resource baseResource = this.getBaseResource();
        if (baseResource == null) {
            return;
        }
        Resource staticDir = baseResource.resolve("static");
        if (Resources.isDirectory((Resource)staticDir) && !this.isResourceHandlerAlreadyPresent(staticDir)) {
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setBaseResource(staticDir);
            if (this.deferredDirAllowed != null) {
                resourceHandler.setDirAllowed(this.deferredDirAllowed.booleanValue());
            }
            this.setHandler((Handler)resourceHandler);
        }
        if ((environment = Environment.get((String)"core")) == null) {
            throw new IllegalStateException("Could not find environment [core]");
        }
        this.previousClassLoader = classLoader = this.getClassLoader();
        if (classLoader == null) {
            classLoader = environment.getClassLoader();
        }
        this.setClassLoader(this.newClassLoader(baseResource, classLoader));
        Resource xmlFile = baseResource.resolve(JETTY_WEB_XML);
        if (Resources.isReadableFile((Resource)xmlFile)) {
            this.applyXml(xmlFile, environment);
        }
    }

    private void applyXml(Resource xmlFile, Environment environment) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            classLoader = environment.getClassLoader();
        }
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            XmlConfiguration xmlConfiguration = new XmlConfiguration(xmlFile, null, CoreAppContext.asProperties((Attributes)this));
            xmlConfiguration.getIdMap().put("Environment", environment.getName());
            xmlConfiguration.setJettyStandardIdsAndProperties((Object)this.getServer(), xmlFile.getPath());
            this.getAttributeNameSet().stream().filter(k -> !k.startsWith("jetty.home") && !k.startsWith("jetty.base") && !k.startsWith("jetty.webapps")).forEach(k -> {
                Object v = this.getAttribute((String)k);
                if (v == null) {
                    xmlConfiguration.getProperties().remove(k);
                } else {
                    xmlConfiguration.getProperties().put(k, CoreAppContext.asPropertyValue(v));
                }
            });
            xmlConfiguration.configure((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static Map<String, String> asProperties(Attributes attributes) {
        HashMap<String, String> props = new HashMap<String, String>();
        attributes.getAttributeNameSet().forEach(name -> {
            Object value = attributes.getAttribute(name);
            props.put((String)name, Objects.toString(value));
        });
        return props;
    }

    private static String asPropertyValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Enum) {
            Enum en = (Enum)obj;
            return en.name();
        }
        if (obj instanceof Environment) {
            Environment env = (Environment)obj;
            return env.getName();
        }
        return Objects.toString(obj);
    }

    private boolean isResourceHandlerAlreadyPresent(Resource staticDir) {
        for (Handler handler : this.getHandlers()) {
            URI baseResourceURI;
            ResourceHandler resourceHandler;
            Resource baseResource;
            if (!(handler instanceof ResourceHandler) || (baseResource = (resourceHandler = (ResourceHandler)handler).getBaseResource()) == null || !(baseResourceURI = baseResource.getURI()).equals(staticDir.getURI())) continue;
            return true;
        }
        return false;
    }

    protected void doStart() throws Exception {
        this.initWebApp();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.initialized = false;
        this.setClassLoader(this.previousClassLoader);
        this.previousClassLoader = null;
        super.doStop();
    }
}

