/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.security.jaspi.modules;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.jetty.ee11.security.jaspi.callback.CredentialValidationCallback;
import org.eclipse.jetty.ee11.servlet.security.authentication.LoginCallbackImpl;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;

public abstract class BaseAuthModule
implements ServerAuthModule,
ServerAuthContext {
    private static final Class[] SUPPORTED_MESSAGE_TYPES = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    protected static final String LOGIN_SERVICE_KEY = "org.eclipse.jetty.ee11.security.jaspi.modules.LoginService";
    protected CallbackHandler callbackHandler;

    public Class[] getSupportedMessageTypes() {
        return SUPPORTED_MESSAGE_TYPES;
    }

    public BaseAuthModule() {
    }

    public BaseAuthModule(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.callbackHandler = handler;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return AuthStatus.SEND_SUCCESS;
    }

    protected boolean login(Subject clientSubject, String credentials, String authenticationType, MessageInfo messageInfo) throws IOException, UnsupportedCallbackException {
        credentials = credentials.substring(credentials.indexOf(32) + 1);
        credentials = new String(Base64.getDecoder().decode(credentials), StandardCharsets.ISO_8859_1);
        int i = credentials.indexOf(58);
        String userName = credentials.substring(0, i);
        String password = credentials.substring(i + 1);
        return this.login(clientSubject, userName, (Credential)new Password(password), authenticationType, messageInfo);
    }

    protected boolean login(Subject clientSubject, String username, Credential credential, String authenticationType, MessageInfo messageInfo) throws IOException, UnsupportedCallbackException {
        CredentialValidationCallback credValidationCallback = new CredentialValidationCallback(clientSubject, username, credential);
        this.callbackHandler.handle(new Callback[]{credValidationCallback});
        if (credValidationCallback.getResult()) {
            Set<LoginCallbackImpl> loginCallbacks = clientSubject.getPrivateCredentials(LoginCallbackImpl.class);
            if (!loginCallbacks.isEmpty()) {
                LoginCallbackImpl loginCallback = loginCallbacks.iterator().next();
                CallerPrincipalCallback callerPrincipalCallback = new CallerPrincipalCallback(clientSubject, loginCallback.getUserPrincipal());
                GroupPrincipalCallback groupPrincipalCallback = new GroupPrincipalCallback(clientSubject, loginCallback.getRoles());
                this.callbackHandler.handle(new Callback[]{callerPrincipalCallback, groupPrincipalCallback});
            }
            messageInfo.getMap().put("jakarta.servlet.http.authType", authenticationType);
        }
        return credValidationCallback.getResult();
    }
}

