/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.io.EOFException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.ContentParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.http.HttpField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Parser {
    private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
    protected final HeaderParser headerParser = new HeaderParser();
    private final Listener listener;
    private State state = State.INITIAL;
    private int padding;

    protected Parser(Listener listener) {
        this.listener = listener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public boolean parse(ByteBuffer buffer) {
        try {
            block8: while (true) {
                switch (this.state.ordinal()) {
                    case 0: {
                        if (!buffer.hasRemaining()) {
                            return false;
                        }
                        this.state = State.HEADER;
                        continue block8;
                    }
                    case 1: {
                        if (!this.headerParser.parse(buffer)) {
                            return false;
                        }
                        this.state = State.CONTENT;
                        continue block8;
                    }
                    case 2: {
                        ContentParser contentParser = this.findContentParser(this.headerParser.getFrameType());
                        if (this.headerParser.getContentLength() == 0) {
                            this.padding = this.headerParser.getPaddingLength();
                            this.state = State.PADDING;
                            if (!contentParser.noContent()) continue block8;
                            return true;
                        }
                        ContentParser.Result result = contentParser.parse(buffer);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Parsed request {} content {} result={}", new Object[]{this.headerParser.getRequest(), this.headerParser.getFrameType(), result});
                        }
                        if (result == ContentParser.Result.PENDING) {
                            return false;
                        }
                        if (result == ContentParser.Result.ASYNC) {
                            return true;
                        }
                        this.padding = this.headerParser.getPaddingLength();
                        this.state = State.PADDING;
                        continue block8;
                    }
                    case 3: {
                        if (buffer.remaining() < this.padding) {
                            this.padding -= buffer.remaining();
                            buffer.position(buffer.limit());
                            return false;
                        }
                        buffer.position(buffer.position() + this.padding);
                        this.reset();
                        if (!buffer.hasRemaining()) return true;
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            buffer.position(buffer.limit());
            this.listener.onFailure(this.headerParser.getRequest(), x);
            return true;
        }
    }

    protected abstract ContentParser findContentParser(FCGI.FrameType var1);

    public boolean eof() {
        if (this.state == State.INITIAL) {
            return false;
        }
        EOFException failure = new EOFException();
        this.listener.onFailure(this.headerParser.getRequest(), failure);
        return true;
    }

    private void reset() {
        this.headerParser.reset();
        this.state = State.INITIAL;
        this.padding = 0;
    }

    private static enum State {
        INITIAL,
        HEADER,
        CONTENT,
        PADDING;

    }

    public static interface Listener {
        default public void onHeader(int request, HttpField field) {
        }

        default public boolean onHeaders(int request) {
            return false;
        }

        default public boolean onContent(int request, FCGI.StreamType stream, ByteBuffer buffer) {
            return false;
        }

        default public boolean onEnd(int request) {
            return false;
        }

        default public void onFailure(int request, Throwable failure) {
        }
    }
}

