/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.server;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.api.frames.Frame;
import org.eclipse.jetty.quic.common.AbstractSession;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.ProtocolStreamListener;
import org.eclipse.jetty.quic.quiche.server.AbstractQuicheServerConnectionFactory;
import org.eclipse.jetty.quic.quiche.server.QuicheServerQuicConfiguration;
import org.eclipse.jetty.quic.quiche.server.internal.ServerQuicheSession;
import org.eclipse.jetty.quic.server.ServerProtocolSession;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuicheServerConnectionFactory
extends AbstractQuicheServerConnectionFactory
implements ConnectionFactory.Configuring {
    private static final Logger LOG = LoggerFactory.getLogger(QuicheServerConnectionFactory.class);

    public QuicheServerConnectionFactory(SslContextFactory.Server sslContextFactory, QuicheServerQuicConfiguration quicConfiguration) {
        super(sslContextFactory, quicConfiguration, new ProtocolSessionListenerFactory());
    }

    public void configure(Connector connector) {
        Session.Listener.Factory factory = this.getSessionListenerFactory();
        if (factory instanceof ConnectionFactory.Configuring) {
            ConnectionFactory.Configuring c = (ConnectionFactory.Configuring)factory;
            c.configure(connector);
        }
    }

    private static class ProtocolSessionListenerFactory
    implements Session.Listener.Factory,
    ConnectionFactory.Configuring {
        private Connector connector;

        private ProtocolSessionListenerFactory() {
        }

        public void configure(Connector connector) {
            this.connector = connector;
        }

        public Session.Listener newListener() {
            return new ProtocolSessionListener(this.connector);
        }
    }

    private static class ProtocolSessionListener
    implements AbstractSession.Listener {
        private final AtomicReference<ProtocolSession> protocolSession = new AtomicReference();
        private final Connector connector;

        private ProtocolSessionListener(Connector connector) {
            this.connector = connector;
        }

        public void onOpen(Session session) {
            try {
                ServerQuicheSession qSession = (ServerQuicheSession)session;
                ProtocolSession pSession = this.newProtocolSession(qSession);
                qSession.addManaged((LifeCycle)pSession);
                this.protocolSession.set(pSession);
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("could not create ProtocolSession", x);
                }
                session.disconnect(new ConnectionCloseFrame(ErrorCode.APPLICATION_ERROR.code(), "invalid_protocol"), x, Promise.Invocable.noop());
            }
        }

        public Stream.Listener onNewStream(Session session, Frame.WithStreamId frame) {
            return new ProtocolStreamListener.Server(this.protocolSession.get());
        }

        public boolean onIdleTimeout(Session session, TimeoutException failure) {
            ProtocolSession pSession = this.protocolSession.get();
            if (pSession != null) {
                return pSession.onIdleTimeout(failure);
            }
            return true;
        }

        public CompletableFuture<Session> onLocalShutdown(Session session) {
            ProtocolSession pSession = this.protocolSession.get();
            if (pSession != null) {
                return pSession.shutdown().thenApply(ps -> session);
            }
            return CompletableFuture.completedFuture(session);
        }

        public void onLocalClose(Session session, ConnectionCloseFrame frame, Promise.Invocable<Session> promise) {
            ProtocolSession pSession = this.protocolSession.get();
            if (pSession != null) {
                pSession.close(frame, Promise.Invocable.toPromise(promise, ps -> session));
            } else {
                promise.succeeded((Object)session);
            }
        }

        public void onClose(Session session, ConnectionCloseFrame frame) {
            ProtocolSession pSession = this.protocolSession.get();
            if (pSession != null) {
                pSession.onClose(frame);
            }
        }

        private ProtocolSession newProtocolSession(ServerQuicheSession session) {
            ProtocolSession pSession;
            String protocol = session.getNegotiatedProtocol();
            if (protocol == null) {
                throw new IllegalStateException("missing application protocol");
            }
            ConnectionFactory connectionFactory = this.connector.getConnectionFactory(protocol);
            if (connectionFactory == null) {
                throw new IllegalStateException("missing ConnectionFactory for protocol " + protocol);
            }
            if (connectionFactory instanceof ProtocolSession.Factory) {
                ProtocolSession.Factory psf = (ProtocolSession.Factory)connectionFactory;
                pSession = psf.newProtocolSession((Session)session, Map.of());
            } else {
                pSession = new ServerProtocolSession(this.connector, (Session)session, connectionFactory);
            }
            return pSession;
        }
    }
}

