/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common.internal.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.quic.util.QuicException;
import org.eclipse.jetty.quic.util.VarLenInt;
import org.eclipse.jetty.util.Utf8StringBuilder;

public class ConnectionCloseParser {
    private final VarLenInt varLenInt;
    private int maxReasonLength = 128;
    private State state = State.FRAME_TYPE;
    private boolean appError;
    private long errorCode;
    private long causeFrameType;
    private long reasonLength;
    private final Utf8StringBuilder reasonBuilder = new Utf8StringBuilder();

    public ConnectionCloseParser(VarLenInt varLenInt) {
        this.varLenInt = varLenInt;
    }

    public void setReasonMaxLength(int maxReasonLength) {
        this.maxReasonLength = maxReasonLength;
    }

    public ConnectionCloseFrame parse(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    this.appError = (byteBuffer.get() & 0xFF) == 29;
                    this.state = State.ERROR_CODE;
                    break;
                }
                case 1: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.errorCode = v;
                    })) break;
                    this.state = this.appError ? State.REASON_LENGTH : State.CAUSE_FRAME_TYPE;
                    break;
                }
                case 2: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.causeFrameType = v;
                    })) break;
                    this.state = State.REASON_LENGTH;
                    break;
                }
                case 3: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.reasonLength = v;
                    })) break;
                    if (this.reasonLength > (long)this.maxReasonLength) {
                        throw new QuicException(ErrorCode.FRAME_ENCODING_ERROR, "invalid_reason_length", this.appError ? 29L : 28L);
                    }
                    this.state = State.REASON;
                    break;
                }
                case 4: {
                    int position = byteBuffer.position();
                    int length = (int)Math.min(this.reasonLength, (long)byteBuffer.remaining());
                    this.reasonBuilder.append(byteBuffer.slice(position, length));
                    byteBuffer.position(position + length);
                    this.reasonLength -= (long)length;
                    if (this.reasonLength != 0L) break;
                    return this.result();
                }
            }
        }
        return null;
    }

    private ConnectionCloseFrame result() {
        String reason = this.reasonBuilder.toCompleteString();
        ConnectionCloseFrame frame = this.appError ? new ConnectionCloseFrame(this.errorCode, reason) : new ConnectionCloseFrame(this.errorCode, reason, this.causeFrameType);
        this.state = State.FRAME_TYPE;
        this.appError = false;
        this.errorCode = 0L;
        this.causeFrameType = 0L;
        this.reasonLength = 0L;
        this.reasonBuilder.reset();
        return frame;
    }

    private static enum State {
        FRAME_TYPE,
        ERROR_CODE,
        CAUSE_FRAME_TYPE,
        REASON_LENGTH,
        REASON;

    }
}

