/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.quiche.QuicheSession;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class QuicheConnection
extends AbstractConnection {
    private final Callback fillableCallback = new FillableCallback();
    private final Scheduler scheduler;
    private final ByteBufferPool bufferPool;

    protected QuicheConnection(Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, EndPoint endPoint) {
        super(endPoint, executor);
        this.scheduler = scheduler;
        this.bufferPool = bufferPool;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public void fillInterested() {
        this.getEndPoint().fillInterested(this.fillableCallback);
    }

    public abstract void write(Callback var1, SocketAddress var2, ByteBuffer ... var3);

    public abstract boolean onIdleExpired(TimeoutException var1);

    public abstract void disconnect(QuicheSession var1, ConnectionCloseFrame var2, Throwable var3);

    private class FillableCallback
    implements Callback {
        private FillableCallback() {
        }

        public void succeeded() {
            QuicheConnection.this.onFillable();
        }

        public void failed(Throwable x) {
            QuicheConnection.this.onFillInterestedFailed(x);
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.EITHER;
        }

        public String toString() {
            return "%s@%x[%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getInvocationType());
        }
    }
}

