/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server.internal;

import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.HTTP3Session;
import org.eclipse.jetty.http3.HTTP3Stream;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.GoAwayFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.http3.server.internal.HTTP3StreamServer;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3Session;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3SessionServer
extends HTTP3Session
implements Session.Server {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3SessionServer.class);

    public HTTP3SessionServer(Scheduler scheduler, ServerHTTP3Session session, Session.Server.Listener listener) {
        super(scheduler, (ProtocolSession)session, (Session.Listener)listener);
    }

    public ServerHTTP3Session getProtocolSession() {
        return (ServerHTTP3Session)super.getProtocolSession();
    }

    public Session.Server.Listener getListener() {
        return (Session.Server.Listener)super.getListener();
    }

    public void onOpen() {
        super.onOpen();
        this.notifyAccept();
    }

    protected HTTP3StreamServer newHTTP3Stream(StreamEndPoint endPoint, boolean local) {
        return new HTTP3StreamServer(this, endPoint, local);
    }

    public void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
        MetaData metaData = frame.getMetaData();
        if (metaData.isRequest()) {
            Throwable metaDataFailure;
            StreamEndPoint endPoint = this.getProtocolSession().getStreamEndPoint(streamId);
            HTTP3StreamServer stream = (HTTP3StreamServer)this.createStream(endPoint);
            if (LOG.isDebugEnabled()) {
                LOG.debug("received request {} on {}", (Object)frame, (Object)stream);
            }
            if ((metaDataFailure = MetaData.Failed.getFailure((MetaData)metaData)) != null) {
                stream.updateClose(true, false);
                this.notifyStreamFailure((Stream)stream, (Throwable)new BadMessageException(metaDataFailure.getMessage(), metaDataFailure));
            } else {
                stream.onRequest(frame);
            }
        } else {
            super.onHeaders(streamId, frame, wasBlocked);
        }
    }

    public void onSettings(SettingsFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("received {} on {}", (Object)frame, (Object)this);
        }
        this.getProtocolSession().onSettings(frame);
        super.onSettings(frame);
    }

    public void writeControlFrame(Frame frame, Callback callback) {
        this.getProtocolSession().writeControlFrame(frame, callback);
    }

    public void writeMessageFrame(StreamEndPoint streamEndPoint, Frame frame, Callback callback) {
        this.getProtocolSession().writeMessageFrame(streamEndPoint, frame, callback);
    }

    protected GoAwayFrame newGoAwayFrame(boolean graceful) {
        if (graceful) {
            return GoAwayFrame.SERVER_GRACEFUL;
        }
        return super.newGoAwayFrame(graceful);
    }

    private void notifyAccept() {
        Session.Server.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onAccept((Session.Server)this);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    Stream.Server.Listener notifyRequest(HeadersFrame frame) {
        Session.Server.Listener listener = this.getListener();
        try {
            if (listener != null) {
                return listener.onRequest((Session.Server)this, frame);
            }
            return null;
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
            return null;
        }
    }

    private void notifyStreamFailure(Stream stream, Throwable failure) {
        Session.Server.Listener listener = this.getListener();
        if (listener instanceof Listener) {
            Listener l = (Listener)listener;
            try {
                l.onStreamFailure(stream, failure);
            }
            catch (Throwable x) {
                LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
            }
        } else {
            ((HTTP3Stream)stream).notifyFailure(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), failure);
        }
    }

    public static interface Listener
    extends Session.Server.Listener {
        public void onStreamFailure(Stream var1, Throwable var2);
    }
}

