/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;

public class SectionAcknowledgmentInstruction
implements Instruction {
    private final long _streamId;

    public SectionAcknowledgmentInstruction(long streamId) {
        this._streamId = streamId;
    }

    public long getStreamId() {
        return this._streamId;
    }

    @Override
    public void encode(ByteBufferPool byteBufferPool, RetainableByteBuffer.Mutable accumulator) {
        int size = NBitIntegerEncoder.octetsNeeded((int)7, (long)this._streamId);
        RetainableByteBuffer.Mutable retainableByteBuffer = byteBufferPool.acquire(size, true);
        ByteBuffer buffer = retainableByteBuffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)buffer);
        buffer.put((byte)-128);
        NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)7, (long)this._streamId);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        accumulator.add((RetainableByteBuffer)retainableByteBuffer);
    }

    public String toString() {
        return String.format("%s@%x[stream=%d]", TypeUtil.toShortName(this.getClass()), this.hashCode(), this._streamId);
    }
}

