/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyDemos {
    private static final Logger LOG = LoggerFactory.getLogger(JettyDemos.class);
    private static final Path JETTY_DEMOS_DIR;
    private static String VERSION;

    private static Path asDirectory(String path) {
        try {
            if (path == null) {
                return null;
            }
            if (StringUtil.isBlank((String)path)) {
                LOG.debug("asDirectory {} is blank", (Object)path);
                return null;
            }
            Path dir = Paths.get(path, new String[0]);
            if (!Files.exists(dir, new LinkOption[0])) {
                LOG.debug("asDirectory {} does not exist", (Object)path);
                return null;
            }
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                LOG.debug("asDirectory {} is not a directory", (Object)path);
                return null;
            }
            LOG.debug("asDirectory {}", (Object)dir);
            return dir.toAbsolutePath();
        }
        catch (Exception e) {
            LOG.trace("IGNORED", (Throwable)e);
            return null;
        }
    }

    private static Path get() {
        if (JETTY_DEMOS_DIR == null) {
            throw new RuntimeException("jetty /demos/ dir not found");
        }
        return JETTY_DEMOS_DIR;
    }

    public static Path find(String path, MavenCoordinate mavenCoordinate) throws FileNotFoundException {
        try {
            return JettyDemos.find(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String version = mavenCoordinate.version().isEmpty() ? VERSION : mavenCoordinate.version();
            Path result = Paths.get(System.getProperty("mavenRepoPath", System.getProperty("user.home") + "/.m2/repository"), mavenCoordinate.groupId().replaceAll("\\.", "/"), mavenCoordinate.artifactId(), version, mavenCoordinate.artifactId() + "-" + version + "." + mavenCoordinate.packaging());
            if (!Files.exists(result, new LinkOption[0])) {
                throw new FileNotFoundException(result.toString());
            }
            return result;
        }
    }

    @Deprecated
    public static Path find(String path) throws FileNotFoundException {
        String expandedPath = path.replaceAll("@VER@", VERSION);
        Path result = JettyDemos.get().resolve(expandedPath);
        if (!Files.exists(result, new LinkOption[0])) {
            throw new FileNotFoundException(result.toString());
        }
        return result;
    }

    public static void main(String ... arg) {
        System.err.println("Jetty Demos Dir is " + String.valueOf(JETTY_DEMOS_DIR));
    }

    static {
        VERSION = System.getProperty("jettyVersion", "unknown");
        Path demosDir = JettyDemos.asDirectory(System.getProperty("jetty.demos"));
        LOG.debug("JettyDemos(prop(jetty.demos)) = {}", (Object)demosDir);
        if (demosDir == null) {
            demosDir = JettyDemos.asDirectory(System.getenv().get("JETTY_DEMOS"));
            LOG.debug("JettyDemos(env(JETTY_DEMOS)) = {}", (Object)demosDir);
        }
        if (demosDir == null || !Files.exists(demosDir.resolve("pom.xml"), new LinkOption[0])) {
            try {
                Path working;
                Path dir = null;
                LOG.debug("JettyDemos(prop(user.dir)) = {}", (Object)working);
                for (working = Paths.get(System.getProperty("user.dir"), new String[0]); dir == null && working != null; working = working.getParent()) {
                    dir = JettyDemos.asDirectory(working.resolve("jetty-ee11-demos").toString());
                    if (dir == null || !Files.exists(dir.resolve("pom.xml"), new LinkOption[0])) continue;
                    demosDir = dir;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("JettyDemos(working.resolve(...)) = {}", (Object)demosDir);
                }
            }
            catch (Throwable th) {
                LOG.warn("Unable to resolve Jetty Demos location", th);
            }
        }
        JETTY_DEMOS_DIR = demosDir;
        String version = "unknown";
        if (version.equals(VERSION)) {
            Path pomFile = demosDir.resolve("pom.xml");
            try (Stream<String> lineStream = Files.lines(pomFile);){
                String versionLine = lineStream.filter(line -> line.contains("<version>")).findFirst().orElseThrow(() -> new RuntimeException("Unable to find <version> in " + String.valueOf(pomFile)));
                version = versionLine.replaceAll("<[^>]*>", "").trim();
            }
            catch (IOException e) {
                LOG.warn("Unable to find <version> in " + String.valueOf(pomFile), (Throwable)e);
            }
            VERSION = version;
        }
    }

    public record MavenCoordinate(String groupId, String artifactId, String version, String packaging) {
    }
}

