/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.WritePendingException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.common.AbstractStream;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.quiche.QuicheSession;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuicheStream
extends AbstractStream {
    private static final Logger LOG = LoggerFactory.getLogger(QuicheStream.class);
    private static final Stream.Listener DEFAULT_LISTENER = new Stream.Listener(){};
    private final AutoLock lock = new AutoLock();
    private final AtomicReference<Writer> writer = new AtomicReference();
    private final AtomicReference<CloseState> closeState = new AtomicReference<CloseState>(CloseState.NOT_CLOSED);
    private final QuicheSession session;
    private RetainableByteBuffer inputBuffer;
    private Content.Chunk chunk;
    private boolean dataDemand;

    public QuicheStream(QuicheSession session, long streamId, boolean local) {
        super(streamId, local);
        this.session = session;
    }

    public boolean isClosed() {
        return this.closeState.get() == CloseState.CLOSED;
    }

    public boolean isLocallyClosed() {
        return this.closeState.get() == CloseState.LOCALLY_CLOSED;
    }

    public boolean isRemotelyClosed() {
        CloseState current = this.closeState.get();
        return switch (current.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1 -> {
                boolean finished = this.session.isFinished(this);
                if (finished) {
                    this.updateCloseState(CloseState.REMOTELY_CLOSED);
                }
                yield finished;
            }
            case 2, 3 -> true;
        };
    }

    public QuicheSession getSession() {
        return this.session;
    }

    void readable() {
        Throwable resetFailure;
        boolean hasDemand;
        try (AutoLock ignored = this.lock.lock();){
            hasDemand = this.dataDemand;
            this.dataDemand = false;
        }
        boolean streamFinished = this.session.isFinished(this);
        Throwable throwable = resetFailure = streamFinished ? this.isReset() : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("readable demand={} finished={} reset={} {} on {}", new Object[]{hasDemand, streamFinished, resetFailure != null, this, this.session});
        }
        if (hasDemand && resetFailure == null) {
            this.notifyDataAvailable();
        } else if (resetFailure != null) {
            this.notifyFailure(resetFailure);
        }
    }

    private Throwable isReset() {
        Throwable failure = this.session.isReset(this);
        if (failure != null) {
            this.updateCloseState(CloseState.REMOTELY_CLOSED);
        }
        return failure;
    }

    public Content.Chunk read() {
        RetainableByteBuffer inputBuffer;
        try (AutoLock ignored = this.lock.lock();){
            if (this.chunk != null) {
                Content.Chunk chunk = this.chunk;
                return chunk;
            }
            inputBuffer = this.inputBuffer;
            this.inputBuffer = null;
        }
        inputBuffer = this.tryAcquireInputBuffer(inputBuffer);
        try {
            ByteBuffer byteBuffer = inputBuffer.getByteBuffer();
            int position = byteBuffer.position();
            byteBuffer.limit(byteBuffer.capacity());
            boolean[] outLast = new boolean[1];
            int filled = this.session.read(this, byteBuffer, outLast);
            BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
            boolean last = outLast[0];
            if (LOG.isDebugEnabled()) {
                LOG.debug("read {} bytes last={} on {}", new Object[]{filled, last, this});
            }
            if (last) {
                this.updateCloseState(CloseState.REMOTELY_CLOSED);
            }
            if (filled > 0) {
                ByteBuffer slice = byteBuffer.slice();
                byteBuffer.position(byteBuffer.limit());
                Content.Chunk chunk = Content.Chunk.asChunk((ByteBuffer)slice, (boolean)last, (Retainable)inputBuffer);
                chunk.retain();
                if (last) {
                    this.tryReleaseInputBuffer(inputBuffer);
                } else {
                    this.tryStoreInputBuffer(inputBuffer);
                }
                return chunk;
            }
            if (filled == 0 && !last) {
                if (inputBuffer.isRetained()) {
                    this.tryStoreInputBuffer(inputBuffer);
                } else {
                    this.tryReleaseInputBuffer(inputBuffer);
                }
                return null;
            }
            this.tryReleaseInputBuffer(inputBuffer);
            return Content.Chunk.EOF;
        }
        catch (Throwable x) {
            Content.Chunk failure;
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("failure reading from {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                this.chunk = failure = Content.Chunk.from((Throwable)x);
            }
            this.tryReleaseInputBuffer(inputBuffer);
            this.updateCloseState(CloseState.REMOTELY_CLOSED);
            return failure;
        }
    }

    private RetainableByteBuffer tryAcquireInputBuffer(RetainableByteBuffer buffer) {
        QuicConfiguration quicConfiguration = this.session.getQuicConfiguration();
        if (buffer != null) {
            int minInputSpace = quicConfiguration.getMinInputBufferSpace();
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            if (minInputSpace < 0 || byteBuffer.capacity() - byteBuffer.limit() < minInputSpace) {
                this.tryReleaseInputBuffer(buffer);
                buffer = null;
            }
        }
        if (buffer == null) {
            buffer = this.getSession().getByteBufferPool().acquire(quicConfiguration.getInputBufferSize(), quicConfiguration.isUseInputDirectByteBuffers());
            if (LOG.isDebugEnabled()) {
                LOG.debug("acquired {} on {}", (Object)buffer, (Object)this);
            }
        }
        return buffer;
    }

    private void tryStoreInputBuffer(RetainableByteBuffer buffer) {
        try (AutoLock ignored = this.lock.lock();){
            assert (this.inputBuffer == null);
            if (this.chunk == null) {
                this.inputBuffer = buffer;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("stored {} on {}", (Object)buffer, (Object)this);
                }
                return;
            }
        }
        this.tryReleaseInputBuffer(buffer);
    }

    private void tryReleaseInputBuffer(RetainableByteBuffer buffer) {
        if (buffer != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("releasing {} on {}", (Object)buffer, (Object)this);
            }
            buffer.release();
        }
    }

    public void demand() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("demand for {} on {}", (Object)this, (Object)this.session);
        }
        try (AutoLock ignored = this.lock.lock();){
            this.dataDemand = true;
        }
        this.session.dispatch();
    }

    public void data(boolean last, List<ByteBuffer> buffers, Promise.Invocable<Stream> promise) {
        Writer current;
        do {
            if ((current = this.writer.get()) == null) continue;
            promise.failed((Throwable)new WritePendingException());
            return;
        } while (!this.writer.compareAndSet(null, current = Writer.forWriting(last, buffers, promise)));
        this.write(current);
    }

    public void setIdleTimeout(long idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        this.session.scheduleIdleTimeout(this);
    }

    private void write(Writer current) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("writing {} for {}", (Object)current, (Object)this);
            }
            int length = current.buffers().size();
            for (int i = 0; i < length; ++i) {
                int written;
                boolean lastBuffer;
                ByteBuffer buffer = current.buffers().get(i);
                int remaining = buffer.remaining();
                boolean bl = lastBuffer = i == length - 1;
                if (remaining == 0 && !lastBuffer || (written = this.session.data(this, current.last() && lastBuffer, buffer)) == remaining) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("pending {} for {}", (Object)current, (Object)this);
                }
                if (!current.pending()) {
                    Writer pending = Writer.forPending(current);
                    this.writer.compareAndSet(current, pending);
                }
                this.session.flush();
                return;
            }
            this.session.flush();
            this.writer.set(null);
            if (current.last()) {
                this.updateCloseState(CloseState.LOCALLY_CLOSED);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("written {} for {}", (Object)current, (Object)this);
            }
            current.promise().succeeded((Object)this);
        }
        catch (Throwable x) {
            this.updateCloseState(CloseState.LOCALLY_CLOSED);
            current.promise().failed(x);
        }
    }

    private void updateCloseState(CloseState event) {
        while (true) {
            CloseState current = this.closeState.get();
            switch (current.ordinal()) {
                case 0: {
                    if (!this.closeState.compareAndSet(current, event)) break;
                    return;
                }
                case 1: {
                    if (event == CloseState.REMOTELY_CLOSED || event == CloseState.CLOSED) {
                        if (!this.closeState.compareAndSet(current, CloseState.CLOSED)) break;
                        this.removeAndNotifyClose();
                    }
                    return;
                }
                case 2: {
                    if (event == CloseState.LOCALLY_CLOSED || event == CloseState.CLOSED) {
                        if (!this.closeState.compareAndSet(current, CloseState.CLOSED)) break;
                        this.removeAndNotifyClose();
                    }
                    return;
                }
                case 3: {
                    return;
                }
            }
        }
    }

    private void removeAndNotifyClose() {
        if (this.session.remove(this)) {
            this.notifyClose();
        }
    }

    public void maxData(long maxData, Promise.Invocable<Stream> promise) {
        throw new UnsupportedOperationException();
    }

    public void reset(long appErrorCode, Promise.Invocable<Stream> promise) {
        this.updateCloseState(CloseState.LOCALLY_CLOSED);
        this.session.shutdownStream(this, true, appErrorCode, promise);
    }

    public void stopSending(long appErrorCode, Promise.Invocable<Stream> promise) {
        this.session.shutdownStream(this, false, appErrorCode, promise);
    }

    public void dataBlocked(long offset, Promise.Invocable<Stream> promise) {
        throw new UnsupportedOperationException();
    }

    public void disconnect(long appErrorCode, Throwable failure, Promise.Invocable<Stream> promise) {
        this.disconnect(true, appErrorCode, failure, promise);
    }

    void disconnect(boolean stopAndReset, long appErrorCode, Throwable failure, Promise.Invocable<Stream> promise) {
        boolean reset;
        RetainableByteBuffer buffer;
        CloseState previous;
        Writer writer;
        if (LOG.isDebugEnabled()) {
            LOG.debug("disconnecting with error 0x{} stop&reset={} {} {}", new Object[]{Long.toHexString(appErrorCode), stopAndReset, this, String.valueOf(failure)});
        }
        if ((writer = this.writer.get()) != null) {
            writer.promise().failed(failure != null ? failure : new AsynchronousCloseException());
        }
        if ((previous = this.closeState.getAndSet(CloseState.CLOSED)) != CloseState.CLOSED) {
            this.removeAndNotifyClose();
        }
        try (AutoLock ignored = this.lock.lock();){
            this.chunk = Content.Chunk.from((Throwable)failure);
            buffer = this.inputBuffer;
            this.inputBuffer = null;
        }
        this.tryReleaseInputBuffer(buffer);
        if (!stopAndReset || previous == CloseState.CLOSED) {
            promise.succeeded((Object)this);
            return;
        }
        boolean stopSending = previous != CloseState.REMOTELY_CLOSED;
        boolean bl = reset = previous != CloseState.LOCALLY_CLOSED;
        if (stopSending) {
            if (reset) {
                this.stopSending(appErrorCode, (Promise.Invocable<Stream>)Promise.Invocable.from((Invocable.InvocationType)promise.getInvocationType(), s -> this.reset(appErrorCode, promise), arg_0 -> promise.failed(arg_0)));
            } else {
                this.stopSending(appErrorCode, promise);
            }
        } else if (reset) {
            this.reset(appErrorCode, promise);
        } else {
            promise.succeeded((Object)this);
        }
    }

    void onIdleTimeout(TimeoutException timeout) {
        this.notifyIdleTimeout(timeout, (Promise.Invocable<Boolean>)Promise.Invocable.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, (expired, x) -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("stream idle timeout {}ms {} on {}", new Object[]{this.getIdleTimeout(), expired != false ? "expired" : "ignored", this});
            }
            if (x == null) {
                if (expired.booleanValue()) {
                    this.disconnect(ErrorCode.NO_ERROR.code(), timeout, (Promise.Invocable<Stream>)Promise.Invocable.noop());
                } else {
                    this.notIdle();
                }
            } else {
                this.disconnect(ErrorCode.NO_ERROR.code(), ExceptionUtil.combine((Throwable)timeout, (Throwable)x), (Promise.Invocable<Stream>)Promise.Invocable.noop());
            }
        }));
    }

    void resumeWrite() {
        Writer current = this.writer.get();
        if (current == null) {
            return;
        }
        if (!current.pending) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("resuming write pending for {}", (Object)this);
        }
        this.write(current);
    }

    void tryFailWrite() {
        Writer current = this.writer.get();
        if (current == null) {
            return;
        }
        if (!current.pending) {
            return;
        }
        if (!this.session.isFailed(this)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("failing write pending for {}", (Object)this);
        }
        this.write(current);
    }

    void onNewStream() {
        this.notifyNewStream();
    }

    private void notifyNewStream() {
        Stream.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onNewStream((Stream)this, null);
            }
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    private void notifyDataAvailable() {
        Stream.Listener listener = Objects.requireNonNullElse(this.getListener(), DEFAULT_LISTENER);
        try {
            listener.onDataAvailable((Stream)this, false);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    private void notifyIdleTimeout(TimeoutException failure, Promise.Invocable<Boolean> promise) {
        Stream.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onIdleTimeout((Stream)this, failure, promise);
            } else {
                promise.succeeded((Object)true);
            }
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)listener, (Object)x);
            promise.failed(x);
        }
    }

    private void notifyFailure(Throwable failure) {
        Stream.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onFailure((Stream)this, failure);
            }
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    private void notifyClose() {
        Stream.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onClose((Stream)this);
            }
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public String toString() {
        return "%s[%s,writer=%s]".formatted(super.toString(), this.closeState, this.writer);
    }

    private static enum CloseState {
        NOT_CLOSED,
        LOCALLY_CLOSED,
        REMOTELY_CLOSED,
        CLOSED;

    }

    private record Writer(boolean last, List<ByteBuffer> buffers, Promise.Invocable<Stream> promise, boolean pending) {
        private static Writer forWriting(boolean last, List<ByteBuffer> buffers, Promise.Invocable<Stream> promise) {
            return new Writer(last, buffers, promise, false);
        }

        public static Writer forPending(Writer writer) {
            return new Writer(writer.last, writer.buffers, writer.promise, true);
        }

        @Override
        public String toString() {
            return "%s@%x[last=%b,pending=%b,buffers=%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.last, this.pending, this.buffers);
        }
    }
}

