/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server.internal;

import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.generator.ServerGenerator;
import org.eclipse.jetty.fcgi.parser.ServerParser;
import org.eclipse.jetty.fcgi.server.internal.HttpStreamOverFCGI;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.server.AbstractMetaDataConnection;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerFCGIConnection
extends AbstractMetaDataConnection
implements ConnectionMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(ServerFCGIConnection.class);
    private final Callback fillableCallback = new FillableCallback();
    private final HttpChannel.Factory httpChannelFactory = new HttpChannel.DefaultFactory();
    private final Attributes attributes = new Attributes.Lazy();
    private final Connector connector;
    private final ByteBufferPool bufferPool;
    private final boolean sendStatus200;
    private final Flusher flusher;
    private final ServerParser parser;
    private final String id;
    private boolean useInputDirectByteBuffers;
    private boolean useOutputDirectByteBuffers;
    private RetainableByteBuffer inputBuffer;
    private HttpStreamOverFCGI stream;

    public ServerFCGIConnection(Connector connector, EndPoint endPoint, HttpConfiguration configuration, boolean sendStatus200) {
        super(connector, configuration, endPoint);
        this.connector = connector;
        this.bufferPool = connector.getByteBufferPool();
        this.flusher = new Flusher(endPoint);
        this.sendStatus200 = sendStatus200;
        this.parser = new ServerParser((ServerParser.Listener)new ServerListener());
        this.id = StringUtil.randomAlphaNumeric((int)16);
    }

    public long getBeginNanoTime() {
        return this.parser.getBeginNanoTime();
    }

    Flusher getFlusher() {
        return this.flusher;
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public String getId() {
        return this.id;
    }

    public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_1_1;
    }

    public String getProtocol() {
        return "fcgi/1.0";
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean isSecure() {
        return false;
    }

    public Object removeAttribute(String name) {
        return this.attributes.removeAttribute(name);
    }

    public Object setAttribute(String name, Object attribute) {
        return this.attributes.setAttribute(name, attribute);
    }

    public Object getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        return this.attributes.getAttributeNameSet();
    }

    public void clearAttributes() {
        this.attributes.clearAttributes();
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested(this.fillableCallback);
    }

    /*
     * Exception decompiling
     */
    public void onFillable() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void parseAndFill() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parseAndFill {}", (Object)this);
        }
        this.acquireInputBuffer();
        while (this.stream != null) {
            if (this.parse(this.inputBuffer.getByteBuffer())) {
                return;
            }
            int filled = 0;
            if (this.stream != null && (filled = this.fillInputBuffer()) > 0) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("parseAndFill completed the request by parsing {}", (Object)this);
            }
            this.releaseInputBuffer();
            if (filled < 0) {
                this.stream.onContent(Content.Chunk.from((Throwable)new EofException()));
            }
            return;
        }
    }

    private void acquireInputBuffer() {
        if (this.inputBuffer == null) {
            this.inputBuffer = this.bufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
        }
    }

    private void releaseInputBuffer() {
        if (this.inputBuffer == null) {
            return;
        }
        boolean released = this.inputBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("releaseInputBuffer {} {}", (Object)released, (Object)this);
        }
        this.inputBuffer = null;
    }

    private int fillInputBuffer() {
        try {
            return this.getEndPoint().fill(this.inputBuffer.getByteBuffer());
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("Could not fill from {}", (Object)this);
            }
            return -1;
        }
    }

    private boolean parse(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            boolean result = this.parser.parse(buffer);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private void shutdown() {
        this.flusher.shutdown();
    }

    void onCompleted(Throwable failure) {
        this.releaseInputBuffer();
        if (failure == null) {
            this.fillInterested(this.fillableCallback);
        } else {
            this.getFlusher().shutdown();
        }
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        HttpStreamOverFCGI stream = this.stream;
        if (stream == null) {
            return true;
        }
        HttpChannel.IdleTimeoutTask task = stream.getHttpChannel().onIdleTimeout(timeoutException);
        boolean handlingRequest = task.handlingRequest();
        if (handlingRequest) {
            ThreadPool.executeImmediately((Executor)this.getExecutor(), (Runnable)task.action());
        }
        return !handlingRequest;
    }

    public void close() {
        try {
            Runnable task;
            if (this.stream != null && (task = this.stream.getHttpChannel().onClose()) != null) {
                task.run();
            }
        }
        finally {
            super.close();
        }
    }

    private class FillableCallback
    implements Callback {
        private final Invocable.InvocationType invocationType;

        private FillableCallback() {
            this.invocationType = ServerFCGIConnection.this.getConnector().getServer().getInvocationType();
        }

        public void succeeded() {
            ServerFCGIConnection.this.onFillable();
        }

        public void failed(Throwable x) {
            ServerFCGIConnection.this.onFillInterestedFailed(x);
        }

        public Invocable.InvocationType getInvocationType() {
            return this.invocationType;
        }
    }

    private class ServerListener
    implements ServerParser.Listener {
        private ServerListener() {
        }

        public void onStart(int request, FCGI.Role role, int flags) {
            if (ServerFCGIConnection.this.stream != null) {
                throw new UnsupportedOperationException("FastCGI Multiplexing");
            }
            HttpChannel channel = ServerFCGIConnection.this.httpChannelFactory.newHttpChannel((ConnectionMetaData)ServerFCGIConnection.this);
            ServerGenerator generator = new ServerGenerator(ServerFCGIConnection.this.connector.getByteBufferPool(), ServerFCGIConnection.this.isUseOutputDirectByteBuffers(), ServerFCGIConnection.this.sendStatus200);
            ServerFCGIConnection.this.stream = new HttpStreamOverFCGI(ServerFCGIConnection.this, generator, channel, request);
            channel.setHttpStream((HttpStream)ServerFCGIConnection.this.stream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} start on {}", (Object)request, (Object)channel);
            }
        }

        public void onHeader(int request, HttpField field) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} header {} on {}", new Object[]{request, field, ServerFCGIConnection.this.stream});
            }
            if (ServerFCGIConnection.this.stream != null) {
                ServerFCGIConnection.this.stream.onHeader(field);
            }
        }

        public boolean onHeaders(int request) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} headers on {}", (Object)request, (Object)ServerFCGIConnection.this.stream);
            }
            if (ServerFCGIConnection.this.stream != null) {
                ServerFCGIConnection.this.stream.onHeaders();
                return true;
            }
            return false;
        }

        public boolean onContent(int request, FCGI.StreamType streamType, ByteBuffer buffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} {} content {} on {}", new Object[]{request, streamType, buffer, ServerFCGIConnection.this.stream});
            }
            if (ServerFCGIConnection.this.stream != null) {
                Content.Chunk chunk = Content.Chunk.asChunk((ByteBuffer)buffer, (boolean)false, (Retainable)ServerFCGIConnection.this.inputBuffer);
                ServerFCGIConnection.this.stream.onContent(chunk);
                return true;
            }
            return false;
        }

        public boolean onEnd(int request) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} end on {}", (Object)request, (Object)ServerFCGIConnection.this.stream);
            }
            if (ServerFCGIConnection.this.stream != null) {
                ServerFCGIConnection.this.stream.onComplete();
                ServerFCGIConnection.this.stream = null;
                return true;
            }
            return false;
        }

        public void onFailure(int request, Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(failure).log("Request {} failure on {}", (Object)request, (Object)ServerFCGIConnection.this.stream);
            }
            if (ServerFCGIConnection.this.stream != null) {
                ThreadPool.executeImmediately((Executor)ServerFCGIConnection.this.getExecutor(), (Runnable)ServerFCGIConnection.this.stream.getHttpChannel().onFailure((Throwable)new BadMessageException(null, failure)));
            }
            ServerFCGIConnection.this.stream = null;
        }
    }
}

