/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.siwe;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPartConfig;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.ByteBufferContentSource;
import org.eclipse.jetty.security.AnyUserLoginService;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.security.siwe.internal.EthereumUtil;
import org.eclipse.jetty.security.siwe.internal.SignInWithEthereumToken;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CharsetStringBuilder;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthereumAuthenticator
extends LoginAuthenticator
implements Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(EthereumAuthenticator.class);
    public static final String LOGIN_PATH_PARAM = "org.eclipse.jetty.security.siwe.login_path";
    public static final String AUTHENTICATION_PATH_PARAM = "org.eclipse.jetty.security.siwe.authentication_path";
    public static final String NONCE_PATH_PARAM = "org.eclipse.jetty.security.siwe.nonce_path";
    public static final String LOGOUT_REDIRECT_PARAM = "org.eclipse.jetty.security.siwe.logout_redirect_path";
    public static final String ERROR_PATH_PARAM = "org.eclipse.jetty.security.siwe.error_path";
    public static final String ERROR_PARAMETER = "error_description_jetty";
    public static final String MAX_MESSAGE_SIZE_PARAM = "org.eclipse.jetty.security.siwe.max_message_size";
    public static final String DISPATCH_PARAM = "org.eclipse.jetty.security.siwe.dispatch";
    public static final String AUTHENTICATE_NEW_USERS_PARAM = "org.eclipse.jetty.security.siwe.authenticate_new_users";
    public static final String CHAIN_IDS_PARAM = "org.eclipse.jetty.security.siwe.chainIds";
    public static final String DOMAINS_PARAM = "org.eclipse.jetty.security.siwe.domains";
    private static final String J_URI = "org.eclipse.jetty.security.siwe.URI";
    private static final String J_POST = "org.eclipse.jetty.security.siwe.POST";
    private static final String J_METHOD = "org.eclipse.jetty.security.siwe.METHOD";
    private static final String DEFAULT_AUTHENTICATION_PATH = "/auth/login";
    private static final String DEFAULT_NONCE_PATH = "/auth/nonce";
    private static final String NONCE_SET_ATTR = "org.eclipse.jetty.security.siwe.nonce";
    private final IncludeExcludeSet<String, String> _chainIds = new IncludeExcludeSet();
    private final IncludeExcludeSet<String, String> _domains = new IncludeExcludeSet();
    private String _loginPath;
    private String _authenticationPath = "/auth/login";
    private String _noncePath = "/auth/nonce";
    private int _maxMessageSize = 4096;
    private String _logoutRedirectPath;
    private String _errorPath;
    private String _errorQuery;
    private boolean _dispatch;
    private boolean _authenticateNewUsers = true;

    public void includeDomains(String ... domains) {
        this._domains.include((Object[])domains);
    }

    public void includeChainIds(String ... chainIds) {
        this._chainIds.include((Object[])chainIds);
    }

    public void setConfiguration(Authenticator.Configuration authConfig) {
        String domains;
        String chainIds;
        String authenticateNewUsers;
        String dispatch;
        String error;
        String logout;
        String maxMessageSize;
        String noncePath;
        String authenticationPath;
        String loginPath = authConfig.getParameter(LOGIN_PATH_PARAM);
        if (loginPath != null) {
            this.setLoginPath(loginPath);
        }
        if ((authenticationPath = authConfig.getParameter(AUTHENTICATION_PATH_PARAM)) != null) {
            this.setAuthenticationPath(authenticationPath);
        }
        if ((noncePath = authConfig.getParameter(NONCE_PATH_PARAM)) != null) {
            this.setNoncePath(noncePath);
        }
        if ((maxMessageSize = authConfig.getParameter(MAX_MESSAGE_SIZE_PARAM)) != null) {
            this.setMaxMessageSize(Integer.parseInt(maxMessageSize));
        }
        if ((logout = authConfig.getParameter(LOGOUT_REDIRECT_PARAM)) != null) {
            this.setLogoutRedirectPath(logout);
        }
        if ((error = authConfig.getParameter(ERROR_PATH_PARAM)) != null) {
            this.setErrorPage(error);
        }
        if ((dispatch = authConfig.getParameter(DISPATCH_PARAM)) != null) {
            this.setDispatch(Boolean.parseBoolean(dispatch));
        }
        if ((authenticateNewUsers = authConfig.getParameter(AUTHENTICATE_NEW_USERS_PARAM)) != null) {
            this.setAuthenticateNewUsers(Boolean.parseBoolean(authenticateNewUsers));
        }
        if ((chainIds = authConfig.getParameter(CHAIN_IDS_PARAM)) != null) {
            this.includeChainIds(StringUtil.csvSplit((String)chainIds));
        }
        if ((domains = authConfig.getParameter(DOMAINS_PARAM)) != null) {
            this.includeDomains(StringUtil.csvSplit((String)domains));
        }
        if (this.isAuthenticateNewUsers()) {
            AnyUserLoginService loginService = new AnyUserLoginService(authConfig.getRealmName(), authConfig.getLoginService());
            authConfig = new Authenticator.Configuration.Wrapper(this, (Authenticator.Configuration)authConfig, (LoginService)loginService){
                final /* synthetic */ LoginService val$loginService;
                final /* synthetic */ EthereumAuthenticator this$0;
                {
                    this.val$loginService = loginService;
                    this.this$0 = this$0;
                    super(arg0);
                }

                public LoginService getLoginService() {
                    return this.val$loginService;
                }
            };
        }
        if (this._loginPath == null) {
            throw new IllegalStateException("No loginPath");
        }
        super.setConfiguration(authConfig);
    }

    public String getAuthenticationType() {
        return "SIWE";
    }

    public boolean isAuthenticateNewUsers() {
        return this._authenticateNewUsers;
    }

    public void setAuthenticateNewUsers(boolean authenticateNewUsers) {
        this._authenticateNewUsers = authenticateNewUsers;
    }

    public void setLoginPath(String loginPath) {
        if (loginPath == null) {
            LOG.warn("login path must not be null, defaulting to {}", (Object)this._loginPath);
            loginPath = this._loginPath;
        } else if (!((String)loginPath).startsWith("/")) {
            LOG.warn("login path must start with /");
            loginPath = "/" + (String)loginPath;
        }
        this._loginPath = loginPath;
    }

    public void setAuthenticationPath(String authenticationPath) {
        if (authenticationPath == null) {
            authenticationPath = this._authenticationPath;
            LOG.warn("authentication path must not be null, defaulting to {}", authenticationPath);
        } else if (!((String)authenticationPath).startsWith("/")) {
            authenticationPath = "/" + (String)authenticationPath;
            LOG.warn("authentication path must start with /");
        }
        this._authenticationPath = authenticationPath;
    }

    public void setNoncePath(String noncePath) {
        if (noncePath == null) {
            noncePath = this._noncePath;
            LOG.warn("nonce path must not be null, defaulting to {}", noncePath);
        } else if (!((String)noncePath).startsWith("/")) {
            noncePath = "/" + (String)noncePath;
            LOG.warn("nonce path must start with /");
        }
        this._noncePath = noncePath;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this._maxMessageSize = maxMessageSize;
    }

    public void setDispatch(boolean dispatch) {
        this._dispatch = dispatch;
    }

    public void setLogoutRedirectPath(String logoutRedirectPath) {
        if (logoutRedirectPath != null && !((String)logoutRedirectPath).startsWith("/")) {
            LOG.warn("logout redirect path must start with /");
            logoutRedirectPath = "/" + (String)logoutRedirectPath;
        }
        this._logoutRedirectPath = logoutRedirectPath;
    }

    public void setErrorPage(String path) {
        if (path == null || ((String)path).trim().isEmpty()) {
            this._errorPath = null;
        } else {
            if (!((String)path).startsWith("/")) {
                LOG.warn("error-page must start with /");
                path = "/" + (String)path;
            }
            this._errorPath = path;
            this._errorQuery = "";
            int queryIndex = this._errorPath.indexOf(63);
            if (queryIndex > 0) {
                this._errorPath = ((String)path).substring(0, queryIndex);
                this._errorQuery = ((String)path).substring(queryIndex + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserIdentity login(String username, Object credentials, Request request, Response response) {
        UserIdentity user;
        if (LOG.isDebugEnabled()) {
            LOG.debug("login {} {} {}", new Object[]{username, credentials, request});
        }
        if ((user = super.login(username, credentials, request, response)) != null) {
            Session session = request.getSession(true);
            SessionAuthentication cached = new SessionAuthentication(this.getAuthenticationType(), user, credentials);
            Session session2 = session;
            synchronized (session2) {
                session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
            }
        }
        return user;
    }

    public void logout(Request request, Response response) {
        this.attemptLogoutRedirect(request, response);
        this.logoutWithoutRedirect(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logoutWithoutRedirect(Request request, Response response) {
        super.logout(request, response);
        Session session = request.getSession(false);
        if (session == null) {
            return;
        }
        Session session2 = session;
        synchronized (session2) {
            session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
        }
    }

    private void attemptLogoutRedirect(Request request, Response response) {
        try {
            Session session;
            String redirectUri = null;
            if (this._logoutRedirectPath != null) {
                HttpURI.Mutable httpURI = HttpURI.build().scheme(request.getHttpURI().getScheme()).host(Request.getServerName((Request)request)).port(Request.getServerPort((Request)request)).path(URIUtil.compactPath((String)(Request.getContextPath((Request)request) + this._logoutRedirectPath)));
                redirectUri = httpURI.toString();
            }
            if ((session = request.getSession(false)) == null && redirectUri != null) {
                this.sendRedirect(request, response, redirectUri);
            }
        }
        catch (Throwable t) {
            LOG.warn("failed to redirect to end_session_endpoint", t);
        }
    }

    private void sendRedirect(Request request, Response response, String location) throws IOException {
        try (Blocker.Callback callback = Blocker.callback();){
            Response.sendRedirect((Request)request, (Response)response, (Callback)callback, (String)location);
            callback.block();
        }
    }

    public Request prepareRequest(Request request, AuthenticationState authenticationState) {
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            Session session = request.getSession(false);
            if (session == null) {
                return request;
            }
            session.removeAttribute(NONCE_SET_ATTR);
            HttpURI juri = (HttpURI)session.getAttribute(J_URI);
            HttpURI uri = request.getHttpURI();
            if (uri.equals((Object)juri)) {
                String method;
                session.removeAttribute(J_URI);
                Fields fields = (Fields)session.removeAttribute(J_POST);
                if (fields != null) {
                    request.setAttribute(FormFields.class.getName(), (Object)fields);
                }
                if ((method = (String)session.removeAttribute(J_METHOD)) != null && request.getMethod().equals(method)) {
                    return new Request.Wrapper(this, request){
                        final /* synthetic */ EthereumAuthenticator this$0;
                        {
                            this.this$0 = this$0;
                            super(arg0);
                        }

                        public String getMethod() {
                            return method;
                        }
                    };
                }
            }
        }
        return request;
    }

    public Constraint.Authorization getConstraintAuthentication(String pathInContext, Constraint.Authorization existing, Function<Boolean, Session> getSession) {
        if (this.isAuthenticationRequest(pathInContext)) {
            return Constraint.Authorization.ANY_USER;
        }
        if (this.isLoginPage(pathInContext) || this.isErrorPage(pathInContext)) {
            return Constraint.Authorization.ALLOWED;
        }
        if (this.isNonceRequest(pathInContext)) {
            return Constraint.Authorization.ANY_USER;
        }
        return existing;
    }

    protected String readMessage(InputStream in) throws IOException {
        int len;
        CharsetStringBuilder.Iso88591StringBuilder out = new CharsetStringBuilder.Iso88591StringBuilder();
        byte[] buffer = new byte[1024];
        int totalRead = 0;
        while ((len = in.read(buffer, 0, buffer.length)) >= 0) {
            if (this._maxMessageSize >= 0 && (totalRead += len) > this._maxMessageSize) {
                throw new BadMessageException("SIWE Message Too Large");
            }
            out.append(buffer, 0, len);
        }
        return out.build();
    }

    protected SignedMessage parseMessage(Request request, Response response, Callback callback) {
        try {
            String signature;
            InputStream inputStream = Content.Source.asInputStream((Content.Source)request);
            String requestContent = this.readMessage(inputStream);
            ByteBufferContentSource contentSource = new ByteBufferContentSource(new ByteBuffer[]{BufferUtil.toBuffer((String)requestContent)});
            String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
            MimeTypes.Type mimeType = MimeTypes.getBaseType((String)contentType);
            if (mimeType == null) {
                throw new ServerAuthException("Unsupported content type: " + contentType);
            }
            String message = switch (mimeType) {
                case MimeTypes.Type.FORM_ENCODED -> {
                    Fields fields = FormFields.getFields((Content.Source)contentSource, (Attributes)request, (Charset)FormFields.getFormEncodedCharset((Request)request), (int)10, (int)this._maxMessageSize);
                    signature = fields.get("signature").getValue();
                    yield fields.get("message").getValue();
                }
                case MimeTypes.Type.MULTIPART_FORM_DATA -> {
                    MultiPartConfig config = Request.getMultiPartConfig((Request)request, null).maxSize((long)this._maxMessageSize).maxParts(10).build();
                    MultiPartFormData.Parts parts = (MultiPartFormData.Parts)MultiPartFormData.from((Content.Source)contentSource, (Attributes)request, (String)contentType, (MultiPartConfig)config).get();
                    signature = parts.getFirst("signature").getContentAsString(StandardCharsets.ISO_8859_1);
                    yield parts.getFirst("message").getContentAsString(StandardCharsets.ISO_8859_1);
                }
                default -> throw new ServerAuthException("Unsupported mime type: " + String.valueOf(mimeType));
            };
            message = message.replace("\r\n", "\n");
            return new SignedMessage(message, signature);
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(t).log("error reading SIWE message and signature");
            }
            this.sendError(request, response, callback, t.getMessage());
            return null;
        }
    }

    protected AuthenticationState handleNonceRequest(Request request, Response response, Callback callback) {
        String nonce = this.createNonce(request.getSession(false));
        response.getHeaders().put(HttpHeader.CONTENT_TYPE, "application/json");
        ByteBuffer content = BufferUtil.toBuffer((String)("{ \"nonce\": \"" + nonce + "\" }"));
        response.write(true, content, callback);
        return AuthenticationState.CHALLENGE;
    }

    private AuthenticationState validateSignInWithEthereumToken(SignInWithEthereumToken siwe, SignedMessage signedMessage, Request request, Response response, Callback callback) {
        Session session = request.getSession(false);
        if (siwe == null) {
            return this.sendError(request, response, callback, "failed to parse SIWE message");
        }
        try {
            siwe.validate(signedMessage, nonce -> this.redeemNonce(session, (String)nonce), this._domains, this._chainIds);
        }
        catch (Throwable t) {
            return this.sendError(request, response, callback, t.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationState validateRequest(Request request, Response response, Callback callback) throws ServerAuthException {
        String uri;
        if (LOG.isDebugEnabled()) {
            LOG.debug("validateRequest({},{})", (Object)request, (Object)response);
        }
        if ((uri = request.getHttpURI().toString()) == null) {
            uri = "/";
        }
        try {
            Session session = request.getSession(false);
            if (session == null && (session = request.getSession(true)) == null) {
                return this.sendError(request, response, callback, "session could not be created");
            }
            if (this.isNonceRequest(uri)) {
                return this.handleNonceRequest(request, response, callback);
            }
            if (this.isAuthenticationRequest(uri)) {
                SignedMessage signedMessage;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("authentication request");
                }
                if ((signedMessage = this.parseMessage(request, response, callback)) == null) {
                    return this.sendError(request, response, callback, "failed to read SIWE message");
                }
                SignInWithEthereumToken siwe = SignInWithEthereumToken.from(signedMessage.message());
                if (siwe == null) {
                    return this.sendError(request, response, callback, "failed to parse SIWE message");
                }
                AuthenticationState authenticationState = this.validateSignInWithEthereumToken(siwe, signedMessage, request, response, callback);
                if (authenticationState != null) {
                    return authenticationState;
                }
                String address = siwe.address();
                UserIdentity user = this.login(address, null, request, response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("user identity: {}", (Object)user);
                }
                if (user != null) {
                    String originalURI;
                    HttpURI savedURI = (HttpURI)session.getAttribute(J_URI);
                    String string = originalURI = savedURI != null ? savedURI.getPathQuery() : Request.getContextPath((Request)request);
                    if (originalURI == null) {
                        originalURI = "/";
                    }
                    LoginAuthenticator.UserAuthenticationSent formAuth = new LoginAuthenticator.UserAuthenticationSent(this.getAuthenticationType(), user);
                    String redirectUrl = session.encodeURI(request, originalURI, true);
                    Response.sendRedirect((Request)request, (Response)response, (Callback)callback, (String)redirectUrl, (boolean)true);
                    return formAuth;
                }
                return this.sendError(request, response, callback, "auth failed");
            }
            AuthenticationState authenticationState = (AuthenticationState)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (authenticationState != null) {
                if (authenticationState instanceof AuthenticationState.Succeeded && this._loginService != null && !this._loginService.validate(((AuthenticationState.Succeeded)authenticationState).getUserIdentity())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("authentication revoked {}", (Object)authenticationState);
                    }
                    this.logoutWithoutRedirect(request, response);
                    return this.sendError(request, response, callback, "authentication revoked");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("authenticationState {}", (Object)authenticationState);
                }
                return authenticationState;
            }
            if (AuthenticationState.Deferred.isDeferred((Response)response)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("authentication deferred {}", (Object)session.getId());
                }
                return null;
            }
            Session siwe = session;
            synchronized (siwe) {
                if (session.getAttribute(J_URI) == null) {
                    HttpURI juri = request.getHttpURI();
                    session.setAttribute(J_URI, (Object)juri.asImmutable());
                    if (!HttpMethod.GET.is(request.getMethod())) {
                        session.setAttribute(J_METHOD, (Object)request.getMethod());
                    }
                    if (HttpMethod.POST.is(request.getMethod())) {
                        session.setAttribute(J_POST, (Object)this.getParameters(request));
                    }
                }
            }
            String loginPath = URIUtil.addPaths((String)request.getContext().getContextPath(), (String)this._loginPath);
            if (this._dispatch) {
                HttpURI.Mutable newUri = HttpURI.build((HttpURI)request.getHttpURI()).pathQuery(loginPath);
                return new AuthenticationState.ServeAs((HttpURI)newUri);
            }
            String redirectUri = session.encodeURI(request, loginPath, true);
            Response.sendRedirect((Request)request, (Response)response, (Callback)callback, (String)redirectUri, (boolean)true);
            return AuthenticationState.CHALLENGE;
        }
        catch (Throwable t) {
            throw new ServerAuthException(t);
        }
    }

    private AuthenticationState sendError(Request request, Response response, Callback callback, String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authentication FAILED: {}", (Object)message);
        }
        if (this._errorPath == null) {
            return AuthenticationState.writeError((Request)request, (Response)response, (Callback)callback, (int)403);
        }
        String contextPath = Request.getContextPath((Request)request);
        String redirectUri = URIUtil.addPaths((String)contextPath, (String)this._errorPath);
        if (message != null) {
            String query = URIUtil.addQueries((String)("error_description_jetty=" + UrlEncoded.encodeString((String)message)), (String)this._errorQuery);
            redirectUri = URIUtil.addPathQuery((String)URIUtil.addPaths((String)contextPath, (String)this._errorPath), (String)query);
        }
        int redirectCode = request.getConnectionMetaData().getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
        Response.sendRedirect((Request)request, (Response)response, (Callback)callback, (int)redirectCode, (String)redirectUri, (boolean)true);
        return AuthenticationState.SEND_FAILURE;
    }

    protected Fields getParameters(Request request) {
        try {
            Fields queryFields = Request.extractQueryParameters((Request)request);
            Fields formFields = (Fields)FormFields.from((Request)request).get();
            return Fields.combine((Fields)queryFields, (Fields)formFields);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLoginPage(String uri) {
        return this.matchURI(uri, this._loginPath);
    }

    public boolean isAuthenticationRequest(String uri) {
        return this.matchURI(uri, this._authenticationPath);
    }

    public boolean isNonceRequest(String uri) {
        return this.matchURI(uri, this._noncePath);
    }

    private boolean matchURI(String uri, String path) {
        int jsc = uri.indexOf(path);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + path.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    public boolean isErrorPage(String pathInContext) {
        if (this._errorPath == null) {
            return false;
        }
        return pathInContext != null && pathInContext.equals(this._errorPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createNonce(Session session) {
        String nonce = EthereumUtil.createNonce();
        Session session2 = session;
        synchronized (session2) {
            FixedSizeSet attribute = (FixedSizeSet)session.getAttribute(NONCE_SET_ATTR);
            if (attribute == null) {
                attribute = new FixedSizeSet(5);
                session.setAttribute(NONCE_SET_ATTR, attribute);
            }
            if (!attribute.add(nonce)) {
                throw new IllegalStateException("Nonce already in use");
            }
        }
        return nonce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean redeemNonce(Session session, String nonce) {
        Session session2 = session;
        synchronized (session2) {
            Set attribute = (Set)session.getAttribute(NONCE_SET_ATTR);
            if (attribute == null) {
                return false;
            }
            return attribute.remove(nonce);
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{"loginPath=" + this._loginPath, "authenticationPath=" + this._authenticationPath, "noncePath=" + this._noncePath, "errorPath=" + this._errorPath, "errorQuery=" + this._errorQuery, "dispatch=" + this._dispatch, "authenticateNewUsers=" + this._authenticateNewUsers, "logoutRedirectPath=" + this._logoutRedirectPath, "maxMessageSize=" + this._maxMessageSize, "chainIds=" + String.valueOf(this._chainIds), "domains=" + String.valueOf(this._domains)});
    }

    public record SignedMessage(String message, String signature) {
        public String recoverAddress() {
            return EthereumUtil.recoverAddress(this);
        }
    }

    public static class FixedSizeSet<T>
    extends LinkedHashSet<T> {
        private final int maxSize;

        public FixedSizeSet(int maxSize) {
            super(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        public boolean add(T element) {
            Iterator it;
            if (this.size() >= this.maxSize && (it = this.iterator()).hasNext()) {
                it.next();
                it.remove();
            }
            return super.add(element);
        }
    }
}

