/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.server;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EventListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.quic.common.SessionContainer;
import org.eclipse.jetty.quic.quiche.server.QuicheServerConnectionFactory;
import org.eclipse.jetty.quic.quiche.server.QuicheServerQuicConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DatagramServerConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

public class QuicheServerConnector
extends DatagramServerConnector {
    private final SessionContainer container = new SessionContainer();
    private final QuicheServerConnectionFactory connectionFactory;

    public QuicheServerConnector(Server server, SslContextFactory.Server sslContextFactory, QuicheServerQuicConfiguration quicConfiguration, ConnectionFactory ... factories) {
        this(server, null, null, null, sslContextFactory, quicConfiguration, factories);
    }

    public QuicheServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, SslContextFactory.Server sslContextFactory, QuicheServerQuicConfiguration quicConfiguration, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, factories);
        this.connectionFactory = new QuicheServerConnectionFactory(sslContextFactory, quicConfiguration);
    }

    public SslContextFactory.Server getSslContextFactory() {
        return this.connectionFactory.getSslContextFactory();
    }

    public QuicheServerQuicConfiguration getServerQuicConfiguration() {
        return this.connectionFactory.getServerQuicConfiguration();
    }

    public int getInputBufferSize() {
        return this.connectionFactory.getInputBufferSize();
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.connectionFactory.setInputBufferSize(inputBufferSize);
    }

    protected void doStart() throws Exception {
        this.addBean(this.container);
        this.addBean((Object)this.connectionFactory);
        this.connectionFactory.configure((Connector)this);
        QuicheServerQuicConfiguration quicConfiguration = this.connectionFactory.getServerQuicConfiguration();
        quicConfiguration.addEventListener((EventListener)this.container);
        quicConfiguration.setPemWorkDirectory(this.findPemWorkDirectory());
        super.doStart();
    }

    private Path findPemWorkDirectory() {
        Path pemWorkDirectory = this.getServerQuicConfiguration().getPemWorkDirectory();
        if (pemWorkDirectory != null) {
            return pemWorkDirectory;
        }
        String jettyBase = System.getProperty("jetty.base");
        if (jettyBase != null && Files.exists(pemWorkDirectory = Path.of(jettyBase, new String[0]).resolve("work"), new LinkOption[0])) {
            return pemWorkDirectory;
        }
        throw new IllegalStateException("No PEM work directory configured");
    }

    public ConnectionFactory getDefaultConnectionFactory() {
        return this.connectionFactory;
    }

    public CompletableFuture<Void> shutdown() {
        return ((CompletableFuture)this.container.shutdown().handleAsync((r, x) -> {
            CompletableFuture shutdown = super.shutdown();
            LifeCycle.stop((Object)((Object)this));
            return shutdown;
        }, this.getExecutor())).thenCompose(Function.identity());
    }
}

