/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.server.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.quiche.PemPaths;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.QuicheConnectionId;
import org.eclipse.jetty.quic.quiche.QuicheSession;
import org.eclipse.jetty.quic.quiche.server.QuicheServerQuicConfiguration;
import org.eclipse.jetty.quic.quiche.server.internal.ServerQuicheSession;
import org.eclipse.jetty.quic.quiche.server.internal.SimpleTokenMinter;
import org.eclipse.jetty.quic.quiche.server.internal.SimpleTokenValidator;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.strategy.AdaptiveExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerQuicheConnection
extends QuicheConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ServerQuicheConnection.class);
    private final ConcurrentMap<QuicheConnectionId, ServerQuicheSession> sessions = new ConcurrentHashMap<QuicheConnectionId, ServerQuicheSession>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Flusher flusher = new Flusher();
    private final Connector connector;
    private final SslContextFactory.Server sslContextFactory;
    private final QuicheServerQuicConfiguration quicConfiguration;
    private final Session.Listener.Factory sessionListenerFactory;
    private final SessionTimeouts sessionTimeouts;
    private final InetSocketAddress inetLocalAddress;
    private final AdaptiveExecutionStrategy strategy;

    public ServerQuicheConnection(Connector connector, SslContextFactory.Server sslContextFactory, QuicheServerQuicConfiguration quicConfiguration, EndPoint endPoint, Session.Listener.Factory sessionListenerFactory) {
        super(connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), endPoint);
        this.connector = connector;
        this.sslContextFactory = sslContextFactory;
        this.quicConfiguration = quicConfiguration;
        this.sessionListenerFactory = sessionListenerFactory;
        this.sessionTimeouts = new SessionTimeouts(connector.getScheduler());
        this.inetLocalAddress = Quiche.toInetSocketAddress((SocketAddress)endPoint.getLocalSocketAddress(), (boolean)false);
        this.strategy = new AdaptiveExecutionStrategy(this::produce, this.getExecutor());
    }

    public Connector getConnector() {
        return this.connector;
    }

    public QuicheServerQuicConfiguration getServerQuicConfiguration() {
        return this.quicConfiguration;
    }

    public Session.Listener.Factory getSessionListenerFactory() {
        return this.sessionListenerFactory;
    }

    public SslContextFactory.Server getSslContextFactory() {
        return this.sslContextFactory;
    }

    public void onOpen() {
        super.onOpen();
        LifeCycle.start((Object)this.strategy);
        this.fillInterested();
    }

    public void onClose(Throwable cause) {
        LifeCycle.stop((Object)this.strategy);
        super.onClose(cause);
    }

    public void onFillable() {
        this.strategy.produce();
    }

    private Runnable produce() {
        boolean interested = this.isFillInterested();
        if (LOG.isDebugEnabled()) {
            LOG.debug("produce() fillInterested={}", (Object)interested);
        }
        if (interested) {
            return null;
        }
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(this.getInputBufferSize(), this.quicConfiguration.isUseInputDirectByteBuffers());
        ByteBuffer cipherBuffer = buffer.getByteBuffer();
        try {
            Runnable task;
            while (true) {
                InetSocketAddress inetRemoteAddress;
                QuicheConnectionId quicheConnectionId;
                int fill;
                BufferUtil.clear((ByteBuffer)cipherBuffer);
                SocketAddress remoteAddress = this.getEndPoint().receive(cipherBuffer);
                int n = fill = remoteAddress == EndPoint.EOF ? -1 : cipherBuffer.remaining();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("filled cipher buffer with {} byte(s)", (Object)fill);
                }
                if (fill < 0) {
                    buffer.release();
                    this.getEndPoint().shutdownOutput();
                    return null;
                }
                if (fill == 0) {
                    buffer.release();
                    this.fillInterested();
                    return null;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("peer ip address: {}, ciphertext packet size: {}", (Object)remoteAddress, (Object)cipherBuffer.remaining());
                }
                if ((quicheConnectionId = QuicheConnectionId.fromPacket((ByteBuffer)cipherBuffer)) == null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("packet contains undecipherable connection id, dropping it");
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("packet contains connection id {}", (Object)quicheConnectionId);
                }
                if ((task = this.process(quicheConnectionId, inetRemoteAddress = Quiche.toInetSocketAddress((SocketAddress)remoteAddress, (boolean)true), cipherBuffer)) != null) break;
            }
            buffer.release();
            return task;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("produce() failure");
            }
            buffer.release();
            this.fail(x);
            return null;
        }
    }

    private Runnable process(QuicheConnectionId connectionId, SocketAddress remoteAddress, ByteBuffer cipherBuffer) throws IOException {
        ServerQuicheSession session = (ServerQuicheSession)((Object)this.sessions.get(connectionId));
        if (session == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("packet for new session for connection id {}", (Object)connectionId);
            }
            if ((session = this.createSession(remoteAddress, cipherBuffer)) != null) {
                session.setConnectionId(connectionId);
                session.setIdleTimeout(this.getEndPoint().getIdleTimeout());
                LifeCycle.start((Object)((Object)session));
                this.sessions.put(connectionId, session);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("session created for connection id {}: {}", (Object)connectionId, (Object)session);
                }
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("session not created for connection id {}", (Object)connectionId);
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("packet for session, processing {} bytes on {}", (Object)cipherBuffer.remaining(), (Object)session);
        }
        return session.process(remoteAddress, cipherBuffer);
    }

    private ServerQuicheSession createSession(SocketAddress remoteAddress, ByteBuffer cipherBuffer) throws IOException {
        InetSocketAddress inetRemoteAddress = (InetSocketAddress)remoteAddress;
        Quiche quiche = Quiche.tryAccept((QuicheConfig)this.newQuicheConfig(), (Quiche.TokenValidator)new SimpleTokenValidator(inetRemoteAddress), (ByteBuffer)cipherBuffer, (SocketAddress)this.inetLocalAddress, (SocketAddress)inetRemoteAddress);
        if (quiche == null) {
            RetainableByteBuffer.Mutable negotiationBuffer = this.getByteBufferPool().acquire(this.quicConfiguration.getOutputBufferSize(), this.quicConfiguration.isUseOutputDirectByteBuffers());
            ByteBuffer byteBuffer = negotiationBuffer.getByteBuffer();
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            if (!Quiche.negotiate((Quiche.TokenMinter)new SimpleTokenMinter(inetRemoteAddress), (ByteBuffer)cipherBuffer, (ByteBuffer)byteBuffer)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connection negotiation failed, dropping packet");
                }
                negotiationBuffer.release();
                return null;
            }
            BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
            this.write(Callback.from(() -> ((RetainableByteBuffer)negotiationBuffer).release()), remoteAddress, byteBuffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("connection negotiation packet sent");
            }
            return null;
        }
        ServerQuicheSession session = this.newServerQuicheSession(quiche, remoteAddress);
        session.flush();
        return session;
    }

    public void write(Callback callback, SocketAddress remoteAddress, ByteBuffer ... buffers) {
        this.flusher.offer(callback, remoteAddress, buffers);
        this.flusher.iterate();
    }

    protected ServerQuicheSession newServerQuicheSession(Quiche quiche, SocketAddress remoteAddress) {
        Session.Listener listener = this.sessionListenerFactory.newListener();
        InetSocketAddress inetLocalSocketAddress = Quiche.toInetSocketAddress((SocketAddress)this.getEndPoint().getLocalSocketAddress(), (boolean)false);
        return new ServerQuicheSession(this.connector, this.quicConfiguration, quiche, this, inetLocalSocketAddress, remoteAddress, listener);
    }

    private QuicheConfig newQuicheConfig() {
        QuicheConfig quicheConfig = new QuicheConfig();
        PemPaths pemPaths = (PemPaths)this.quicConfiguration.getImplementationConfiguration().get(this.sslContextFactory);
        quicheConfig.setPrivKeyPemPath(pemPaths.privateKeyPemPath().toString());
        quicheConfig.setCertChainPemPath(pemPaths.certificateChainPemPath().toString());
        Path trustedCertificatesPemPath = pemPaths.trustedCertificatesPemPath();
        if (trustedCertificatesPemPath != null) {
            quicheConfig.setTrustedCertsPemPath(trustedCertificatesPemPath.toString());
        }
        quicheConfig.setVerifyPeer(Boolean.valueOf(this.sslContextFactory.getNeedClientAuth() || this.sslContextFactory.getWantClientAuth()));
        quicheConfig.setMaxIdleTimeout(Long.valueOf(0L));
        quicheConfig.setInitialMaxData(Long.valueOf(this.quicConfiguration.getSessionMaxData()));
        quicheConfig.setInitialMaxStreamDataBidiLocal(Long.valueOf(this.quicConfiguration.getLocalBidirectionalStreamMaxData()));
        quicheConfig.setInitialMaxStreamDataBidiRemote(Long.valueOf(this.quicConfiguration.getRemoteBidirectionalStreamMaxData()));
        quicheConfig.setInitialMaxStreamDataUni(Long.valueOf(this.quicConfiguration.getUnidirectionalStreamMaxData()));
        quicheConfig.setInitialMaxStreamsUni(Long.valueOf(this.quicConfiguration.getUnidirectionalMaxStreams()));
        quicheConfig.setInitialMaxStreamsBidi(Long.valueOf(this.quicConfiguration.getBidirectionalMaxStreams()));
        quicheConfig.setCongestionControl(QuicheConfig.CongestionControl.CUBIC);
        List protocols = this.connector.getProtocols();
        protocols.add(0, "http/0.9");
        quicheConfig.setApplicationProtos((String[])protocols.toArray(String[]::new));
        return quicheConfig;
    }

    public void schedule(ServerQuicheSession session) {
        this.sessionTimeouts.schedule(session);
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        return false;
    }

    public void close() {
        try (Blocker.Promise promise = Blocker.promise();){
            this.close(new ConnectionCloseFrame(ErrorCode.NO_ERROR.code(), "close"), (Promise.Invocable<Void>)promise);
            promise.block();
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    private void close(ConnectionCloseFrame frame, Promise.Invocable<Void> promise) {
        if (!this.closed.compareAndSet(false, true)) {
            promise.succeeded(null);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("closing connection {}", (Object)this);
        }
        ArrayList closes = new ArrayList();
        for (ServerQuicheSession session : this.sessions.values()) {
            CompletableFuture completable = new CompletableFuture();
            session.close(frame, Promise.Invocable.toPromise(completable));
            closes.add(completable);
        }
        CompletableFuture.allOf((CompletableFuture[])closes.toArray(CompletableFuture[]::new)).whenComplete(Promise.Invocable.toBiConsumer(promise));
    }

    public void disconnect(QuicheSession session, ConnectionCloseFrame frame, Throwable failure) {
        QuicheConnectionId connectionId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("disconnect {} {} on {}", new Object[]{frame, session, this});
        }
        if ((connectionId = session.getConnectionId()) != null) {
            this.sessions.remove(connectionId);
        }
    }

    private void fail(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(failure).log("failing connection {}", (Object)this);
        }
        ConnectionCloseFrame frame = new ConnectionCloseFrame(ErrorCode.INTERNAL_ERROR.code(), "failure");
        for (ServerQuicheSession session : this.sessions.values()) {
            session.disconnect(frame, failure, Promise.Invocable.noop());
        }
    }

    private class Flusher
    extends IteratingCallback {
        private final AutoLock lock = new AutoLock();
        private final ArrayDeque<Entry> queue = new ArrayDeque();
        private Entry entry;

        private Flusher() {
        }

        private void offer(Callback callback, SocketAddress address, ByteBuffer[] buffers) {
            try (AutoLock ignored = this.lock.lock();){
                this.queue.offer(new Entry(callback, address, buffers));
            }
        }

        protected IteratingCallback.Action process() {
            try (AutoLock ignored = this.lock.lock();){
                this.entry = this.queue.poll();
            }
            if (this.entry == null) {
                return IteratingCallback.Action.IDLE;
            }
            ServerQuicheConnection.this.getEndPoint().write((Callback)this, this.entry.address, this.entry.buffers);
            return IteratingCallback.Action.SCHEDULED;
        }

        protected void onSuccess() {
            this.entry.callback.succeeded();
        }

        protected void onCompleteFailure(Throwable failure) {
            this.entry.callback.failed(failure);
            ServerQuicheConnection.this.fail(failure);
        }

        public Invocable.InvocationType getInvocationType() {
            if (this.entry == null) {
                return Invocable.InvocationType.NON_BLOCKING;
            }
            return this.entry.callback.getInvocationType();
        }

        private record Entry(Callback callback, SocketAddress address, ByteBuffer[] buffers) {
        }
    }

    private class SessionTimeouts
    extends CyclicTimeouts<ServerQuicheSession> {
        private SessionTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        protected Iterator<ServerQuicheSession> iterator() {
            return ServerQuicheConnection.this.sessions.values().iterator();
        }

        protected boolean onExpired(ServerQuicheSession session) {
            session.onIdleTimeout(new TimeoutException("Idle timeout " + session.getIdleTimeout() + " ms elapsed"));
            return false;
        }
    }
}

