/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.server.internal;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.common.StreamId;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.QuicheSession;
import org.eclipse.jetty.quic.quiche.server.QuicheServerQuicConfiguration;
import org.eclipse.jetty.quic.quiche.server.internal.ServerQuicheConnection;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerQuicheSession
extends QuicheSession
implements CyclicTimeouts.Expirable {
    private static final Logger LOG = LoggerFactory.getLogger(ServerQuicheSession.class);
    private final StreamsProducerTask producer = new StreamsProducerTask();
    private final AtomicLong streamIds = new AtomicLong();
    private long expireNanoTime = Long.MAX_VALUE;
    private SocketAddress remoteAddress;

    public ServerQuicheSession(Connector connector, QuicheServerQuicConfiguration configuration, Quiche quiche, ServerQuicheConnection connection, SocketAddress localAddress, SocketAddress remoteAddress, Session.Listener listener) {
        super(connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), (QuicConfiguration)configuration, quiche, (QuicheConnection)connection, localAddress, remoteAddress, listener);
    }

    public QuicheServerQuicConfiguration getQuicConfiguration() {
        return (QuicheServerQuicConfiguration)super.getQuicConfiguration();
    }

    protected ServerQuicheConnection getConnection() {
        return (ServerQuicheConnection)super.getConnection();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.remoteAddress;
    }

    public void setIdleTimeout(long idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        this.notIdle();
        this.getConnection().schedule(this);
    }

    public boolean onIdleTimeout(TimeoutException timeout) {
        boolean result = super.onIdleTimeout(timeout);
        if (!result) {
            this.notIdle();
        }
        return result;
    }

    public long newStreamId(boolean bidirectional) {
        return StreamId.newStreamId((long)this.streamIds.getAndIncrement(), (boolean)bidirectional, (boolean)false);
    }

    public long getExpireNanoTime() {
        return this.expireNanoTime;
    }

    Runnable process(SocketAddress remoteAddress, ByteBuffer cipherBuffer) {
        try {
            this.feed(remoteAddress, cipherBuffer);
            if (this.isConnectionEstablished()) {
                if (!this.isOpen()) {
                    if (!this.validateConnection()) {
                        return null;
                    }
                    this.open();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("opened {}", (Object)this);
                    }
                }
                return this.getProducerTask();
            }
            this.flush();
            return null;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("process failure for {}", (Object)this);
            }
            ConnectionCloseFrame frame = new ConnectionCloseFrame(ErrorCode.CONNECTION_REFUSED_ERROR.code(), "session_failure");
            this.disconnect(frame, x, Promise.Invocable.noop());
            return null;
        }
    }

    private boolean validateConnection() {
        if (this.getConnection().getSslContextFactory().getNeedClientAuth() && this.getPeerCertificates() == null) {
            ConnectionCloseFrame frame = new ConnectionCloseFrame(ErrorCode.CONNECTION_REFUSED_ERROR.code(), "missing_peer_certificates");
            this.disconnect(frame, new SSLHandshakeException(frame.getReason()), Promise.Invocable.noop());
            return false;
        }
        return true;
    }

    public void feed(SocketAddress remoteAddress, ByteBuffer cipherBuffer) throws IOException {
        this.remoteAddress = remoteAddress;
        this.notIdle();
        super.feed(remoteAddress, cipherBuffer);
    }

    Runnable getProducerTask() {
        return this.producer;
    }

    public void flush() {
        this.notIdle();
        super.flush();
    }

    private void notIdle() {
        this.expireNanoTime = CyclicTimeouts.Expirable.calcExpireNanoTime((long)this.getIdleTimeout());
    }

    private class StreamsProducerTask
    extends Invocable.Task.Abstract {
        private StreamsProducerTask() {
            super(Invocable.InvocationType.EITHER);
        }

        public void run() {
            ServerQuicheSession.this.produce();
        }

        public String toString() {
            return "%s@%x".formatted(TypeUtil.toShortName(((Object)((Object)this)).getClass()), ((Object)((Object)this)).hashCode());
        }
    }
}

