/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.http3.qpack.QpackException;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstructionStreamConnection
extends AbstractConnection.NonBlocking
implements Connection.UpgradeTo {
    private static final Logger LOG = LoggerFactory.getLogger(InstructionStreamConnection.class);
    private final ByteBufferPool bufferPool;
    private final ParserListener listener;
    private boolean useInputDirectByteBuffers = true;
    private RetainableByteBuffer buffer;

    public InstructionStreamConnection(EndPoint endPoint, Executor executor, ByteBufferPool bufferPool, ParserListener listener) {
        super(endPoint, executor);
        this.bufferPool = bufferPool;
        this.listener = listener;
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public void onUpgradeTo(ByteBuffer upgrade) {
        int capacity = Math.max(upgrade.remaining(), this.getInputBufferSize());
        this.buffer = this.bufferPool.acquire(capacity, this.isUseInputDirectByteBuffers());
        ByteBuffer byteBuffer = this.buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        byteBuffer.put(upgrade);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
    }

    public void onOpen() {
        super.onOpen();
        if (this.buffer != null && this.buffer.hasRemaining()) {
            this.onFillable();
        } else {
            this.fillInterested();
        }
    }

    public void onFillable() {
        block6: {
            try {
                int filled;
                if (this.buffer == null) {
                    this.buffer = this.bufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
                }
                ByteBuffer byteBuffer = this.buffer.getByteBuffer();
                do {
                    this.parseInstruction(byteBuffer);
                    filled = this.getEndPoint().fill(byteBuffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("filled {} on {}", (Object)filled, (Object)this);
                    }
                    if (filled != 0) continue;
                    this.buffer.release();
                    this.buffer = null;
                    this.fillInterested();
                    break block6;
                } while (filled >= 0);
                this.buffer.release();
                this.buffer = null;
                this.getEndPoint().close();
            }
            catch (QpackException.SessionException x) {
                this.fail(x.getErrorCode(), x.getMessage(), x);
            }
            catch (Throwable x) {
                this.fail(HTTP3ErrorCode.INTERNAL_ERROR.code(), "internal_error", x);
            }
        }
    }

    private void fail(long errorCode, String message, Throwable failure) {
        this.buffer.release();
        this.buffer = null;
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(failure).log("could not process instruction stream {}", (Object)this.getEndPoint());
        }
        this.notifySessionFailure(errorCode, message, failure);
    }

    protected void notifySessionFailure(long error, String reason, Throwable failure) {
        try {
            this.listener.onSessionFailure(error, reason, failure);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    protected abstract void parseInstruction(ByteBuffer var1) throws QpackException;
}

