/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.transport.internal;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConnection;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.IConnection;
import org.eclipse.jetty.client.transport.SendFailure;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpChannelOverFCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.parser.ClientParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionOverFCGI
extends AbstractConnection
implements IConnection,
Attachable,
Invocable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnectionOverFCGI.class);
    private final Callback fillableCallback = new FillableCallback();
    private final ByteBufferPool networkByteBufferPool;
    private final AtomicInteger requests = new AtomicInteger();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final HttpDestination destination;
    private final Promise<Connection> promise;
    private final Flusher flusher;
    private final Delegate delegate;
    private final ClientParser parser;
    private final HttpChannelOverFCGI channel;
    private final Invocable.InvocationType invocationType;
    private RetainableByteBuffer networkBuffer;
    private Object attachment;
    private State state = State.STATUS;
    private long idleTimeout;
    private boolean shutdown;

    public HttpConnectionOverFCGI(EndPoint endPoint, Destination destination, Promise<Connection> promise) {
        super(endPoint, destination.getHttpClient().getExecutor());
        this.destination = (HttpDestination)destination;
        this.promise = promise;
        this.flusher = new Flusher(endPoint);
        this.delegate = new Delegate(destination);
        this.parser = new ClientParser(new ResponseListener());
        this.channel = this.newHttpChannel();
        HttpClient client = destination.getHttpClient();
        this.networkByteBufferPool = client.getByteBufferPool();
        this.invocationType = client.getHttpClientTransport().getInvocationType();
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    public Invocable.InvocationType getInvocationType() {
        return this.invocationType;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.delegate.getRemoteSocketAddress();
    }

    public EndPoint.SslSessionData getSslSessionData() {
        return this.delegate.getSslSessionData();
    }

    protected Flusher getFlusher() {
        return this.flusher;
    }

    public void send(Request request, Response.CompleteListener listener) {
        this.delegate.send(request, listener);
    }

    public SendFailure send(HttpExchange exchange) {
        return this.delegate.send(exchange);
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
        this.promise.succeeded((Object)this);
    }

    public void fillInterested() {
        this.fillInterested(this.fillableCallback);
    }

    public void onFillable() {
        this.channel.receive();
    }

    private void reacquireNetworkBuffer() {
        if (this.networkBuffer == null) {
            throw new IllegalStateException();
        }
        if (this.networkBuffer.hasRemaining()) {
            throw new IllegalStateException();
        }
        this.networkBuffer.release();
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reacquired {}", (Object)this.networkBuffer);
        }
    }

    private RetainableByteBuffer newNetworkBuffer() {
        HttpClient client = this.destination.getHttpClient();
        return this.networkByteBufferPool.acquire(client.getResponseBufferSize(), client.isUseInputDirectByteBuffers());
    }

    private void releaseNetworkBuffer() {
        if (this.networkBuffer == null) {
            throw new IllegalStateException();
        }
        if (this.networkBuffer.hasRemaining()) {
            throw new IllegalStateException();
        }
        this.networkBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", (Object)this.networkBuffer);
        }
        this.networkBuffer = null;
    }

    private void disposeNetworkBuffer() {
        if (this.networkBuffer == null) {
            return;
        }
        this.networkBuffer.clear();
        this.networkBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disposed {}", (Object)this.networkBuffer);
        }
        this.networkBuffer = null;
    }

    boolean parseAndFill(boolean notifyContentAvailable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parseAndFill {}", (Object)this.networkBuffer);
        }
        if (this.networkBuffer == null) {
            this.networkBuffer = this.newNetworkBuffer();
        }
        EndPoint endPoint = this.getEndPoint();
        try {
            int read;
            do {
                if (this.parse(this.networkBuffer.getByteBuffer(), notifyContentAvailable)) {
                    return false;
                }
                if (this.networkBuffer == null) {
                    return false;
                }
                if (this.networkBuffer.isRetained()) {
                    this.reacquireNetworkBuffer();
                }
                read = endPoint.fill(this.networkBuffer.getByteBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes from {}", (Object)read, (Object)endPoint);
                }
                if (read != 0) continue;
                this.releaseNetworkBuffer();
                return true;
            } while (read >= 0);
            this.releaseNetworkBuffer();
            this.shutdown();
            return false;
        }
        catch (Exception x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause((Throwable)x).log("Unable to fill from endpoint {}", (Object)endPoint);
            }
            this.close(x);
            return false;
        }
    }

    private boolean parse(ByteBuffer buffer, boolean notifyContentAvailable) {
        boolean handle = this.parser.parse(buffer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parse state={} result={} {} {} on {}", new Object[]{this.state, handle, BufferUtil.toDetailString((ByteBuffer)buffer), this.parser, this});
        }
        if (!handle) {
            return false;
        }
        switch (this.state.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.channel.responseHeaders();
                break;
            }
            case 2: {
                if (!notifyContentAvailable) break;
                this.channel.responseContentAvailable();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state " + String.valueOf((Object)this.state));
            }
        }
        return true;
    }

    boolean isComplete() {
        return this.state == State.COMPLETE;
    }

    void complete() {
        this.channel.responseSuccess();
    }

    private void shutdown() {
        this.shutdown = true;
        if (!this.parser.eof()) {
            this.channel.eof();
        }
    }

    boolean isShutdown() {
        return this.shutdown;
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        long idleTimeout = this.getEndPoint().getIdleTimeout();
        boolean close = this.delegate.onIdleTimeout(idleTimeout, timeoutException);
        if (close) {
            this.close(timeoutException);
        }
        return false;
    }

    protected void release() {
        this.getEndPoint().setIdleTimeout(this.idleTimeout);
        this.destination.release((Connection)this);
    }

    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().remove((Connection)this);
            this.abort(failure);
            this.channel.destroy();
            this.delegate.destroy();
            this.disposeNetworkBuffer();
            this.getEndPoint().shutdownOutput();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown {}", (Object)this);
            }
            this.getEndPoint().close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed {}", (Object)this);
            }
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    protected boolean isCloseByHTTP(HttpFields fields) {
        return fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
    }

    protected void abort(Throwable failure) {
        HttpExchange exchange = this.channel.getHttpExchange();
        if (exchange != null) {
            exchange.getRequest().abort(failure);
        }
    }

    private void failAndClose(Throwable failure) {
        this.channel.responseFailure(failure, (Promise<Boolean>)Promise.from(failed -> {
            if (failed.booleanValue()) {
                this.close(failure);
            }
        }, x -> this.close(failure)));
    }

    protected HttpChannelOverFCGI newHttpChannel() {
        return new HttpChannelOverFCGI(this);
    }

    public String toConnectionString() {
        return String.format("%s@%x[l:%s<->r:%s]", TypeUtil.toShortName(((Object)((Object)this)).getClass()), ((Object)((Object)this)).hashCode(), this.getEndPoint().getLocalSocketAddress(), this.getEndPoint().getRemoteSocketAddress());
    }

    private class FillableCallback
    implements Callback {
        private FillableCallback() {
        }

        public void succeeded() {
            HttpConnectionOverFCGI.this.onFillable();
        }

        public void failed(Throwable failure) {
            HttpConnectionOverFCGI.this.onFillInterestedFailed(failure);
        }

        public Invocable.InvocationType getInvocationType() {
            return HttpConnectionOverFCGI.this.getInvocationType();
        }
    }

    private static enum State {
        STATUS,
        HEADERS,
        CONTENT,
        COMPLETE;

    }

    private class Delegate
    extends HttpConnection {
        private Delegate(Destination destination) {
            super((HttpDestination)destination);
        }

        protected Iterator<HttpChannel> getHttpChannels() {
            return Collections.singleton(HttpConnectionOverFCGI.this.channel).iterator();
        }

        public SocketAddress getLocalSocketAddress() {
            return HttpConnectionOverFCGI.this.getEndPoint().getLocalSocketAddress();
        }

        public SocketAddress getRemoteSocketAddress() {
            return HttpConnectionOverFCGI.this.getEndPoint().getRemoteSocketAddress();
        }

        public EndPoint.SslSessionData getSslSessionData() {
            return HttpConnectionOverFCGI.this.getEndPoint().getSslSessionData();
        }

        public SendFailure send(HttpExchange exchange) {
            HttpRequest request = exchange.getRequest();
            this.normalizeRequest(request);
            EndPoint endPoint = HttpConnectionOverFCGI.this.getEndPoint();
            HttpConnectionOverFCGI.this.idleTimeout = endPoint.getIdleTimeout();
            long requestIdleTimeout = request.getIdleTimeout();
            if (requestIdleTimeout >= 0L) {
                endPoint.setIdleTimeout(requestIdleTimeout);
            }
            HttpConnectionOverFCGI.this.channel.setRequest(HttpConnectionOverFCGI.this.requests.incrementAndGet());
            return this.send(HttpConnectionOverFCGI.this.channel, exchange);
        }

        public void close() {
            HttpConnectionOverFCGI.this.close();
        }

        public boolean isClosed() {
            return HttpConnectionOverFCGI.this.isClosed();
        }

        public String toString() {
            return HttpConnectionOverFCGI.this.toString();
        }
    }

    private class ResponseListener
    implements ClientParser.Listener {
        private ResponseListener() {
        }

        @Override
        public void onBegin(int request, int code, String reason) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onBegin r={},c={},reason={}", new Object[]{request, code, reason});
            }
            HttpConnectionOverFCGI.this.state = State.STATUS;
            HttpConnectionOverFCGI.this.channel.responseBegin(code, reason);
        }

        @Override
        public void onHeader(int request, HttpField field) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onHeader r={},f={}", (Object)request, (Object)field);
            }
            HttpConnectionOverFCGI.this.channel.responseHeader(field);
        }

        @Override
        public boolean onHeaders(int request) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onHeaders r={} {}", (Object)request, (Object)HttpConnectionOverFCGI.this.networkBuffer);
            }
            HttpConnectionOverFCGI.this.state = State.HEADERS;
            return true;
        }

        @Override
        public boolean onContent(int request, FCGI.StreamType stream, ByteBuffer buffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onContent r={},t={},b={} {}", new Object[]{request, stream, BufferUtil.toDetailString((ByteBuffer)buffer), HttpConnectionOverFCGI.this.networkBuffer});
            }
            switch (stream) {
                case STD_OUT: {
                    Content.Chunk chunk = Content.Chunk.asChunk((ByteBuffer)buffer, (boolean)false, (Retainable)HttpConnectionOverFCGI.this.networkBuffer);
                    HttpConnectionOverFCGI.this.channel.content(chunk);
                    HttpConnectionOverFCGI.this.state = State.CONTENT;
                    return true;
                }
                case STD_ERR: {
                    LOG.info(BufferUtil.toUTF8String((ByteBuffer)buffer));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return false;
        }

        @Override
        public boolean onEnd(int request) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onEnd r={}", (Object)request);
            }
            HttpConnectionOverFCGI.this.channel.end();
            HttpConnectionOverFCGI.this.state = State.COMPLETE;
            return true;
        }

        @Override
        public void onFailure(int request, Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(failure).log("onFailure request={}", (Object)request);
            }
            HttpConnectionOverFCGI.this.failAndClose(failure);
        }
    }
}

