/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.io.EOFException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.ClientParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.fcgi.parser.StreamContentParser;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseContentParser
extends StreamContentParser {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseContentParser.class);
    private final ResponseParser parser;

    public ResponseContentParser(HeaderParser headerParser, ClientParser.Listener listener) {
        super(headerParser, FCGI.StreamType.STD_OUT, listener);
        this.parser = new ResponseParser(listener);
    }

    @Override
    public boolean noContent() {
        return false;
    }

    @Override
    protected boolean onContent(ByteBuffer buffer) {
        return this.parser.parse(buffer);
    }

    @Override
    protected void end(int request) {
        super.end(request);
        this.parser.reset();
    }

    private class ResponseParser
    implements HttpParser.ResponseHandler {
        private final HttpFields.Mutable fields = HttpFields.build();
        private final ClientParser.Listener listener;
        private final FCGIHttpParser httpParser;
        private State state = State.HEADERS;
        private boolean seenResponseCode;
        private boolean stalled;

        private ResponseParser(ClientParser.Listener listener) {
            this.listener = listener;
            this.httpParser = new FCGIHttpParser(this);
        }

        private void reset() {
            this.fields.clear();
            this.httpParser.reset();
            this.state = State.HEADERS;
            this.seenResponseCode = false;
            this.stalled = false;
        }

        public boolean parse(ByteBuffer buffer) {
            int remaining = buffer.remaining();
            block6: while (remaining > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response {} {}, state {} {}", new Object[]{ResponseContentParser.this.getRequest(), FCGI.StreamType.STD_OUT, this.state, BufferUtil.toDetailString((ByteBuffer)buffer)});
                }
                switch (this.state.ordinal()) {
                    case 0: {
                        if (this.httpParser.parseNext(buffer)) {
                            this.state = State.CONTENT_MODE;
                            if (this.stalled) {
                                return true;
                            }
                        }
                        remaining = buffer.remaining();
                        continue block6;
                    }
                    case 1: {
                        boolean rawContent = this.fields.size() == 0 || this.fields.get(HttpHeader.CONTENT_LENGTH) == null && this.fields.get(HttpHeader.TRANSFER_ENCODING) == null;
                        this.state = rawContent ? State.RAW_CONTENT : State.HTTP_CONTENT;
                        continue block6;
                    }
                    case 2: {
                        ByteBuffer content = buffer.asReadOnlyBuffer();
                        buffer.position(buffer.limit());
                        if (this.notifyContent(content)) {
                            return true;
                        }
                        remaining = 0;
                        continue block6;
                    }
                    case 3: {
                        if (this.httpParser.parseNext(buffer)) {
                            return true;
                        }
                        remaining = buffer.remaining();
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
            return false;
        }

        public void startResponse(HttpVersion version, int status, String reason) {
            throw new IllegalStateException();
        }

        public void parsedHeader(HttpField httpField) {
            block6: {
                try {
                    String name = httpField.getName();
                    if ("Status".equalsIgnoreCase(name)) {
                        if (!this.seenResponseCode) {
                            this.seenResponseCode = true;
                            String value = httpField.getValue();
                            String[] parts = value.split(" ");
                            String status = parts[0];
                            int code = Integer.parseInt(status);
                            this.httpParser.setResponseStatus(code);
                            String reason = parts.length > 1 ? value.substring(status.length()) : HttpStatus.getMessage((int)code);
                            this.notifyBegin(code, reason.trim());
                            this.notifyHeaders((HttpFields)this.fields);
                        }
                    } else {
                        this.fields.add(httpField);
                        if (this.seenResponseCode) {
                            this.notifyHeader(httpField);
                        }
                    }
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.atDebug().setCause(x).log("Exception while invoking listener {}", (Object)this.listener);
                }
            }
        }

        private void notifyBegin(int code, String reason) {
            block2: {
                try {
                    this.listener.onBegin(ResponseContentParser.this.getRequest(), code, reason);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("Exception while invoking listener {}", (Object)this.listener);
                }
            }
        }

        private void notifyHeader(HttpField httpField) {
            block2: {
                try {
                    this.listener.onHeader(ResponseContentParser.this.getRequest(), httpField);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("Exception while invoking listener {}", (Object)this.listener);
                }
            }
        }

        private void notifyHeaders(HttpFields fields) {
            if (fields != null) {
                for (HttpField field : fields) {
                    this.notifyHeader(field);
                }
            }
        }

        private boolean notifyHeaders() {
            try {
                return this.listener.onHeaders(ResponseContentParser.this.getRequest());
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(x).log("Exception while invoking listener {}", (Object)this.listener);
                }
                return false;
            }
        }

        public boolean headerComplete() {
            if (!this.seenResponseCode) {
                this.notifyBegin(200, "OK");
                this.notifyHeaders((HttpFields)this.fields);
            }
            this.stalled = this.notifyHeaders();
            return true;
        }

        public boolean content(ByteBuffer buffer) {
            return this.notifyContent(buffer);
        }

        private boolean notifyContent(ByteBuffer buffer) {
            try {
                return this.listener.onContent(ResponseContentParser.this.getRequest(), FCGI.StreamType.STD_OUT, buffer);
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(x).log("Exception while invoking listener {}", (Object)this.listener);
                }
                return false;
            }
        }

        public boolean contentComplete() {
            return false;
        }

        public boolean messageComplete() {
            return false;
        }

        public void earlyEOF() {
            this.fail(new EOFException());
        }

        public void badMessage(HttpException failure) {
            this.fail((Throwable)failure);
        }

        protected void fail(Throwable failure) {
            block2: {
                try {
                    this.listener.onFailure(ResponseContentParser.this.getRequest(), failure);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("Exception while invoking listener {}", (Object)this.listener);
                }
            }
        }
    }

    private static enum State {
        HEADERS,
        CONTENT_MODE,
        RAW_CONTENT,
        HTTP_CONTENT;

    }

    private static class FCGIHttpParser
    extends HttpParser {
        private FCGIHttpParser(HttpParser.ResponseHandler handler) {
            super(handler, 66560, HttpCompliance.RFC7230);
            this.reset();
        }

        public void reset() {
            super.reset();
            this.setResponseStatus(200);
            this.setState(HttpParser.State.HEADER);
        }

        protected void setResponseStatus(int status) {
            super.setResponseStatus(status);
        }
    }
}

