/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.hazelcast.session;

import com.hazelcast.core.IMap;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class HazelcastSessionDataStore
extends AbstractSessionDataStore
implements SessionDataStore {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    private IMap<String, SessionData> sessionDataMap;

    public SessionData doLoad(String id) throws Exception {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading session {} from hazelcast", new Object[]{id});
            }
            SessionData sd = (SessionData)this.sessionDataMap.get((Object)this.getCacheKey(id));
            return sd;
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(id, this._context, (Throwable)e);
        }
    }

    public boolean delete(String id) throws Exception {
        if (this.sessionDataMap == null) {
            return false;
        }
        this.sessionDataMap.delete((Object)this.getCacheKey(id));
        return true;
    }

    public IMap<String, SessionData> getSessionDataMap() {
        return this.sessionDataMap;
    }

    public void setSessionDataMap(IMap<String, SessionData> sessionDataMap) {
        this.sessionDataMap = sessionDataMap;
    }

    public void initialize(SessionContext context) throws Exception {
        this._context = context;
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        this.sessionDataMap.set((Object)this.getCacheKey(id), (Object)data);
    }

    public boolean isPassivating() {
        return true;
    }

    public Set<String> doGetExpired(Set<String> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return Collections.emptySet();
        }
        long now = System.currentTimeMillis();
        return candidates.stream().filter(candidate -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking expiry for candidate {}", new Object[]{candidate});
            }
            try {
                SessionData sd = this.load((String)candidate);
                if (sd == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} does not exist in Hazelcast", new Object[]{candidate});
                    }
                    return true;
                }
                if (this._context.getWorkerName().equals(sd.getLastNode())) {
                    if (sd.getExpiry() > 0L && sd.getExpiry() <= now) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Session {} managed by {} is expired", new Object[]{candidate, this._context.getWorkerName()});
                        }
                        return true;
                    }
                } else if (this._lastExpiryCheckTime <= 0L ? sd.getExpiry() > 0L && sd.getExpiry() < now - 1000L * (long)(3 * this._gracePeriodSec) : sd.getExpiry() > 0L && sd.getExpiry() < now - 1000L * (long)this._gracePeriodSec) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.warn("Error checking if candidate {} is expired so expire it", new Object[]{candidate, e});
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    public boolean exists(String id) throws Exception {
        SessionData sd = this.load(id);
        if (sd == null) {
            return false;
        }
        if (sd.getExpiry() <= 0L) {
            return true;
        }
        return sd.getExpiry() > System.currentTimeMillis();
    }

    public String getCacheKey(String id) {
        return this._context.getCanonicalContextPath() + "_" + this._context.getVhost() + "_" + id;
    }
}

