/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.spi;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsServer;
import com.sun.net.httpserver.spi.HttpServerProvider;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http.spi.DelegatingThreadPool;
import org.eclipse.jetty.http.spi.JettyHttpServer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyHttpServerProvider
extends HttpServerProvider {
    private static Server _server;

    public static void setServer(Server server) {
        _server = server;
    }

    @Override
    public HttpServer createHttpServer(InetSocketAddress addr, int backlog) throws IOException {
        Server server = _server;
        boolean shared = true;
        if (server == null) {
            DelegatingThreadPool threadPool = new DelegatingThreadPool((Executor)new QueuedThreadPool());
            server = new Server((ThreadPool)threadPool);
            HandlerCollection handlerCollection = new HandlerCollection();
            handlerCollection.setHandlers(new Handler[]{new ContextHandlerCollection(), new DefaultHandler()});
            server.setHandler((Handler)handlerCollection);
            shared = false;
        }
        JettyHttpServer jettyHttpServer = new JettyHttpServer(server, shared);
        jettyHttpServer.bind(addr, backlog);
        return jettyHttpServer;
    }

    @Override
    public HttpsServer createHttpsServer(InetSocketAddress addr, int backlog) throws IOException {
        throw new UnsupportedOperationException();
    }
}

