/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.tools.matchers;

import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class HttpFieldsContainsHeaderKey
extends TypeSafeMatcher<HttpFields> {
    private final String keyName;

    public HttpFieldsContainsHeaderKey(String keyName) {
        this.keyName = keyName;
    }

    public HttpFieldsContainsHeaderKey(HttpHeader header) {
        this.keyName = header.asString();
    }

    public void describeTo(Description description) {
        description.appendText("expecting http field name ").appendValue((Object)this.keyName);
    }

    protected boolean matchesSafely(HttpFields fields) {
        return fields.contains(this.keyName);
    }

    public static Matcher<HttpFields> containsKey(String keyName) {
        return new HttpFieldsContainsHeaderKey(keyName);
    }
}

