/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.DateParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.http.QuotedCSVParser;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFields
implements Iterable<HttpField> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpFields.class);
    private HttpField[] _fields;
    private int _size;

    public HttpFields() {
        this(16);
    }

    public HttpFields(int capacity) {
        this._fields = new HttpField[capacity];
    }

    public HttpFields(HttpFields fields) {
        this._fields = Arrays.copyOf(fields._fields, fields._fields.length);
        this._size = fields._size;
    }

    public int size() {
        return this._size;
    }

    @Override
    public Iterator<HttpField> iterator() {
        return this.listIterator();
    }

    public ListIterator<HttpField> listIterator() {
        return new ListItr();
    }

    public Stream<HttpField> stream() {
        return Arrays.stream(this._fields).limit(this._size);
    }

    public Set<String> getFieldNamesCollection() {
        HashSet<String> set = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (set == null) {
                set = new HashSet<String>();
            }
            set.add(f.getName());
        }
        return set == null ? Collections.emptySet() : set;
    }

    public Enumeration<String> getFieldNames() {
        return Collections.enumeration(this.getFieldNamesCollection());
    }

    public HttpField getField(int index) {
        if (index >= this._size) {
            throw new NoSuchElementException();
        }
        return this._fields[index];
    }

    public HttpField getField(HttpHeader header) {
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            return f;
        }
        return null;
    }

    public HttpField getField(String name) {
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public List<HttpField> getFields(HttpHeader header) {
        ArrayList<HttpField> fields = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            if (fields == null) {
                fields = new ArrayList<HttpField>();
            }
            fields.add(f);
        }
        return fields == null ? Collections.emptyList() : fields;
    }

    public boolean contains(HttpField field) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.isSameName(field) || !f.equals(field) && !f.contains(field.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader header, String value) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header || !f.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name, String value) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.getName().equalsIgnoreCase(name) || !f.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader header) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String name) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public String get(HttpHeader header) {
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            return f.getValue();
        }
        return null;
    }

    public String get(String header) {
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.getName().equalsIgnoreCase(header)) continue;
            return f.getValue();
        }
        return null;
    }

    public List<String> getValuesList(HttpHeader header) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            list.add(f.getValue());
        }
        return list;
    }

    public List<String> getValuesList(String name) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.getName().equalsIgnoreCase(name)) continue;
            list.add(f.getValue());
        }
        return list;
    }

    public boolean addCSV(HttpHeader header, String ... values) {
        QuotedCSVParser existing = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            if (existing == null) {
                existing = new QuotedCSV(false, new String[0]);
            }
            existing.addValue(f.getValue());
        }
        String value = this.addCSV((QuotedCSV)existing, values);
        if (value != null) {
            this.add(header, value);
            return true;
        }
        return false;
    }

    public boolean addCSV(String name, String ... values) {
        QuotedCSVParser existing = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.getName().equalsIgnoreCase(name)) continue;
            if (existing == null) {
                existing = new QuotedCSV(false, new String[0]);
            }
            existing.addValue(f.getValue());
        }
        String value = this.addCSV((QuotedCSV)existing, values);
        if (value != null) {
            this.add(name, value);
            return true;
        }
        return false;
    }

    protected String addCSV(QuotedCSV existing, String ... values) {
        boolean add = true;
        if (existing != null && !existing.isEmpty()) {
            add = false;
            int i = values.length;
            while (i-- > 0) {
                String unquoted = QuotedCSV.unquote(values[i]);
                if (existing.getValues().contains(unquoted)) {
                    values[i] = null;
                    continue;
                }
                add = true;
            }
        }
        if (add) {
            StringBuilder value = new StringBuilder();
            for (String v : values) {
                if (v == null) continue;
                if (value.length() > 0) {
                    value.append(", ");
                }
                value.append(v);
            }
            if (value.length() > 0) {
                return value.toString();
            }
        }
        return null;
    }

    public List<String> getCSV(HttpHeader header, boolean keepQuotes) {
        QuotedCSV values = null;
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            if (values == null) {
                values = new QuotedCSV(keepQuotes, new String[0]);
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    public List<String> getCSV(String name, boolean keepQuotes) {
        QuotedCSV values = null;
        for (HttpField f : this) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            if (values == null) {
                values = new QuotedCSV(keepQuotes, new String[0]);
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    public List<String> getQualityCSV(HttpHeader header) {
        return this.getQualityCSV(header, null);
    }

    public List<String> getQualityCSV(HttpHeader header, ToIntFunction<String> secondaryOrdering) {
        QuotedQualityCSV values = null;
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            if (values == null) {
                values = new QuotedQualityCSV(secondaryOrdering);
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    public List<String> getQualityCSV(String name) {
        QuotedQualityCSV values = null;
        for (HttpField f : this) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            if (values == null) {
                values = new QuotedQualityCSV();
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    public Enumeration<String> getValues(final String name) {
        for (int i = 0; i < this._size; ++i) {
            final HttpField f = this._fields[i];
            if (!f.getName().equalsIgnoreCase(name) || f.getValue() == null) continue;
            final int first = i;
            return new Enumeration<String>(){
                HttpField field;
                int i;
                {
                    this.field = f;
                    this.i = first + 1;
                }

                @Override
                public boolean hasMoreElements() {
                    if (this.field == null) {
                        while (this.i < HttpFields.this._size) {
                            this.field = HttpFields.this._fields[this.i++];
                            if (!this.field.getName().equalsIgnoreCase(name) || this.field.getValue() == null) continue;
                            return true;
                        }
                        this.field = null;
                        return false;
                    }
                    return true;
                }

                @Override
                public String nextElement() throws NoSuchElementException {
                    if (this.hasMoreElements()) {
                        String value = this.field.getValue();
                        this.field = null;
                        return value;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        List empty = Collections.emptyList();
        return Collections.enumeration(empty);
    }

    public void put(HttpField field) {
        boolean put = false;
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.isSameName(field)) continue;
            if (put) {
                System.arraycopy(this._fields, i + 1, this._fields, i, --this._size - i);
                continue;
            }
            this._fields[i] = field;
            put = true;
        }
        if (!put) {
            this.add(field);
        }
    }

    public void put(String name, String value) {
        if (value == null) {
            this.remove(name);
        } else {
            this.put(new HttpField(name, value));
        }
    }

    public void put(HttpHeader header, HttpHeaderValue value) {
        this.put(header, value.toString());
    }

    public void put(HttpHeader header, String value) {
        if (value == null) {
            this.remove(header);
        } else {
            this.put(new HttpField(header, value));
        }
    }

    public void put(String name, List<String> list) {
        this.remove(name);
        for (String v : list) {
            if (v == null) continue;
            this.add(name, v);
        }
    }

    public void add(String name, String value) {
        if (value == null) {
            return;
        }
        HttpField field = new HttpField(name, value);
        this.add(field);
    }

    public void add(HttpHeader header, HttpHeaderValue value) {
        this.add(header, value.toString());
    }

    public void add(HttpHeader header, String value) {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        HttpField field = new HttpField(header, value);
        this.add(field);
    }

    public void add(HttpField field) {
        if (field != null) {
            if (this._size == this._fields.length) {
                this._fields = Arrays.copyOf(this._fields, this._size * 2);
            }
            this._fields[this._size++] = field;
        }
    }

    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration<String> e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Enumeration<String> values = fields.getValues(name);
            while (values.hasMoreElements()) {
                this.add(name, values.nextElement());
            }
        }
    }

    public HttpField remove(HttpHeader name) {
        HttpField removed = null;
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (f.getHeader() != name) continue;
            removed = f;
            System.arraycopy(this._fields, i + 1, this._fields, i, --this._size - i);
        }
        return removed;
    }

    public HttpField remove(String name) {
        HttpField removed = null;
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.getName().equalsIgnoreCase(name)) continue;
            removed = f;
            System.arraycopy(this._fields, i + 1, this._fields, i, --this._size - i);
        }
        return removed;
    }

    public long getLongField(String name) throws NumberFormatException {
        HttpField field = this.getField(name);
        return field == null ? -1L : field.getLongValue();
    }

    public long getDateField(String name) {
        HttpField field = this.getField(name);
        if (field == null) {
            return -1L;
        }
        String val = HttpFields.valueParameters(field.getValue(), null);
        if (val == null) {
            return -1L;
        }
        long date = DateParser.parseDate(val);
        if (date == -1L) {
            throw new IllegalArgumentException("Cannot convert date: " + val);
        }
        return date;
    }

    public void putLongField(HttpHeader name, long value) {
        String v = Long.toString(value);
        this.put(name, v);
    }

    public void putLongField(String name, long value) {
        String v = Long.toString(value);
        this.put(name, v);
    }

    public void putDateField(HttpHeader name, long date) {
        String d = DateGenerator.formatDate(date);
        this.put(name, d);
    }

    public void putDateField(String name, long date) {
        String d = DateGenerator.formatDate(date);
        this.put(name, d);
    }

    public void addDateField(String name, long date) {
        String d = DateGenerator.formatDate(date);
        this.add(name, d);
    }

    public int hashCode() {
        int hash = 0;
        for (HttpField field : this._fields) {
            hash += field.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpFields)) {
            return false;
        }
        HttpFields that = (HttpFields)o;
        if (this.size() != that.size()) {
            return false;
        }
        block0: for (HttpField fi : this) {
            for (HttpField fa : that) {
                if (!fi.equals(fa)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder();
            for (HttpField field : this) {
                if (field == null) continue;
                String tmp = field.getName();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append(": ");
                tmp = field.getValue();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
            return buffer.toString();
        }
        catch (Exception e) {
            LOG.warn("Unable to get fields as String", (Throwable)e);
            return e.toString();
        }
    }

    public void clear() {
        this._size = 0;
    }

    public void addAll(HttpFields fields) {
        for (int i = 0; i < fields._size; ++i) {
            this.add(fields._fields[i]);
        }
    }

    public static String stripParameters(String value) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        return value.substring(0, i).trim();
    }

    public static String valueParameters(String value, Map<String, String> parameters) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        if (parameters == null) {
            return value.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value.substring(i), ";", false, true);
        while (tok1.hasMoreTokens()) {
            String token = tok1.nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!tok2.hasMoreTokens()) continue;
            String paramName = tok2.nextToken();
            String paramVal = null;
            if (tok2.hasMoreTokens()) {
                paramVal = tok2.nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value.substring(0, i).trim();
    }

    private class ListItr
    implements ListIterator<HttpField> {
        int _cursor;
        int _current = -1;

        private ListItr() {
        }

        @Override
        public boolean hasNext() {
            return this._cursor != HttpFields.this._size;
        }

        @Override
        public HttpField next() {
            if (this._cursor == HttpFields.this._size) {
                throw new NoSuchElementException();
            }
            this._current = this._cursor++;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public void remove() {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            --HttpFields.this._size;
            System.arraycopy(HttpFields.this._fields, this._current + 1, HttpFields.this._fields, this._current, HttpFields.this._size - this._current);
            HttpFields.this._fields[HttpFields.this._size] = null;
            this._cursor = this._current;
            this._current = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this._cursor > 0;
        }

        @Override
        public HttpField previous() {
            if (this._cursor == 0) {
                throw new NoSuchElementException();
            }
            this._current = --this._cursor;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public int nextIndex() {
            return this._cursor + 1;
        }

        @Override
        public int previousIndex() {
            return this._cursor - 1;
        }

        @Override
        public void set(HttpField field) {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            HttpFields.this._fields[this._current] = field;
        }

        @Override
        public void add(HttpField field) {
            HttpFields.this._fields = Arrays.copyOf(HttpFields.this._fields, HttpFields.this._fields.length + 1);
            System.arraycopy(HttpFields.this._fields, this._cursor, HttpFields.this._fields, this._cursor + 1, HttpFields.this._size++);
            HttpFields.this._fields[this._cursor++] = field;
            this._current = -1;
        }
    }
}

