/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpContentWrapper;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingContentFactory
implements HttpContent.ContentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CachingContentFactory.class);
    private final HttpContent.ContentFactory _authority;
    private final boolean _useFileMappedBuffer;
    private final ConcurrentMap<String, CachingHttpContent> _cache = new ConcurrentHashMap<String, CachingHttpContent>();
    private final AtomicLong _cachedSize = new AtomicLong();
    private int _maxCachedFileSize = 0x8000000;
    private int _maxCachedFiles = 2048;
    private int _maxCacheSize = 0x10000000;

    public CachingContentFactory(HttpContent.ContentFactory authority) {
        this(authority, false);
    }

    public CachingContentFactory(HttpContent.ContentFactory authority, boolean useFileMappedBuffer) {
        this._authority = authority;
        this._useFileMappedBuffer = useFileMappedBuffer;
    }

    public long getCachedSize() {
        return this._cachedSize.get();
    }

    public int getCachedFiles() {
        return this._cache.size();
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int maxCachedFileSize) {
        this._maxCachedFileSize = maxCachedFileSize;
        this.shrinkCache();
    }

    public int getMaxCacheSize() {
        return this._maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this._maxCacheSize = maxCacheSize;
        this.shrinkCache();
    }

    public int getMaxCachedFiles() {
        return this._maxCachedFiles;
    }

    public void setMaxCachedFiles(int maxCachedFiles) {
        this._maxCachedFiles = maxCachedFiles;
        this.shrinkCache();
    }

    public boolean isUseFileMappedBuffer() {
        return this._useFileMappedBuffer;
    }

    private void shrinkCache() {
        block0: while (this._cache.size() > 0 && (this._cache.size() > this._maxCachedFiles || this._cachedSize.get() > (long)this._maxCacheSize)) {
            TreeSet sorted = new TreeSet((c1, c2) -> {
                if (c1._lastAccessed != c2._lastAccessed) {
                    return Long.compare(c1._lastAccessed, c2._lastAccessed);
                }
                if (c1._contentLengthValue < c2._contentLengthValue) {
                    return -1;
                }
                return c1._cacheKey.compareTo(c2._cacheKey);
            });
            sorted.addAll(this._cache.values());
            for (CachingHttpContent content : sorted) {
                if (this._cache.size() <= this._maxCachedFiles && this._cachedSize.get() <= (long)this._maxCacheSize) continue block0;
                this.removeFromCache(content);
            }
        }
    }

    private void removeFromCache(CachingHttpContent content) {
        if (content == this._cache.remove(content._cacheKey)) {
            content.release();
            this._cachedSize.addAndGet(-content.calculateSize());
        }
    }

    public void flushCache() {
        for (CachingHttpContent content : this._cache.values()) {
            this.removeFromCache(content);
        }
    }

    @Override
    public HttpContent getContent(String path) throws IOException {
        HttpContent httpContent;
        CachingHttpContent cachingHttpContent = (CachingHttpContent)this._cache.get(path);
        if (cachingHttpContent != null) {
            if (cachingHttpContent.isValid()) {
                return cachingHttpContent;
            }
            this.removeFromCache(cachingHttpContent);
        }
        if ((httpContent = this._authority.getContent(path)) != null && !httpContent.getResource().isDirectory() && httpContent.getContentLengthValue() <= (long)this._maxCachedFileSize) {
            cachingHttpContent = new CachingHttpContent(path, null, httpContent);
            httpContent = cachingHttpContent;
            this._cache.put(path, cachingHttpContent);
            this._cachedSize.addAndGet(cachingHttpContent.calculateSize());
            this.shrinkCache();
        }
        return httpContent;
    }

    private class CachingHttpContent
    extends HttpContentWrapper {
        private final ByteBuffer _buffer;
        private final FileTime _lastModifiedValue;
        private final String _cacheKey;
        private final String _etag;
        private final long _contentLengthValue;
        private final Map<CompressedContentFormat, CachingHttpContent> _precompressedContents;
        private volatile long _lastAccessed;

        private CachingHttpContent(String key, String precalculatedEtag, HttpContent httpContent) throws IOException {
            Map<CompressedContentFormat, ? extends HttpContent> precompressedContents;
            ByteBuffer byteBuffer;
            super(httpContent);
            this._etag = precalculatedEtag;
            this._contentLengthValue = httpContent.getContentLengthValue();
            ByteBuffer byteBuffer2 = byteBuffer = CachingContentFactory.this._useFileMappedBuffer ? BufferUtil.toMappedBuffer((Resource)httpContent.getResource(), (long)0L, (long)this._contentLengthValue) : null;
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.allocateDirect((int)this._contentLengthValue);
                try (SeekableByteChannel channel = Files.newByteChannel(httpContent.getResource().getPath(), new OpenOption[0]);){
                    int read = 0;
                    while ((long)read != this._contentLengthValue) {
                        read += channel.read(byteBuffer);
                    }
                }
                byteBuffer.flip();
            }
            if ((precompressedContents = httpContent.getPrecompressedContents()) != null) {
                this._precompressedContents = new HashMap<CompressedContentFormat, CachingHttpContent>();
                for (Map.Entry<CompressedContentFormat, ? extends HttpContent> entry : precompressedContents.entrySet()) {
                    CompressedContentFormat format = entry.getKey();
                    Object precompressedEtag = httpContent.getETagValue();
                    boolean weak = false;
                    if (((String)precompressedEtag).startsWith("W/")) {
                        weak = true;
                        precompressedEtag = ((String)precompressedEtag).substring(2);
                    }
                    precompressedEtag = (weak ? "W/\"" : "\"") + QuotedStringTokenizer.unquote((String)precompressedEtag) + format.getEtagSuffix() + "\"";
                    this._precompressedContents.put(format, new CachingHttpContent(key, (String)precompressedEtag, entry.getValue()));
                }
            } else {
                this._precompressedContents = null;
            }
            this._cacheKey = key;
            this._buffer = byteBuffer;
            this._lastModifiedValue = Files.getLastModifiedTime(httpContent.getResource().getPath(), new LinkOption[0]);
            this._lastAccessed = System.nanoTime();
        }

        long calculateSize() {
            long totalSize = this._contentLengthValue;
            if (this._precompressedContents != null) {
                for (CachingHttpContent cachingHttpContent : this._precompressedContents.values()) {
                    totalSize += cachingHttpContent.calculateSize();
                }
            }
            return totalSize;
        }

        @Override
        public ByteBuffer getBuffer() {
            return this._buffer.slice();
        }

        public boolean isValid() {
            try {
                FileTime lastModifiedTime = Files.getLastModifiedTime(this._delegate.getResource().getPath(), new LinkOption[0]);
                if (lastModifiedTime.equals(this._lastModifiedValue)) {
                    this._lastAccessed = System.nanoTime();
                    return true;
                }
            }
            catch (IOException e) {
                LOG.debug("unable to get delegate path' LastModifiedTime", (Throwable)e);
            }
            this.release();
            return false;
        }

        @Override
        public void release() {
        }

        @Override
        public HttpField getETag() {
            String eTag = this.getETagValue();
            return eTag == null ? null : new HttpField(HttpHeader.ETAG, eTag);
        }

        @Override
        public String getETagValue() {
            if (this._etag != null) {
                return this._etag;
            }
            return this._delegate.getETagValue();
        }

        @Override
        public Map<CompressedContentFormat, ? extends HttpContent> getPrecompressedContents() {
            return this._precompressedContents;
        }
    }
}

