/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.CookieCutter;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieCache {
    protected static final Logger LOG = LoggerFactory.getLogger(CookieCache.class);
    protected final List<String> _rawFields = new ArrayList<String>();
    protected List<HttpCookie> _cookieList;
    private final CookieCutter _cookieCutter;

    public CookieCache() {
        this(CookieCompliance.RFC6265, null);
    }

    public CookieCache(CookieCompliance compliance, ComplianceViolation.Listener complianceListener) {
        this._cookieCutter = new CookieCutter(compliance, complianceListener){

            @Override
            protected void addCookie(String cookieName, String cookieValue, String cookieDomain, String cookiePath, int cookieVersion, String cookieComment) {
                CookieCache.this._cookieList.add(new HttpCookie(cookieName, cookieValue));
            }
        };
    }

    public List<HttpCookie> getCookies(HttpFields headers) {
        boolean building = false;
        ListIterator<String> raw = this._rawFields.listIterator();
        for (HttpField field : headers) {
            String value;
            if (!HttpHeader.COOKIE.equals((Object)field.getHeader()) || StringUtil.isBlank((String)(value = field.getValue()))) continue;
            if (building) {
                this._rawFields.add(value);
                continue;
            }
            if (!raw.hasNext()) {
                building = true;
                this._rawFields.add(value);
                continue;
            }
            if (value.equals(raw.next())) continue;
            building = true;
            raw.remove();
            while (raw.hasNext()) {
                raw.next();
                raw.remove();
            }
            this._rawFields.add(value);
        }
        if (!building && raw.hasNext()) {
            building = true;
            while (raw.hasNext()) {
                raw.next();
                raw.remove();
            }
        }
        if (building) {
            this._cookieList = new ArrayList<HttpCookie>();
            this._cookieCutter.parseFields(this._rawFields);
        }
        return this._cookieList == null ? Collections.emptyList() : this._cookieList;
    }
}

