/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.Map;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.resource.Resource;

public class PrecompressedHttpContent
implements HttpContent {
    private final HttpContent _content;
    private final HttpContent _precompressedContent;
    private final CompressedContentFormat _format;

    public PrecompressedHttpContent(HttpContent content, HttpContent precompressedContent, CompressedContentFormat format) {
        this._content = content;
        this._precompressedContent = precompressedContent;
        this._format = format;
        if (this._precompressedContent == null || this._format == null) {
            throw new NullPointerException("Missing compressed content and/or format");
        }
    }

    @Override
    public Resource getResource() {
        return this._content.getResource();
    }

    @Override
    public HttpField getETag() {
        return new HttpField(HttpHeader.ETAG, this.getETagValue());
    }

    @Override
    public String getETagValue() {
        return null;
    }

    @Override
    public HttpField getLastModified() {
        return this._content.getLastModified();
    }

    @Override
    public String getLastModifiedValue() {
        return this._content.getLastModifiedValue();
    }

    @Override
    public HttpField getContentType() {
        return this._content.getContentType();
    }

    @Override
    public String getContentTypeValue() {
        return this._content.getContentTypeValue();
    }

    @Override
    public HttpField getContentEncoding() {
        return this._format.getContentEncoding();
    }

    @Override
    public String getContentEncodingValue() {
        return this._format.getContentEncoding().getValue();
    }

    @Override
    public String getCharacterEncoding() {
        return this._content.getCharacterEncoding();
    }

    @Override
    public MimeTypes.Type getMimeType() {
        return this._content.getMimeType();
    }

    @Override
    public HttpField getContentLength() {
        return this._precompressedContent.getContentLength();
    }

    @Override
    public long getContentLengthValue() {
        return this._precompressedContent.getContentLengthValue();
    }

    public String toString() {
        return String.format("%s@%x{e=%s,r=%s|%s,lm=%s|%s,ct=%s}", this.getClass().getSimpleName(), this.hashCode(), this._format, this._content.getResource().lastModified(), this._precompressedContent.getResource().lastModified(), 0L, 0L, this.getContentType());
    }

    public Map<CompressedContentFormat, HttpContent> getPrecompressedContents() {
        return null;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this._content.getBuffer();
    }

    @Override
    public void release() {
        this._content.release();
    }
}

