/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.ServiceLoader;
import org.eclipse.jetty.http.Http10FieldPreEncoder;
import org.eclipse.jetty.http.Http11FieldPreEncoder;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFieldPreEncoder;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreEncodedHttpField
extends HttpField {
    private static final Logger LOG = LoggerFactory.getLogger(PreEncodedHttpField.class);
    private static final EnumMap<HttpVersion, HttpFieldPreEncoder> __encoders = new EnumMap(HttpVersion.class);
    private final EnumMap<HttpVersion, byte[]> _encodedFields = new EnumMap(HttpVersion.class);

    public PreEncodedHttpField(HttpHeader header, String name, String value) {
        super(header, name, value);
        for (HttpFieldPreEncoder encoder : __encoders.values()) {
            HttpVersion version = encoder.getHttpVersion();
            this._encodedFields.put(encoder.getHttpVersion(), version == HttpVersion.HTTP_1_1 ? this._encodedFields.get((Object)HttpVersion.HTTP_1_0) : encoder.getEncodedField(header, name, value));
        }
    }

    public PreEncodedHttpField(HttpHeader header, String value) {
        this(header, header.asString(), value);
    }

    public PreEncodedHttpField(String name, String value) {
        this(null, name, value);
    }

    public void putTo(ByteBuffer bufferInFillMode, HttpVersion version) {
        bufferInFillMode.put(this._encodedFields.get((Object)version));
    }

    public int getEncodedLength(HttpVersion version) {
        return this._encodedFields.get((Object)version).length;
    }

    static {
        TypeUtil.serviceProviderStream(ServiceLoader.load(HttpFieldPreEncoder.class)).forEach(provider -> {
            block3: {
                try {
                    HttpFieldPreEncoder encoder = (HttpFieldPreEncoder)provider.get();
                    HttpFieldPreEncoder existing = __encoders.put(encoder.getHttpVersion(), encoder);
                    if (existing != null) {
                        LOG.warn("multiple {} for {}", (Object)HttpFieldPreEncoder.class.getSimpleName(), (Object)encoder.getHttpVersion());
                    }
                }
                catch (Error | RuntimeException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("unable to add {}", (Object)HttpFieldPreEncoder.class.getSimpleName(), (Object)e);
                }
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("loaded {} {}s", (Object)__encoders.size(), (Object)HttpFieldPreEncoder.class.getSimpleName());
        }
        if (!__encoders.containsKey((Object)HttpVersion.HTTP_1_0)) {
            __encoders.put(HttpVersion.HTTP_1_0, new Http10FieldPreEncoder());
        }
        if (!__encoders.containsKey((Object)HttpVersion.HTTP_1_1)) {
            __encoders.put(HttpVersion.HTTP_1_1, new Http11FieldPreEncoder());
        }
    }
}

