/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PrecompressedHttpContent;
import org.eclipse.jetty.util.resource.Resource;

public class ResourceHttpContent
implements HttpContent {
    final Resource _resource;
    final Path _path;
    final String _contentType;
    Map<CompressedContentFormat, HttpContent> _precompressedContents;
    String _etag;

    public ResourceHttpContent(Resource resource, String contentType) {
        this(resource, contentType, null);
    }

    public ResourceHttpContent(Resource resource, String contentType, Map<CompressedContentFormat, HttpContent> precompressedContents) {
        this._resource = resource;
        this._path = resource.getPath();
        this._contentType = contentType;
        if (precompressedContents == null) {
            this._precompressedContents = null;
        } else {
            this._precompressedContents = new HashMap<CompressedContentFormat, HttpContent>(precompressedContents.size());
            for (Map.Entry<CompressedContentFormat, HttpContent> entry : precompressedContents.entrySet()) {
                this._precompressedContents.put(entry.getKey(), new PrecompressedHttpContent(this, entry.getValue(), entry.getKey()));
            }
        }
    }

    @Override
    public String getContentTypeValue() {
        return this._contentType;
    }

    @Override
    public HttpField getContentType() {
        return this._contentType == null ? null : new HttpField(HttpHeader.CONTENT_TYPE, this._contentType);
    }

    @Override
    public HttpField getContentEncoding() {
        return null;
    }

    @Override
    public String getContentEncodingValue() {
        return null;
    }

    @Override
    public String getCharacterEncoding() {
        return this._contentType == null ? null : MimeTypes.getCharsetFromContentType(this._contentType);
    }

    @Override
    public MimeTypes.Type getMimeType() {
        return this._contentType == null ? null : (MimeTypes.Type)((Object)MimeTypes.CACHE.get(MimeTypes.getContentTypeWithoutCharset(this._contentType)));
    }

    @Override
    public HttpField getLastModified() {
        Instant lm = this._resource.lastModified();
        return new HttpField(HttpHeader.LAST_MODIFIED, DateGenerator.formatDate(lm));
    }

    @Override
    public String getLastModifiedValue() {
        Instant lm = this._resource.lastModified();
        return DateGenerator.formatDate(lm);
    }

    @Override
    public HttpField getETag() {
        return new HttpField(HttpHeader.ETAG, this.getETagValue());
    }

    @Override
    public String getETagValue() {
        return this._resource.getWeakETag();
    }

    @Override
    public HttpField getContentLength() {
        long l = this._resource.length();
        return l == -1L ? null : new HttpField.LongValueHttpField(HttpHeader.CONTENT_LENGTH, l);
    }

    @Override
    public long getContentLengthValue() {
        return this._resource.length();
    }

    @Override
    public Resource getResource() {
        return this._resource;
    }

    public String toString() {
        return String.format("%s@%x{r=%s,ct=%s,c=%b}", this.getClass().getSimpleName(), this.hashCode(), this._resource, this._contentType, this._precompressedContents != null);
    }

    public Map<CompressedContentFormat, HttpContent> getPrecompressedContents() {
        return this._precompressedContents;
    }

    @Override
    public ByteBuffer getBuffer() {
        return null;
    }

    @Override
    public void release() {
    }
}

