/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.Syntax;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCookie {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCookie.class);
    private static final String __COOKIE_DELIM = "\",;\\ \t";
    private static final String __01Jan1970_COOKIE = DateGenerator.formatCookieDate(0L).trim();
    public static final String HTTP_ONLY_COMMENT = "__HTTP_ONLY__";
    private static final String SAME_SITE_COMMENT = "__SAME_SITE_";
    public static final String SAME_SITE_NONE_COMMENT = "__SAME_SITE_NONE__";
    public static final String SAME_SITE_LAX_COMMENT = "__SAME_SITE_LAX__";
    public static final String SAME_SITE_STRICT_COMMENT = "__SAME_SITE_STRICT__";
    public static final String SAME_SITE_DEFAULT_ATTRIBUTE = "org.eclipse.jetty.cookie.sameSiteDefault";
    private final String _name;
    private final String _value;
    private final String _comment;
    private final String _domain;
    private final long _maxAge;
    private final String _path;
    private final boolean _secure;
    private final int _version;
    private final boolean _httpOnly;
    private final long _expiration;
    private final Map<String, String> _attributes;

    public HttpCookie(String name, String value) {
        this(name, value, -1L);
    }

    public HttpCookie(String name, String value, String domain, String path) {
        this(name, value, domain, path, -1L, false, false);
    }

    public HttpCookie(String name, String value, long maxAge) {
        this(name, value, null, null, maxAge, false, false);
    }

    public HttpCookie(String name, String value, String domain, String path, long maxAge, boolean httpOnly, boolean secure) {
        this(name, value, domain, path, maxAge, httpOnly, secure, null, 0);
    }

    public HttpCookie(String name, String value, String domain, String path, long maxAge, boolean httpOnly, boolean secure, String comment, int version) {
        this(name, value, domain, path, maxAge, httpOnly, secure, comment, version, (SameSite)null);
    }

    public HttpCookie(String name, String value, String domain, String path, long maxAge, boolean httpOnly, boolean secure, String comment, int version, SameSite sameSite) {
        this(name, value, domain, path, maxAge, httpOnly, secure, comment, version, Collections.singletonMap("SameSite", sameSite == null ? null : sameSite.getAttributeValue()));
    }

    public HttpCookie(String name, String value, String domain, String path, long maxAge, boolean httpOnly, boolean secure, String comment, int version, Map<String, String> attributes) {
        this._name = name;
        this._value = value;
        this._domain = domain;
        this._path = path;
        this._maxAge = maxAge;
        this._httpOnly = httpOnly;
        this._secure = secure;
        this._comment = comment;
        this._version = version;
        this._expiration = maxAge < 0L ? -1L : NanoTime.now() + TimeUnit.SECONDS.toNanos(maxAge);
        this._attributes = attributes == null ? Collections.emptyMap() : attributes;
    }

    public HttpCookie(String name, String value, int version, Map<String, String> attributes) {
        this._name = name;
        this._value = value;
        this._version = version;
        this._attributes = attributes == null ? Collections.emptyMap() : new TreeMap<String, String>(attributes);
        this._domain = this._attributes.remove("Domain");
        this._path = this._attributes.remove("Path");
        String tmp = this._attributes.remove("Max-Age");
        this._maxAge = StringUtil.isBlank((String)tmp) ? -1L : Long.valueOf(tmp);
        this._expiration = this._maxAge < 0L ? -1L : NanoTime.now() + TimeUnit.SECONDS.toNanos(this._maxAge);
        this._httpOnly = Boolean.parseBoolean(this._attributes.remove("HttpOnly"));
        this._secure = Boolean.parseBoolean(this._attributes.remove("Secure"));
        this._comment = this._attributes.remove("Comment");
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String getComment() {
        return this._comment;
    }

    public String getDomain() {
        return this._domain;
    }

    public long getMaxAge() {
        return this._maxAge;
    }

    public String getPath() {
        return this._path;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public int getVersion() {
        return this._version;
    }

    public SameSite getSameSite() {
        String val = this._attributes.get("SameSite");
        if (val == null) {
            return null;
        }
        return SameSite.valueOf(val.toUpperCase(Locale.ENGLISH));
    }

    public boolean isHttpOnly() {
        return this._httpOnly;
    }

    public boolean isExpired(long timeNanos) {
        return this._expiration != -1L && NanoTime.isBefore((long)this._expiration, (long)timeNanos);
    }

    public String asString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append("=").append(this.getValue());
        if (this.getDomain() != null) {
            builder.append(";$Domain=").append(this.getDomain());
        }
        if (this.getPath() != null) {
            builder.append(";$Path=").append(this.getPath());
        }
        return builder.toString();
    }

    public String toString() {
        return "%x@%s".formatted(this.hashCode(), this.asString());
    }

    private static void quoteOnlyOrAppend(StringBuilder buf, String s, boolean quote) {
        if (quote) {
            QuotedStringTokenizer.quoteOnly((Appendable)buf, (String)s);
        } else {
            buf.append(s);
        }
    }

    private static boolean isQuoteNeededForCookie(String s) {
        if (s == null || s.length() == 0) {
            return true;
        }
        if (QuotedStringTokenizer.isQuoted((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (__COOKIE_DELIM.indexOf(c) >= 0) {
                return true;
            }
            if (c >= ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException("Illegal character in cookie value");
        }
        return false;
    }

    public String getSetCookie(CookieCompliance compliance) {
        if (compliance == CookieCompliance.RFC6265) {
            return this.getRFC6265SetCookie();
        }
        if (compliance == CookieCompliance.RFC2965) {
            return this.getRFC2965SetCookie();
        }
        throw new IllegalStateException();
    }

    public String getRFC2965SetCookie() {
        if (this._name == null || this._name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuilder buf = new StringBuilder();
        boolean quoteName = HttpCookie.isQuoteNeededForCookie(this._name);
        HttpCookie.quoteOnlyOrAppend(buf, this._name, quoteName);
        buf.append('=');
        boolean quoteValue = HttpCookie.isQuoteNeededForCookie(this._value);
        HttpCookie.quoteOnlyOrAppend(buf, this._value, quoteValue);
        boolean hasDomain = this._domain != null && this._domain.length() > 0;
        boolean quoteDomain = hasDomain && HttpCookie.isQuoteNeededForCookie(this._domain);
        boolean hasPath = this._path != null && this._path.length() > 0;
        boolean quotePath = hasPath && HttpCookie.isQuoteNeededForCookie(this._path);
        int version = this._version;
        if (version == 0 && (this._comment != null || quoteName || quoteValue || quoteDomain || quotePath || QuotedStringTokenizer.isQuoted((String)this._name) || QuotedStringTokenizer.isQuoted((String)this._value) || QuotedStringTokenizer.isQuoted((String)this._path) || QuotedStringTokenizer.isQuoted((String)this._domain))) {
            version = 1;
        }
        if (version == 1) {
            buf.append(";Version=1");
        } else if (version > 1) {
            buf.append(";Version=").append(version);
        }
        if (hasPath) {
            buf.append(";Path=");
            HttpCookie.quoteOnlyOrAppend(buf, this._path, quotePath);
        }
        if (hasDomain) {
            buf.append(";Domain=");
            HttpCookie.quoteOnlyOrAppend(buf, this._domain, quoteDomain);
        }
        if (this._maxAge >= 0L) {
            buf.append(";Expires=");
            if (this._maxAge == 0L) {
                buf.append(__01Jan1970_COOKIE);
            } else {
                DateGenerator.formatCookieDate(buf, System.currentTimeMillis() + 1000L * this._maxAge);
            }
            if (version >= 1) {
                buf.append(";Max-Age=");
                buf.append(this._maxAge);
            }
        }
        if (this._secure) {
            buf.append(";Secure");
        }
        if (this._httpOnly) {
            buf.append(";HttpOnly");
        }
        if (this._comment != null) {
            buf.append(";Comment=");
            HttpCookie.quoteOnlyOrAppend(buf, this._comment, HttpCookie.isQuoteNeededForCookie(this._comment));
        }
        return buf.toString();
    }

    public String getRFC6265SetCookie() {
        String sameSite;
        if (this._name == null || this._name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        Syntax.requireValidRFC2616Token(this._name, "RFC6265 Cookie name");
        Syntax.requireValidRFC6265CookieValue(this._value);
        StringBuilder buf = new StringBuilder();
        buf.append(this._name).append('=').append(this._value == null ? "" : this._value);
        if (this._path != null && this._path.length() > 0) {
            buf.append("; Path=").append(this._path);
        }
        if (this._domain != null && this._domain.length() > 0) {
            buf.append("; Domain=").append(this._domain);
        }
        if (this._maxAge >= 0L) {
            buf.append("; Expires=");
            if (this._maxAge == 0L) {
                buf.append(__01Jan1970_COOKIE);
            } else {
                DateGenerator.formatCookieDate(buf, System.currentTimeMillis() + 1000L * this._maxAge);
            }
            buf.append("; Max-Age=");
            buf.append(this._maxAge);
        }
        if (this._secure) {
            buf.append("; Secure");
        }
        if (this._httpOnly) {
            buf.append("; HttpOnly");
        }
        if ((sameSite = this._attributes.get("SameSite")) != null) {
            buf.append("; SameSite=");
            buf.append(sameSite);
        }
        this._attributes.entrySet().stream().filter(e -> !"SameSite".equals(e.getKey())).forEach(e -> {
            buf.append("; " + (String)e.getKey() + "=");
            buf.append((String)e.getValue());
        });
        return buf.toString();
    }

    public static boolean isHttpOnlyInComment(String comment) {
        return comment != null && comment.contains(HTTP_ONLY_COMMENT);
    }

    public static SameSite getSameSiteFromComment(String comment) {
        if (comment != null) {
            if (comment.contains(SAME_SITE_STRICT_COMMENT)) {
                return SameSite.STRICT;
            }
            if (comment.contains(SAME_SITE_LAX_COMMENT)) {
                return SameSite.LAX;
            }
            if (comment.contains(SAME_SITE_NONE_COMMENT)) {
                return SameSite.NONE;
            }
        }
        return null;
    }

    public static SameSite getSameSiteDefault(Attributes contextAttributes) {
        if (contextAttributes == null) {
            return null;
        }
        Object o = contextAttributes.getAttribute(SAME_SITE_DEFAULT_ATTRIBUTE);
        if (o == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No default value for SameSite");
            }
            return null;
        }
        if (o instanceof SameSite) {
            return (SameSite)((Object)o);
        }
        try {
            SameSite samesite = Enum.valueOf(SameSite.class, o.toString().trim().toUpperCase(Locale.ENGLISH));
            contextAttributes.setAttribute(SAME_SITE_DEFAULT_ATTRIBUTE, (Object)samesite);
            return samesite;
        }
        catch (Exception e) {
            LOG.warn("Bad default value {} for SameSite", o);
            throw new IllegalStateException(e);
        }
    }

    public static Map<String, String> extractBasics(String setCookieHeader) {
        List<java.net.HttpCookie> cookies = java.net.HttpCookie.parse(setCookieHeader);
        if (cookies.size() != 1) {
            return Collections.emptyMap();
        }
        java.net.HttpCookie cookie = cookies.get(0);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("name", cookie.getName());
        fields.put("value", cookie.getValue());
        fields.put("domain", cookie.getDomain());
        fields.put("path", cookie.getPath());
        fields.put("max-age", Long.toString(cookie.getMaxAge()));
        return fields;
    }

    public static boolean match(String setCookieHeader, String name, String domain, String path) {
        List<java.net.HttpCookie> cookies = java.net.HttpCookie.parse(setCookieHeader);
        if (cookies.size() != 1) {
            return false;
        }
        java.net.HttpCookie cookie = cookies.get(0);
        return HttpCookie.match(cookie.getName(), cookie.getDomain(), cookie.getPath(), name, domain, path);
    }

    public static boolean match(HttpCookie cookie, String name, String domain, String path) {
        if (cookie == null) {
            return false;
        }
        return HttpCookie.match(cookie.getName(), cookie.getDomain(), cookie.getPath(), name, domain, path);
    }

    private static boolean match(String oldName, String oldDomain, String oldPath, String newName, String newDomain, String newPath) {
        if (oldName == null ? newName != null : !oldName.equals(newName)) {
            return false;
        }
        if (oldDomain == null ? newDomain != null : !oldDomain.equalsIgnoreCase(newDomain)) {
            return false;
        }
        return !(oldPath == null ? newPath != null : !oldPath.equals(newPath));
    }

    @Deprecated
    public static String getCommentWithoutAttributes(String comment) {
        if (comment == null) {
            return null;
        }
        String strippedComment = comment.trim();
        strippedComment = StringUtil.strip((String)strippedComment, (String)HTTP_ONLY_COMMENT);
        strippedComment = StringUtil.strip((String)strippedComment, (String)SAME_SITE_NONE_COMMENT);
        strippedComment = StringUtil.strip((String)strippedComment, (String)SAME_SITE_LAX_COMMENT);
        return (strippedComment = StringUtil.strip((String)strippedComment, (String)SAME_SITE_STRICT_COMMENT)).length() == 0 ? null : strippedComment;
    }

    @Deprecated
    public static String getCommentWithAttributes(String comment, boolean httpOnly, SameSite sameSite) {
        if (comment == null && sameSite == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtil.isNotBlank((String)comment) && StringUtil.isNotBlank((String)(comment = HttpCookie.getCommentWithoutAttributes(comment)))) {
            builder.append(comment);
        }
        if (httpOnly) {
            builder.append(HTTP_ONLY_COMMENT);
        }
        if (sameSite != null) {
            switch (sameSite) {
                case NONE: {
                    builder.append(SAME_SITE_NONE_COMMENT);
                    break;
                }
                case STRICT: {
                    builder.append(SAME_SITE_STRICT_COMMENT);
                    break;
                }
                case LAX: {
                    builder.append(SAME_SITE_LAX_COMMENT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(sameSite.toString());
                }
            }
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    public static HttpCookie checkSameSite(HttpCookie cookie, Attributes attributes) {
        if (cookie == null || cookie.getSameSite() != null) {
            return cookie;
        }
        SameSite contextDefault = HttpCookie.getSameSiteDefault(attributes);
        if (contextDefault == null) {
            return cookie;
        }
        return new HttpCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getMaxAge(), cookie.isHttpOnly(), cookie.isSecure(), cookie.getComment(), cookie.getVersion(), contextDefault);
    }

    public static enum SameSite {
        NONE("None"),
        STRICT("Strict"),
        LAX("Lax");

        private final String attributeValue;

        private SameSite(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }
    }

    public static class SetCookieHttpField
    extends HttpField {
        final HttpCookie _cookie;

        public SetCookieHttpField(HttpCookie cookie, CookieCompliance compliance) {
            super(HttpHeader.SET_COOKIE, cookie.getSetCookie(compliance));
            this._cookie = cookie;
        }

        public HttpCookie getHttpCookie() {
            return this._cookie;
        }
    }
}

