/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.content.ByteBufferContentSource;
import org.eclipse.jetty.io.content.ChunksContentSource;
import org.eclipse.jetty.io.content.PathContentSource;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.SearchPattern;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPart {
    private static final int MAX_BOUNDARY_LENGTH = 70;

    private MultiPart() {
    }

    public static String extractBoundary(String contentType) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HttpField.valueParameters(contentType, parameters);
        return QuotedStringTokenizer.unquote((String)((String)parameters.get("boundary")));
    }

    public static String generateBoundary(String prefix, int randomLength) {
        if (prefix == null && randomLength < 1) {
            throw new IllegalArgumentException("invalid boundary length");
        }
        StringBuilder builder = new StringBuilder(prefix == null ? "" : prefix);
        int length = builder.length();
        while (builder.length() < length + randomLength) {
            long rnd = ThreadLocalRandom.current().nextLong();
            builder.append(Long.toString(rnd < 0L ? -rnd : rnd, 36));
        }
        builder.setLength(Math.min(length + randomLength, 70));
        return builder.toString();
    }

    public static abstract class AbstractPartsListener
    implements Parser.Listener {
        private static final Logger LOG = LoggerFactory.getLogger(AbstractPartsListener.class);
        private final HttpFields.Mutable fields = HttpFields.build();
        private String name;
        private String fileName;

        public String getName() {
            return this.name;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public void onPartHeader(String headerName, String headerValue) {
            if (HttpHeader.CONTENT_DISPOSITION.is(headerName)) {
                String namePrefix = "name=";
                String fileNamePrefix = "filename=";
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(headerValue, ";", false, true);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken().trim();
                    String lowerToken = StringUtil.asciiToLowerCase((String)token);
                    if (lowerToken.startsWith(namePrefix)) {
                        int index = lowerToken.indexOf(namePrefix);
                        String value = token.substring(index + namePrefix.length()).trim();
                        this.name = QuotedStringTokenizer.unquoteOnly((String)value);
                        continue;
                    }
                    if (!lowerToken.startsWith(fileNamePrefix)) continue;
                    this.fileName = this.fileNameValue(token);
                }
            }
            this.fields.add(new HttpField(headerName, headerValue));
        }

        private String fileNameValue(String token) {
            int idx = token.indexOf(61);
            String value = token.substring(idx + 1).trim();
            if (value.matches(".??[a-zA-Z]:\\\\[^\\\\].*")) {
                char last;
                char first = value.charAt(0);
                if (first == '\"' || first == '\'') {
                    value = value.substring(1);
                }
                if ((last = value.charAt(value.length() - 1)) == '\"' || last == '\'') {
                    value = value.substring(0, value.length() - 1);
                }
                return value;
            }
            return QuotedStringTokenizer.unquoteOnly((String)value, (boolean)true);
        }

        @Override
        public void onPartEnd() {
            String name = this.getName();
            this.name = null;
            String fileName = this.getFileName();
            this.fileName = null;
            HttpFields headers = this.fields.takeAsImmutable();
            this.notifyPart(name, fileName, headers);
        }

        public abstract void onPart(String var1, String var2, HttpFields var3);

        private void notifyPart(String name, String fileName, HttpFields headers) {
            block2: {
                try {
                    this.onPart(name, fileName, headers);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying part {}", (Object)name, (Object)x);
                }
            }
        }
    }

    public static class Parser {
        private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
        private static final ByteBuffer CR = StandardCharsets.US_ASCII.encode("\r");
        private final Utf8StringBuilder text = new Utf8StringBuilder();
        private final String boundary;
        private final SearchPattern boundaryFinder;
        private final Listener listener;
        private int partHeadersLength;
        private int partHeadersMaxLength = -1;
        private State state;
        private int partialBoundaryMatch;
        private boolean crFlag;
        private boolean crContent;
        private int trailingWhiteSpaces;
        private String fieldName;
        private String fieldValue;

        public Parser(String boundary, Listener listener) {
            this.boundary = boundary;
            this.boundaryFinder = SearchPattern.compile((String)("\n--" + boundary));
            this.listener = listener;
            this.reset();
        }

        public String getBoundary() {
            return this.boundary;
        }

        public int getPartHeadersMaxLength() {
            return this.partHeadersMaxLength;
        }

        public void setPartHeadersMaxLength(int partHeadersMaxLength) {
            this.partHeadersMaxLength = partHeadersMaxLength;
        }

        public void reset() {
            this.text.reset();
            this.partHeadersLength = 0;
            this.state = State.PREAMBLE;
            this.partialBoundaryMatch = 1;
            this.crFlag = false;
            this.crContent = false;
            this.trailingWhiteSpaces = 0;
            this.fieldName = null;
            this.fieldValue = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void parse(Content.Chunk chunk) {
            ByteBuffer buffer = chunk.getByteBuffer();
            boolean last = chunk.isLast();
            try {
                block13: while (true) {
                    if (!buffer.hasRemaining()) {
                        if (!last) return;
                        if (this.state != State.EPILOGUE) throw new EOFException("unexpected EOF");
                        this.notifyComplete();
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("parse {} {}", (Object)this.state, (Object)BufferUtil.toDetailString((ByteBuffer)buffer));
                    }
                    switch (this.state) {
                        case PREAMBLE: {
                            if (!this.parsePreamble(buffer)) continue block13;
                            this.state = State.BOUNDARY;
                            break;
                        }
                        case BOUNDARY: {
                            HttpTokens.Token token = this.next(buffer);
                            HttpTokens.Type type = token.getType();
                            if (type == HttpTokens.Type.CR) continue block13;
                            if (type == HttpTokens.Type.LF) {
                                this.notifyPartBegin();
                                this.state = State.HEADER_START;
                                this.trailingWhiteSpaces = 0;
                                this.text.reset();
                                this.partHeadersLength = 0;
                                break;
                            }
                            if (token.getByte() == 45) {
                                this.state = State.BOUNDARY_CLOSE;
                                break;
                            }
                            if (type == HttpTokens.Type.SPACE || type == HttpTokens.Type.HTAB) continue block13;
                            throw new BadMessageException("bad last boundary");
                        }
                        case BOUNDARY_CLOSE: {
                            HttpTokens.Token token = this.next(buffer);
                            if (token.getByte() != 45) {
                                throw new BadMessageException("bad last boundary");
                            }
                            this.state = State.EPILOGUE;
                            break;
                        }
                        case HEADER_START: {
                            this.state = this.parseHeaderStart(buffer);
                            break;
                        }
                        case HEADER_NAME: {
                            if (!this.parseHeaderName(buffer)) continue block13;
                            this.state = State.HEADER_VALUE;
                            break;
                        }
                        case HEADER_VALUE: {
                            if (!this.parseHeaderValue(buffer)) continue block13;
                            this.state = State.HEADER_START;
                            break;
                        }
                        case CONTENT_START: {
                            if (this.parseContent(chunk)) {
                                this.state = State.BOUNDARY;
                                break;
                            }
                            this.state = State.CONTENT;
                            break;
                        }
                        case CONTENT: {
                            if (!this.parseContent(chunk)) continue block13;
                            this.state = State.BOUNDARY;
                            break;
                        }
                        case EPILOGUE: {
                            buffer.position(buffer.limit());
                            continue block13;
                        }
                    }
                }
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("parse failure {} {}", new Object[]{this.state, BufferUtil.toDetailString((ByteBuffer)buffer), x});
                }
                buffer.position(buffer.limit());
                this.notifyFailure(x);
            }
        }

        private HttpTokens.Token next(ByteBuffer buffer) {
            byte b = buffer.get();
            HttpTokens.Token t = HttpTokens.TOKENS[b & 0xFF];
            switch (t.getType()) {
                case CNTL: {
                    throw new BadMessageException("invalid byte " + Integer.toHexString(t.getChar()));
                }
                case LF: {
                    this.crFlag = false;
                    break;
                }
                case CR: {
                    if (this.crFlag) {
                        throw new BadMessageException("invalid EOL");
                    }
                    this.crFlag = true;
                    break;
                }
                default: {
                    if (!this.crFlag) break;
                    throw new BadMessageException("invalid EOL");
                }
            }
            return t;
        }

        private boolean parsePreamble(ByteBuffer buffer) {
            int boundaryOffset;
            if (this.partialBoundaryMatch > 0) {
                int boundaryMatch = this.boundaryFinder.startsWith(buffer, this.partialBoundaryMatch);
                if (boundaryMatch > 0) {
                    if (boundaryMatch == this.boundaryFinder.getLength()) {
                        buffer.position(buffer.position() + boundaryMatch - this.partialBoundaryMatch);
                        this.partialBoundaryMatch = 0;
                        return true;
                    }
                    buffer.position(buffer.limit());
                    this.partialBoundaryMatch = boundaryMatch;
                    return false;
                }
                this.partialBoundaryMatch = 0;
            }
            if ((boundaryOffset = this.boundaryFinder.match(buffer)) >= 0) {
                buffer.position(buffer.position() + boundaryOffset + this.boundaryFinder.getLength());
                return true;
            }
            this.partialBoundaryMatch = this.boundaryFinder.endsWith(buffer);
            buffer.position(buffer.limit());
            return false;
        }

        private State parseHeaderStart(ByteBuffer buffer) {
            block5: while (buffer.hasRemaining()) {
                HttpTokens.Token token = this.next(buffer);
                switch (token.getType()) {
                    case CR: {
                        continue block5;
                    }
                    case LF: {
                        this.notifyPartHeaders();
                        this.partialBoundaryMatch = 1;
                        return State.CONTENT_START;
                    }
                    case COLON: {
                        throw new BadMessageException("invalid empty header name");
                    }
                }
                if (Character.isWhitespace(token.getByte())) {
                    if (this.text.length() != 0) continue;
                    throw new BadMessageException("invalid leading whitespace before header");
                }
                this.incrementAndCheckPartHeadersLength();
                this.text.append(token.getByte());
                return State.HEADER_NAME;
            }
            return State.HEADER_START;
        }

        private boolean parseHeaderName(ByteBuffer buffer) {
            block4: while (buffer.hasRemaining()) {
                byte current;
                HttpTokens.Token token = this.next(buffer);
                switch (token.getType()) {
                    case COLON: {
                        this.incrementAndCheckPartHeadersLength();
                        this.fieldName = this.text.toString();
                        this.trailingWhiteSpaces = 0;
                        this.text.reset();
                        return true;
                    }
                    case ALPHA: 
                    case DIGIT: 
                    case TCHAR: {
                        current = token.getByte();
                        if (this.trailingWhiteSpaces > 0) {
                            throw new BadMessageException("invalid header name");
                        }
                        this.incrementAndCheckPartHeadersLength();
                        this.text.append(current);
                        continue block4;
                    }
                }
                current = token.getByte();
                if (Character.isWhitespace(current)) {
                    this.incrementAndCheckPartHeadersLength();
                    ++this.trailingWhiteSpaces;
                    continue;
                }
                throw new BadMessageException("invalid header name");
            }
            return false;
        }

        private boolean parseHeaderValue(ByteBuffer buffer) {
            block4: while (buffer.hasRemaining()) {
                HttpTokens.Token token = this.next(buffer);
                switch (token.getType()) {
                    case CR: {
                        continue block4;
                    }
                    case LF: {
                        this.fieldValue = this.text.toString().stripTrailing();
                        this.text.reset();
                        this.notifyPartHeader(this.fieldName, this.fieldValue);
                        this.fieldName = null;
                        this.fieldValue = null;
                        return true;
                    }
                }
                byte current = token.getByte();
                this.incrementAndCheckPartHeadersLength();
                if (Character.isWhitespace(current)) {
                    if (this.text.length() <= 0) continue;
                    this.text.append(" ");
                    continue;
                }
                this.text.append(current);
            }
            return false;
        }

        private void incrementAndCheckPartHeadersLength() {
            ++this.partHeadersLength;
            int max = this.getPartHeadersMaxLength();
            if (max > 0 && this.partHeadersLength > max) {
                throw new IllegalStateException("headers max length exceeded: %d".formatted(max));
            }
        }

        private boolean parseContent(Content.Chunk chunk) {
            int sliceLimit;
            ByteBuffer buffer = chunk.getByteBuffer();
            if (this.partialBoundaryMatch > 0) {
                int boundaryMatch = this.boundaryFinder.startsWith(buffer, this.partialBoundaryMatch);
                if (boundaryMatch > 0) {
                    if (boundaryMatch == this.boundaryFinder.getLength()) {
                        buffer.position(buffer.position() + boundaryMatch - this.partialBoundaryMatch);
                        this.partialBoundaryMatch = 0;
                        this.notifyPartContent(Content.Chunk.EOF);
                        this.notifyPartEnd();
                        return true;
                    }
                    buffer.position(buffer.limit());
                    this.partialBoundaryMatch = boundaryMatch;
                    return false;
                }
                if (this.state == State.CONTENT_START) {
                    this.partialBoundaryMatch = 0;
                    return false;
                }
                if (this.crContent) {
                    this.crContent = false;
                    this.notifyPartContent(Content.Chunk.from((ByteBuffer)CR.slice(), (boolean)false));
                }
                ByteBuffer content = ByteBuffer.wrap(this.boundaryFinder.getPattern(), 0, this.partialBoundaryMatch);
                this.partialBoundaryMatch = 0;
                this.notifyPartContent(Content.Chunk.from((ByteBuffer)content, (boolean)false));
                return false;
            }
            int boundaryOffset = this.boundaryFinder.match(buffer);
            if (boundaryOffset >= 0) {
                int sliceLimit2 = buffer.position() + boundaryOffset;
                if (sliceLimit2 > 0 && buffer.get(sliceLimit2 - 1) == 13) {
                    --sliceLimit2;
                }
                Content.Chunk content = chunk.slice(buffer.position(), sliceLimit2, true);
                buffer.position(buffer.position() + boundaryOffset + this.boundaryFinder.getLength());
                this.notifyPartContent(content);
                this.notifyPartEnd();
                return true;
            }
            this.partialBoundaryMatch = this.boundaryFinder.endsWith(buffer);
            if (this.partialBoundaryMatch > 0) {
                int sliceLimit3 = buffer.limit() - this.partialBoundaryMatch;
                if (sliceLimit3 > 0 && buffer.get(sliceLimit3 - 1) == 13) {
                    this.crContent = true;
                    --sliceLimit3;
                }
                Content.Chunk content = chunk.slice(buffer.position(), sliceLimit3, false);
                buffer.position(buffer.limit());
                if (content.hasRemaining()) {
                    this.notifyPartContent(content);
                }
                return false;
            }
            if (this.crContent) {
                this.crContent = false;
                this.notifyPartContent(Content.Chunk.from((ByteBuffer)CR.slice(), (boolean)false));
            }
            if (buffer.get((sliceLimit = buffer.limit()) - 1) == 13) {
                this.crContent = true;
                --sliceLimit;
            }
            Content.Chunk content = chunk.slice(buffer.position(), sliceLimit, false);
            buffer.position(buffer.limit());
            if (content.hasRemaining()) {
                this.notifyPartContent(content);
            }
            return false;
        }

        private void notifyPartBegin() {
            block2: {
                try {
                    this.listener.onPartBegin();
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying listener {}", (Object)this.listener, (Object)x);
                }
            }
        }

        private void notifyPartHeader(String name, String value) {
            block2: {
                try {
                    this.listener.onPartHeader(name, value);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying listener {}", (Object)this.listener, (Object)x);
                }
            }
        }

        private void notifyPartHeaders() {
            block2: {
                try {
                    this.listener.onPartHeaders();
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying listener {}", (Object)this.listener, (Object)x);
                }
            }
        }

        private void notifyPartContent(Content.Chunk chunk) {
            block2: {
                try {
                    this.listener.onPartContent(chunk);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying listener {}", (Object)this.listener, (Object)x);
                }
            }
        }

        private void notifyPartEnd() {
            block2: {
                try {
                    this.listener.onPartEnd();
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying listener {}", (Object)this.listener, (Object)x);
                }
            }
        }

        private void notifyComplete() {
            block2: {
                try {
                    this.listener.onComplete();
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying listener {}", (Object)this.listener, (Object)x);
                }
            }
        }

        private void notifyFailure(Throwable failure) {
            block2: {
                try {
                    this.listener.onFailure(failure);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying listener {}", (Object)this.listener, (Object)x);
                }
            }
        }

        public static interface Listener {
            default public void onPartBegin() {
            }

            default public void onPartHeader(String name, String value) {
            }

            default public void onPartHeaders() {
            }

            default public void onPartContent(Content.Chunk chunk) {
            }

            default public void onPartEnd() {
            }

            default public void onComplete() {
            }

            default public void onFailure(Throwable failure) {
            }
        }

        private static enum State {
            PREAMBLE,
            BOUNDARY,
            BOUNDARY_CLOSE,
            HEADER_START,
            HEADER_NAME,
            HEADER_VALUE,
            CONTENT_START,
            CONTENT,
            EPILOGUE;

        }
    }

    public static abstract class AbstractContentSource
    implements Content.Source,
    Closeable {
        private final AutoLock lock = new AutoLock();
        private final SerializedInvoker invoker = new SerializedInvoker();
        private final Queue<Part> parts = new ArrayDeque<Part>();
        private final String boundary;
        private final ByteBuffer firstBoundary;
        private final ByteBuffer middleBoundary;
        private final ByteBuffer onlyBoundary;
        private final ByteBuffer lastBoundary;
        private int partHeadersMaxLength = -1;
        private State state = State.FIRST;
        private boolean closed;
        private Runnable demand;
        private Content.Chunk.Error errorChunk;
        private Part part;

        public AbstractContentSource(String boundary) {
            if (boundary.isBlank() || boundary.length() > 70) {
                throw new IllegalArgumentException("Invalid boundary: must consists of 1 to 70 characters");
            }
            this.boundary = boundary = boundary.stripTrailing();
            String firstBoundaryLine = "--" + boundary + "\r\n";
            this.firstBoundary = ByteBuffer.wrap(firstBoundaryLine.getBytes(StandardCharsets.US_ASCII));
            String middleBoundaryLine = "\r\n" + firstBoundaryLine;
            this.middleBoundary = ByteBuffer.wrap(middleBoundaryLine.getBytes(StandardCharsets.US_ASCII));
            String onlyBoundaryLine = "--" + boundary + "--\r\n";
            this.onlyBoundary = ByteBuffer.wrap(onlyBoundaryLine.getBytes(StandardCharsets.US_ASCII));
            String lastBoundaryLine = "\r\n" + onlyBoundaryLine;
            this.lastBoundary = ByteBuffer.wrap(lastBoundaryLine.getBytes(StandardCharsets.US_ASCII));
        }

        public String getBoundary() {
            return this.boundary;
        }

        public int getPartHeadersMaxLength() {
            return this.partHeadersMaxLength;
        }

        public void setPartHeadersMaxLength(int partHeadersMaxLength) {
            this.partHeadersMaxLength = partHeadersMaxLength;
        }

        public boolean addPart(Part part) {
            boolean wasEmpty;
            try (AutoLock ignored = this.lock.lock();){
                if (this.closed || this.errorChunk != null) {
                    boolean bl = false;
                    return bl;
                }
                wasEmpty = this.parts.isEmpty();
                this.parts.offer(part);
            }
            if (wasEmpty) {
                this.invoker.run(this::invokeDemandCallback);
            }
            return true;
        }

        @Override
        public void close() {
            boolean wasEmpty;
            try (AutoLock ignored = this.lock.lock();){
                this.closed = true;
                wasEmpty = this.parts.isEmpty();
            }
            if (wasEmpty) {
                this.invoker.run(this::invokeDemandCallback);
            }
        }

        public long getLength() {
            return -1L;
        }

        public Content.Chunk read() {
            Content.Chunk chunk;
            try (AutoLock ignored = this.lock.lock();){
                if (this.errorChunk != null) {
                    Content.Chunk.Error error = this.errorChunk;
                    return error;
                }
            }
            switch (this.state) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case FIRST: {
                    Content.Chunk chunk2;
                    AutoLock ignored = this.lock.lock();
                    if (this.parts.isEmpty()) {
                        if (this.closed) {
                            this.state = State.COMPLETE;
                            chunk2 = Content.Chunk.from((ByteBuffer)this.onlyBoundary.slice(), (boolean)true);
                            chunk = chunk2;
                            break;
                        }
                        chunk2 = null;
                        chunk = chunk2;
                        break;
                    }
                    this.part = this.parts.poll();
                    this.state = State.HEADERS;
                    chunk2 = Content.Chunk.from((ByteBuffer)this.firstBoundary.slice(), (boolean)false);
                    chunk = chunk2;
                    break;
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                case MIDDLE: {
                    Content.Chunk chunk2;
                    this.part = null;
                    AutoLock ignored = this.lock.lock();
                    if (this.parts.isEmpty()) {
                        if (this.closed) {
                            this.state = State.COMPLETE;
                            chunk2 = Content.Chunk.from((ByteBuffer)this.lastBoundary.slice(), (boolean)true);
                            chunk = chunk2;
                            break;
                        }
                        chunk2 = null;
                        chunk = chunk2;
                        break;
                    }
                    this.part = this.parts.poll();
                    this.state = State.HEADERS;
                    chunk2 = Content.Chunk.from((ByteBuffer)this.middleBoundary.slice(), (boolean)false);
                    chunk = chunk2;
                    break;
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                case HEADERS: {
                    Content.Chunk chunk2;
                    HttpFields headers = this.customizePartHeaders(this.part);
                    Utf8StringBuilder builder = new Utf8StringBuilder(4096);
                    headers.forEach(field -> {
                        HttpHeader header = field.getHeader();
                        if (header != null) {
                            builder.append(header.getBytesColonSpace());
                        } else {
                            builder.append(field.getName());
                            builder.append(": ");
                        }
                        this.checkPartHeadersLength(builder);
                        String value = field.getValue();
                        if (value != null) {
                            builder.append(value);
                            this.checkPartHeadersLength(builder);
                        }
                        builder.append("\r\n");
                    });
                    builder.append("\r\n");
                    ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(builder.toString());
                    this.state = State.CONTENT;
                    chunk = chunk2 = Content.Chunk.from((ByteBuffer)byteBuffer, (boolean)false);
                    break;
                }
                case CONTENT: {
                    Content.Chunk chunk2;
                    Content.Chunk chunk3 = this.part.getContent().read();
                    if (chunk3 == null || chunk3 instanceof Content.Chunk.Error) {
                        chunk = chunk2 = chunk3;
                        break;
                    }
                    if (chunk3.isLast()) {
                        if (!chunk3.hasRemaining()) {
                            chunk3.release();
                            chunk3 = Content.Chunk.EMPTY;
                        } else {
                            chunk3 = Content.Chunk.from((ByteBuffer)chunk3.getByteBuffer(), (boolean)false, (Retainable)chunk3);
                        }
                        this.state = State.MIDDLE;
                    }
                    chunk = chunk2 = chunk3;
                    break;
                }
                case COMPLETE: {
                    Content.Chunk chunk2;
                    chunk = chunk2 = Content.Chunk.EOF;
                }
            }
            return chunk;
        }

        protected HttpFields customizePartHeaders(Part part) {
            return part.getHeaders();
        }

        private void checkPartHeadersLength(Utf8StringBuilder builder) {
            int max = this.getPartHeadersMaxLength();
            if (max > 0 && builder.length() > max) {
                throw new IllegalStateException("headers max length exceeded: %d".formatted(max));
            }
        }

        public void demand(Runnable demandCallback) {
            boolean invoke = false;
            try (AutoLock ignored = this.lock.lock();){
                if (this.demand != null) {
                    throw new IllegalStateException("demand pending");
                }
                this.demand = Objects.requireNonNull(demandCallback);
                if (this.state == State.CONTENT) {
                    this.part.getContent().demand(() -> {
                        try (AutoLock ignoredAgain = this.lock.lock();){
                            this.demand = null;
                        }
                        demandCallback.run();
                    });
                } else {
                    invoke = !this.parts.isEmpty() || this.closed || this.errorChunk != null;
                }
            }
            if (invoke) {
                this.invoker.run(this::invokeDemandCallback);
            }
        }

        public void fail(Throwable failure) {
            List<Part> drained;
            try (AutoLock ignored = this.lock.lock();){
                if (this.closed && this.parts.isEmpty()) {
                    return;
                }
                if (this.errorChunk != null) {
                    return;
                }
                this.errorChunk = Content.Chunk.from((Throwable)failure);
                drained = List.copyOf(this.parts);
                this.parts.clear();
            }
            drained.forEach(part -> part.getContent().fail(failure));
            this.invoker.run(this::invokeDemandCallback);
        }

        private void invokeDemandCallback() {
            Runnable callback;
            try (AutoLock ignored = this.lock.lock();){
                callback = this.demand;
                this.demand = null;
            }
            if (callback != null) {
                this.runDemandCallback(callback);
            }
        }

        private void runDemandCallback(Runnable callback) {
            try {
                callback.run();
            }
            catch (Throwable x) {
                this.fail(x);
            }
        }

        private static enum State {
            FIRST,
            MIDDLE,
            HEADERS,
            CONTENT,
            COMPLETE;

        }
    }

    public static class ContentSourcePart
    extends Part {
        private final Content.Source content;

        public ContentSourcePart(String name, String fileName, HttpFields fields, Content.Source content) {
            super(name, fileName, fields);
            this.content = content;
        }

        @Override
        public Content.Source getContent() {
            return this.content;
        }

        public String toString() {
            return "%s@%x[name=%s,fileName=%s,length=%d]".formatted(this.getClass().getSimpleName(), this.hashCode(), this.getName(), this.getFileName(), this.content.getLength());
        }
    }

    public static class PathPart
    extends Part {
        private final PathContentSource content;

        public PathPart(String name, String fileName, HttpFields fields, Path path) {
            super(name, fileName, fields);
            this.content = new PathContentSource(path);
        }

        public Path getPath() {
            return this.content.getPath();
        }

        @Override
        public Content.Source getContent() {
            return this.content;
        }

        @Override
        public void writeTo(Path path) throws IOException {
            Files.move(this.getPath(), path, StandardCopyOption.REPLACE_EXISTING);
        }

        public void delete() {
            try {
                Files.delete(this.getPath());
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        }

        public String toString() {
            return "%s@%x[name=%s,fileName=%s,path=%s]".formatted(this.getClass().getSimpleName(), this.hashCode(), this.getName(), this.getFileName(), this.getPath());
        }
    }

    public static class ChunksPart
    extends Part {
        private final Content.Source content;
        private final long length;

        public ChunksPart(String name, String fileName, HttpFields fields, List<Content.Chunk> content) {
            super(name, fileName, fields);
            this.content = new ChunksContentSource(content);
            this.length = content.stream().mapToLong(c -> c.getByteBuffer().remaining()).sum();
        }

        @Override
        public Content.Source getContent() {
            return this.content;
        }

        public String toString() {
            return "%s@%x[name=%s,fileName=%s,length=%d]".formatted(this.getClass().getSimpleName(), this.hashCode(), this.getName(), this.getFileName(), this.length);
        }
    }

    public static class ByteBufferPart
    extends Part {
        private final Content.Source content;
        private final long length;

        public ByteBufferPart(String name, String fileName, HttpFields fields, ByteBuffer ... buffers) {
            this(name, fileName, fields, List.of(buffers));
        }

        public ByteBufferPart(String name, String fileName, HttpFields fields, List<ByteBuffer> content) {
            super(name, fileName, fields);
            this.content = new ByteBufferContentSource(content);
            this.length = content.stream().mapToLong(Buffer::remaining).sum();
        }

        @Override
        public Content.Source getContent() {
            return this.content;
        }

        public String toString() {
            return "%s@%x[name=%s,fileName=%s,length=%d]".formatted(this.getClass().getSimpleName(), this.hashCode(), this.getName(), this.getFileName(), this.length);
        }
    }

    public static abstract class Part {
        private final String name;
        private final String fileName;
        private final HttpFields fields;

        public Part(String name, String fileName, HttpFields fields) {
            this.name = name;
            this.fileName = fileName;
            this.fields = fields != null ? fields : HttpFields.EMPTY;
        }

        public String getName() {
            return this.name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public abstract Content.Source getContent();

        public String getContentAsString(Charset defaultCharset) {
            try {
                Charset charset;
                String contentType = this.getHeaders().get(HttpHeader.CONTENT_TYPE);
                String charsetName = MimeTypes.getCharsetFromContentType(contentType);
                Charset charset2 = charset = defaultCharset != null ? defaultCharset : StandardCharsets.UTF_8;
                if (charsetName != null) {
                    charset = Charset.forName(charsetName);
                }
                return Content.Source.asString((Content.Source)this.getContent(), (Charset)charset);
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        }

        public HttpFields getHeaders() {
            return this.fields;
        }

        public void writeTo(Path path) throws IOException {
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                IO.copy((InputStream)Content.Source.asInputStream((Content.Source)this.getContent()), (OutputStream)out);
            }
        }
    }
}

