/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.thread.AutoLock;

public interface HttpCookieStore {
    public boolean add(URI var1, HttpCookie var2);

    public List<HttpCookie> all();

    public List<HttpCookie> match(URI var1);

    public boolean remove(URI var1, HttpCookie var2);

    public boolean clear();

    public static class Default
    implements HttpCookieStore {
        private final AutoLock lock = new AutoLock();
        private final Map<Key, List<HttpCookie>> cookies = new HashMap<Key, List<HttpCookie>>();

        @Override
        public boolean add(URI uri, HttpCookie cookie) {
            boolean secure = HttpScheme.isSecure(uri.getScheme());
            if (cookie.isSecure() && !secure) {
                return false;
            }
            String cookieDomain = cookie.getDomain();
            if (cookieDomain != null) {
                if ((cookieDomain = cookieDomain.toLowerCase(Locale.ENGLISH)).startsWith(".")) {
                    cookieDomain = cookieDomain.substring(1);
                }
                if (cookieDomain.endsWith(".")) {
                    cookieDomain = uri.getHost();
                }
                if (!cookieDomain.contains(".") && !cookieDomain.equals("localhost")) {
                    return false;
                }
                String domain = uri.getHost();
                if (domain != null) {
                    if (!(domain = domain.toLowerCase(Locale.ENGLISH)).endsWith(cookieDomain)) {
                        return false;
                    }
                    int beforeMatch = domain.length() - cookieDomain.length() - 1;
                    if (beforeMatch >= 0 && domain.charAt(beforeMatch) != '.') {
                        return false;
                    }
                }
            } else {
                cookieDomain = uri.getHost();
            }
            Key key = new Key(uri.getScheme(), cookieDomain);
            boolean[] result = new boolean[]{true};
            try (AutoLock ignored = this.lock.lock();){
                this.cookies.compute(key, (k, v) -> {
                    if (v != null) {
                        v.remove(cookie);
                    }
                    if (cookie.isExpired()) {
                        result[0] = false;
                        return v == null || v.isEmpty() ? null : v;
                    }
                    if (v == null) {
                        v = new ArrayList<Cookie>();
                    }
                    v.add(new Cookie(cookie));
                    return v;
                });
            }
            return result[0];
        }

        @Override
        public List<HttpCookie> all() {
            try (AutoLock ignored = this.lock.lock();){
                List<HttpCookie> list = this.cookies.values().stream().flatMap(Collection::stream).toList();
                return list;
            }
        }

        @Override
        public List<HttpCookie> match(URI uri) {
            ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
            String scheme = uri.getScheme();
            boolean secure = HttpScheme.isSecure(scheme);
            String uriDomain = uri.getHost();
            String path = uri.getPath();
            if (path == null || path.trim().isEmpty()) {
                path = "/";
            }
            try (AutoLock ignored = this.lock.lock();){
                int dot;
                String domain = uriDomain;
                do {
                    Key key;
                    List<HttpCookie> stored;
                    Iterator<Object> iterator;
                    Iterator<Object> iterator2 = iterator = (stored = this.cookies.get(key = new Key(scheme, domain))) == null ? Collections.emptyIterator() : stored.iterator();
                    while (iterator.hasNext()) {
                        HttpCookie cookie = (HttpCookie)iterator.next();
                        if (cookie.isExpired()) {
                            iterator.remove();
                            continue;
                        }
                        if (cookie.isSecure() && !secure || !Default.domainMatches(uriDomain, key.domain, cookie.getDomain()) || !Default.pathMatches(path, cookie.getPath())) continue;
                        result.add(cookie);
                    }
                    dot = domain.indexOf(46);
                    if (dot >= 0) continue;
                    break;
                } while ((domain = domain.substring(dot + 1)).indexOf(46) >= 0);
            }
            return result;
        }

        private static boolean domainMatches(String uriDomain, String domain, String cookieDomain) {
            if (uriDomain == null) {
                return true;
            }
            if (domain != null) {
                domain = domain.toLowerCase(Locale.ENGLISH);
            }
            uriDomain = uriDomain.toLowerCase(Locale.ENGLISH);
            if (cookieDomain != null) {
                cookieDomain = cookieDomain.toLowerCase(Locale.ENGLISH);
            }
            if (cookieDomain == null || cookieDomain.endsWith(".")) {
                return uriDomain.equals(domain);
            }
            if (cookieDomain.startsWith(".")) {
                cookieDomain = cookieDomain.substring(1);
            }
            if (uriDomain.endsWith(cookieDomain)) {
                int beforeMatch = uriDomain.length() - cookieDomain.length() - 1;
                if (beforeMatch == -1) {
                    return true;
                }
                return uriDomain.charAt(beforeMatch) == '.';
            }
            return false;
        }

        private static boolean pathMatches(String path, String cookiePath) {
            if (cookiePath == null) {
                return true;
            }
            if (path.equals(cookiePath)) {
                return true;
            }
            if (path.startsWith(cookiePath)) {
                return cookiePath.endsWith("/") || path.charAt(cookiePath.length()) == '/';
            }
            return false;
        }

        @Override
        public boolean remove(URI uri, HttpCookie cookie) {
            Key key = new Key(uri.getScheme(), uri.getHost());
            try (AutoLock ignored = this.lock.lock();){
                boolean[] result = new boolean[1];
                this.cookies.compute(key, (k, v) -> {
                    boolean removed;
                    if (v == null) {
                        return null;
                    }
                    result[0] = removed = v.remove(cookie);
                    return v.isEmpty() ? null : v;
                });
                boolean bl = result[0];
                return bl;
            }
        }

        @Override
        public boolean clear() {
            try (AutoLock ignored = this.lock.lock();){
                if (this.cookies.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                this.cookies.clear();
                boolean bl = true;
                return bl;
            }
        }

        private record Key(String scheme, String domain) {
            private Key(String scheme, String domain) {
                this.scheme = scheme;
                this.domain = domain.toLowerCase(Locale.ENGLISH);
            }
        }

        private static class Cookie
        extends HttpCookie.Wrapper {
            private final long creationNanoTime = NanoTime.now();

            public Cookie(HttpCookie wrapped) {
                super(wrapped);
            }

            @Override
            public boolean isExpired() {
                long maxAge = this.getMaxAge();
                if (maxAge >= 0L && NanoTime.secondsSince((long)this.creationNanoTime) > maxAge) {
                    return true;
                }
                Instant expires = this.getExpires();
                return expires != null && Instant.now().isAfter(expires);
            }
        }
    }

    public static class Empty
    implements HttpCookieStore {
        @Override
        public boolean add(URI uri, HttpCookie cookie) {
            return false;
        }

        @Override
        public List<HttpCookie> all() {
            return List.of();
        }

        @Override
        public List<HttpCookie> match(URI uri) {
            return List.of();
        }

        @Override
        public boolean remove(URI uri, HttpCookie cookie) {
            return false;
        }

        @Override
        public boolean clear() {
            return false;
        }
    }
}

